

package apputil;
import java.io.*;


/**
The TestHarness class is a very simple module that loads a class under
test that has implemented the Testable interface, and exercises it by
calling its TestUnit method. This method will return a true if the
test passes, or a false if it fails.<p>
This test harness is very rudimentary. To extend the functionality of
this class, you may wish to add the following:<p>
<ul>
<li>User interface that allows the user to select class to test
<li>Logging capabilities (allow units under test to log errors
<li>more sophisticated handling of multiple test units
</ul>
*/
public class TestHarness
{
	/**
	The main method runs the test harness. Any classes specified on the command
	line will be loaded and tested. 
	*/
	public static void main(String args[])
	{
		int numTests = args.length;
		
		int currentTestUnit = 0;
		Testable unitUnderTest;
		boolean[] results = new boolean[numTests];
		AppConfig test;

		try
		{
					test = new AppConfig("c:\\work\\wrox\\case_study\\code\\BugTrackerApp\\BUGTRACKER.PROPS");
		 }
		catch (IOException ioe) 
		{
		  		System.out.println("WARNING: Application properties not loaded!");
		  	  System.exit(0);		 
		 }
		
		for (int n = 0; n < numTests; n++)
		{
			try
			{
				Class unitClass = Class.forName(args[n]);
				unitUnderTest = (apputil.Testable)unitClass.newInstance();
				
				results[n] = unitUnderTest.TestUnit();
				System.out.println("Unit " + args[n] + " : " 
					+ (results[n]?"passed":"failed"));
				}
				
			catch (InstantiationException inste)
			{
				System.out.println(args[n] + " can't be instantiated!\n(did you include a default constructor?)");
			}
			
			catch (IllegalAccessException iae)
			{
				System.out.println("IllegalAccess exception loading " + args[n]);
			}
			catch (ClassCastException cce)
			{
				System.out.println(args[n] + " can't be cast as Testable");
			}
			catch (ClassNotFoundException cnfe)
			{
				System.out.println(args[n] + " can't be loaded");				
			}
				
		}
	}
}