

package apputil;

/**
		This interface specifies that a class can be tested using a simple
		testing harness. It defines a single method that must be implemented
		by any class that implements Testable. Note that the class under test
		must provide a default constructor to support this functionality.
*/
public interface Testable
{
	
	/**
	The TestUnit method is a method that is called by the testing
	harness to exercise a unit. The scope of the test is determined by the
	implementing class. The TestUnit method must return a boolean true if
	the test passes, and a false if it fails.
	@return returns boolean true for pass, false for failure
	*/
	public boolean TestUnit();
		
}	
	
	