/**
apputil.util class provides basic utility methods for the application


*/

package apputil;

import java.text.*;
import java.util.*;

/**
This class provides commonly used utility methods throughout the application.
*/
public class util
{
	/**
	converts a date string to a long value. The long value is defined by 
	the java.util.Date class, as returned by the getTime method.
	*/
	public static long DateStringToLong(String d) throws java.text.ParseException
	{
	
		SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
		Date dt = sdf.parse(d);  
		return dt.getTime();
		
	}


	/**
	converts a long value into a date expression in the form dd-MMM-yyyy. 
	*/	
	public static String LongToDateString(long d)
	{
		SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
		Date dt = new Date(d);
		String retval = sdf.format(dt);
		return retval;
		
	}
	
	/**
	Finds the position of a String within a String array. 
	@param theArray the string array to search
	@param theString the string to find in the array
	@exception ArrayIndexOutOfBounds thrown if the string cannot be found in the array
	*/
	public static int getPosInArray(String[] theArray, String theString) throws ArrayIndexOutOfBoundsException
	{
		int retval;
		int nPos;
		retval = nPos = 0;
		while (nPos < theArray.length)
		{
			if (theString.equals(theArray[nPos]))
				retval = nPos;
			nPos++;	
		}
		if (nPos > theArray.length)
			throw new ArrayIndexOutOfBoundsException();
				
		return retval;
	}
}