//Source file: c:/work/wrox/case_study/code/BugTrackerApp/businessmodel/Defect.java

package businessmodel;

import java.util.*;
import apputil.*;

/**
Defect class, implements the _DefectIntfOperations interface used by the tie
class generated by idltojava. This class encapsulates reported defects.
*/
public class Defect implements _DefectIntfOperations, apputil.Testable 
{
	protected int m_defectID;
	protected int m_state;
	protected int m_priority;
	protected int m_severity;
	protected String m_product;
	protected String m_versionReported;
	protected String m_subsystem;
	protected String m_defectSummary;
	protected String m_defectDetails;
	protected String m_reportedBy;
	protected String m_assignedTo;
	protected long m_dateReported;
	protected long m_dateLastChanged;
	protected String m_resolutionNotes;
	protected String m_changedModules;
	protected String m_changedMailList;
	protected String m_resolvedMailList;
	protected String m_versionResolved;
	protected String m_ExternalId;
	
	/**
	Default constructor
	*/
	public Defect()
	{
		// initialize values to defaults
		m_defectID = 0;
		m_state = 0;
		m_priority = 0;
		m_severity = 0;
		m_product = "";
		m_versionReported = "";
		m_subsystem = "";
		m_defectSummary = "";
		m_defectDetails = "";
		m_reportedBy = "";
		m_assignedTo = "";
		m_dateReported = 0;
		m_dateLastChanged = 0;
		m_resolutionNotes = "";
		m_changedModules = "";
		m_changedMailList = "";
		m_resolvedMailList = "";
		m_versionResolved = "";
		m_ExternalId = "";
	}
	
	/**
	Accessor method
	@param id defect id
	 */
	public void setDefectID(int id) {
    	this.m_defectID = id;
    }
	
	/**
	Accessor method
	@param state defect state	
	 */
	public void setState(int state) {
    	this.m_state = state;
    }
	
	/**
	Accessor method
	@param priority defect priority
	 */
	public void setPriority(int priority) {
    		this.m_priority = priority;
    }
	
	/**
	Accessor method
	@param severity defect severity
	 */
	public void setSeverity(int severity) {
    		this.m_severity = severity;
    }
	
	/**
	Accessor method
	@param product product name
	 */
	public void setProduct(String product) {
    		this.m_product = product.trim();
    }
	
	/**
	Accessor method
	@param versionReported version of product that defect was reported against
	 */
	public void setVersionReported(String versionReported) {
    		this.m_versionReported = versionReported.trim();
    }
	
	/**
	Accessor method
	@param subsystem sub-section of product that the defect was reported against
	 */
	public void setSubsystem(String subsystem) {
    		this.m_subsystem = subsystem.trim();
    }
	
	/**
	Accessor method
	@param summary short description of defect
	 */
	public void setDefectSummary(String summary) {
    		this.m_defectSummary = summary.trim();
    }
	
	/**
	Accessor method
	@param details detailed description of defect, steps to reproduce, etc.
	 */
	public void setDefectDetails(String details) {
    		this.m_defectDetails = details.trim();
    }
	
	/**
	Accessor method
	@param rep id of person entering defect
	 */
	public void setReportedBy(String rep) {
    		this.m_reportedBy = rep.trim();
    }
	
	/**
	Accessor method
	@param assgn id of person to which the defect was assigned for resolution
	 */
	public void setAssignedTo(String assgn) {
    		this.m_assignedTo = assgn.trim();
    }
	
	/**
	Accessor method
	@param resnotes a description of what was done to resolve the defect
	 */
	public void setResolutionNotes(String resnotes) {
    		this.m_resolutionNotes = resnotes.trim();
    }
	
	/**
	Accessor method
	@param modnames name of software modules changed to resolve the defect
	 */
	public void setChangedModules(String modnames) {
    		this.m_changedModules = modnames.trim();
    }
	
	/**
	Accessor method
	@param maillist delimited list of mail addresses to send updates to when the defect is changed
	 */
	public void setChangedMailList(String maillist) {
    		this.m_changedMailList = maillist.trim();
    }
	
	/**
	Accessor method
	@param maillist  delimited list of mail addresses to send updates to when the defect is closed as fixed
	 */
	public void setResolvedMailList(String maillist) {
    		this.m_resolvedMailList = maillist.trim();
    }
	
	/**
	Accessor method
	@param versionResolved version of product that the fix will be integrated into   
	 */
	public void setVersionResolved(String versionResolved) {
    		this.m_versionResolved = versionResolved.trim();
    }
	
	/**
	Accessor method
	@param daterep Date object indicating date reported. 
	 */
	public void setDateReported(java.util.Date daterep) {
    		this.setDateReported(daterep.getTime());
    }

	
	/**
	Accessor method
	@param daterep long value indicating date reported. Value is milliseconds since the epoch (see java.util.Date)
	 */
	public void setDateReported(long daterep) {
    		this.m_dateReported = daterep;
    }


	/**
	Accessor method
	@param daterep Date object indicating date reported. 
	 */
	public void setDateLastChanged(java.util.Date daterep) {
    		this.setDateLastChanged(daterep.getTime());
    }
	
	/**
	Accessor method
	@param changed long value indicating date changed. Value is milliseconds since the epoch (see java.util.Date)
	 */
	public void setDateLastChanged(long changed) {
    		this.m_dateLastChanged = changed;
    }

  /**
  Accessor method
  @param id external case identifier for defect (references other documents, such as incidence reports, etc.)
  */  
  public void setExternalId(String id)
	{
		m_ExternalId = id;
	}  
	
	/**
	Accessor method
	@return returns integer value of defect ID
	 */
	public int getDefectID() {
    		return this.m_defectID;
    }
	
	/**
	Accessor method
	@return returns state of defect
	@see businessmodel.DefectState
	 */
	public int getState() {
			return this.m_state;
    }
	
	/**
	Accessor method
	@return returns priority for defect
	@see businessmodel.DefectPriority
	 */
	public int getPriority() {
			return this.m_priority;
    }
	
	/**
	Accessor method
	@return returns severity for defect
	@see businessmodel.DefectSeverity
  */
	public int getSeverity() {
			return this.m_severity;
    }
	
	/**
	Accessor method
	@return returns name of product defect was reported against
		 */
	public String getProduct() {
			return this.m_product;
    }
	
	/**
	Accessor method
	@return returns version of product defect was reported against
	 */
	public String getVersionReported() {
			return this.m_versionReported;
    }
	
	/**
	Accessor method
	@return returns subsystem of product for which defect was reported
	 */
	public String getSubsystem() {
			return this.m_subsystem;
    }
	
	/**
	Accessor method
	@return returns short summary of defect
	 */
	public String getDefectSummary() {
			return this.m_defectSummary;
    }
	
	/**
	Accessor method
	@return returns detailed description of defect
	 */
	public String getDefectDetails() {
			return this.m_defectDetails;
    }
	
	/**
	Accessor method
	@return returns id of user that entered defect
	 */
	public String getReportedBy() {
			return this.m_reportedBy;
    }
	
	/**
	Accessor method
	@return returns id of user that the defect has been assigned to
	 */
	public String getAssignedTo() {
			return this.m_assignedTo;
    }
	
	
	/**
	Accessor method
	@return returns notes describing the resolution of the defect
	 */
	public String getResolutionNotes() {
			return this.m_resolutionNotes;
    }
	
	/**
	Accessor method
	@return returns delimited list of modules that were changed to resolve the defect
	 */
	public String getChangedModules() {
			return this.m_changedModules;
    }
	
	/**
	Accessor method
	@return returns a delimited list of email addresses that will receive notification when the defect is changed
	 */
	public String getChangedMailList() {
			return this.m_changedMailList;
    }
	
	/**
	Accessor method
	@return returns a delimited list of email addresses that will receive notification when the defect is resolved
	 */
	public String getResolvedMailList() {
    		return this.m_resolvedMailList;
	}
	
	/**
	Accessor method
	@return returns the version of the product that will contain the fix for the defect
	 */
	public String getVersionResolved() {
			return this.m_versionResolved;
    }
	
	/**
	Accessor method
	@return returns long value for date that the defect was reported
	 */
	public long getDateReported() {
			return this.m_dateReported;
    }
	
	/**
	Accessor method
	@return returns long value for the date that the defect was last changed
	 */
	public long getDateLastChanged() {
			return this.m_dateLastChanged;
    }
    
	/**
	Acessor method
	*/    
  public String getExternalId()
	{
		return m_ExternalId;
	}  
  
  
  /**
  Applies all changes made  to the Defect
  @param userid id of user applying commit
  @exception UpdateException thrown if the defect cannot be changed
  @exception AppSecurityException thrown if the user does not have sufficient privileges
  */  
  public void commit(String userid) throws UpdateException, AppSecurityException
	{
			Date rightNow = new Date();
			this.m_dateLastChanged = 	rightNow.getTime();	
		
	}
    
  /**
  Creates a string representing the internal defect state 
  @return returns text representation of the defect
  */  
  public String toString()
	{
		return new String("Defect {" + 
		"m_defectID = " + m_defectID + 
		", m_state = " + m_state + 
		", m_priority = " + m_priority +
		", m_severity = " + m_severity +
		", m_product = " + m_product +
		", m_versionReported = " + m_versionReported +
		", m_subsystem = " + m_subsystem +
		", m_defectSummary = " + m_defectSummary +
		", m_defectDetails = " + m_defectDetails +
		", m_reportedBy = " + m_reportedBy +
		", m_assignedTo = " + m_assignedTo +
		", m_dateReported = " + m_dateReported +
		", m_dateLastChanged = " + m_dateLastChanged +
		", m_resolutionNotes = " + m_resolutionNotes + 
		", m_changedModules = " + m_changedModules +
		", m_changedMailList = " + m_changedMailList +
		", m_resolvedMailList = " + m_resolvedMailList +
		", m_versionResolved = " + m_versionResolved
		+ "}\n");
		
	}
	
	
	/**
	@return returns the state of the Defect as XML
	*/
	public String exportToXML()
	{
		
		String retval;
		
		retval = "<?xml version = \"1.0\" standalone=\"no\" ?>\n";
		retval = retval + "<!DOCTYPE bugreport SYSTEM \"defect.dtd\">\n";
		retval = retval + "<bugreport>\n";

		retval = retval + "<id>" + this.getDefectID();
		retval = retval + "</id>\n";
		 			
		retval = retval + "<state>" + DefectState.stateNames[this.getState()];
		retval = retval + "</state>\n";
					
		retval = retval + "<severity>" + DefectSeverity.severityNames[this.getSeverity()];
		retval = retval + "</severity>\n";
			
		retval = retval + "<priority>" + DefectPriority.priorityNames[this.getPriority()];
		retval = retval + "</priority>\n";
				
		retval = retval + "<versionrep>" + this.getVersionReported();
		retval = retval + "</versionrep>\n"; 
	
		retval = retval + "<subsystem>" + this.getSubsystem();
		retval = retval + "</subsystem>\n";
			
		retval = retval + "<summary>" + this.getDefectSummary();
		retval = retval + "</summary>\n";

		retval = retval + "<details>" + this.getDefectDetails();
		retval = retval + "</details>\n";
	
		retval = retval + "<reporter>" + this.getReportedBy();
		retval = retval + "</reporter>\n";
						
		retval = retval + "<assignedto>" + this.getAssignedTo();
		retval = retval + "</assignedto>\n";
						
		retval = retval + "<resnotes>" + this.getResolutionNotes();
		retval = retval + "</resnotes>\n";
						
		retval = retval + "<changedmaillist>" + this.getChangedMailList();
		retval = retval + "</changedmaillist>\n";
						
		retval = retval + "<resolvedmaillist>" + this.getResolvedMailList();
		retval = retval + "</resolvedmaillist>\n";
						
		retval = retval + "<versionres>" + this.getVersionResolved();
		retval = retval + "</versionres>\n";
						
		retval = retval + "<datereported>" + apputil.util.LongToDateString(this.getDateReported());
		retval = retval + "</datereported>\n";
						
		retval = retval + "<datelastchanged>" + apputil.util.LongToDateString(this.getDateLastChanged());
		retval = retval + "</datelastchanged>\n";
						
		retval = retval + "<externalid>" +	this.getExternalId();
		retval = retval + "</externalid>\n";

		retval = retval + "</bugreport>\n";
		
		return retval;
	}
	
	
	/** method to support TestHarness
	*/
	public boolean TestUnit()
	{
		
		boolean retval = false;
		
		int l_defectID = 42;
		int l_state = DefectState.ASSIGNED;
		int l_priority = DefectPriority.HIGH;
		int l_severity = DefectSeverity.MISBEHAVIOR;
		String l_product = "BugTracker";
		String l_versionReported = "1.0";
		String l_subsystem = "dataabstraction";
		String l_defectSummary = "lastname, firstname transposed";
		String l_defectDetails = "after storing a username, the last and first names are transposed when the defect is re-fetched";
		String l_reportedBy = "rkp";
		String l_assignedTo = "rkp";
		long l_dateReported = new Date().getTime();
		long l_dateLastChanged = new Date().getTime();
		String l_resolutionNotes = "";
		String l_changedModules = "";
		String l_changedMailList = "support@happykitty.com ronp@happykitty.com";
		String l_resolvedMailList = "ronp@happykitty.com";
		String l_versionResolved = "";

		this.setDefectID(l_defectID);
		this.setState(l_state);
		this.setPriority(l_priority);
		this.setSeverity(l_severity);
		this.setProduct(l_product);
		this.setSubsystem(l_subsystem);
		this.setDefectSummary(l_defectSummary);
		this.setDefectDetails(l_defectDetails);
		this.setReportedBy(l_reportedBy);
		this.setAssignedTo(l_assignedTo);
		this.setDateReported(l_dateReported);
		this.setDateLastChanged(l_dateLastChanged);
		this.setResolutionNotes(l_resolutionNotes);
		this.setChangedModules(l_changedModules);
		this.setChangedMailList(l_changedMailList);
		this.setResolvedMailList(l_resolvedMailList);
		this.setVersionResolved(l_versionResolved);
		
		System.out.println(this);
		
		if (l_defectID == this.getDefectID())
			if(l_state == this.getState())
				if(l_priority == this.getPriority())
					if(l_severity == this.getSeverity())
						if(l_dateLastChanged == this.getDateLastChanged())
							if(l_dateReported == this.getDateReported())
								if(l_product.equals(this.getProduct()))
									if(l_subsystem.equals(this.getSubsystem()))
										if(l_defectSummary.equals(this.getDefectSummary()))
											if(l_defectDetails.equals(this.getDefectDetails()))
												if(l_reportedBy.equals(this.getReportedBy()))
													if(l_assignedTo.equals(this.getAssignedTo()))
														if(l_resolutionNotes.equals(this.getResolutionNotes()))
															if(l_changedModules.equals(this.getChangedModules()))
																if(l_changedMailList.equals(this.getChangedMailList()))
																	if(l_resolvedMailList.equals(this.getResolvedMailList()))
																		if(l_versionResolved.equals(this.getVersionResolved()))
																			retval = true;
		
		
		return retval;

	}
	
}