//Source file: c:/work/wrox/case_study/code/BugTrackerApp/dataabstraction/Persistent.java

package dataabstraction;

/**
Persistent is an interface that must be implemented by objects in the BugTracker
application that are persisted through the object-relational layer. This interace
provides standard methds that must be implemented by Persistent classes
*/

public interface Persistent 
{
	
	/**
	   retrieve this object from storage
	    */
	public void fetch() throws java.sql.SQLException;
	
	/**
	   remove this object from storage
	    */
	public void drop() throws java.sql.SQLException;
	
	/**
	   create this object in storage
	 */
	public void insert() throws java.sql.SQLException;
	
	/**
	   update the stored state of this object
	 */
	public void update() throws java.sql.SQLException;
	
	/**
	   determines if this object has been stored before. 
	   @return true if it already exists in storage, false if not
	*/
	public boolean rowExists();
	
	}