
/*

	file : DefectModelListener.java
	
*/


package ui;

import businessmodel.*;

/**
The DefectModelListener is an interface based on the Observer pattern. Implementing
classes provide the methods described here to provide a one-to-many model to view
interaction.

In the BugTracker application, the tab panels of the user interface implement
this interface and are the "observers", while the UIDefectModel object maintained by
the main form itself provides the observable model with the remoted defect 
that it currently holds.
*/
public interface DefectModelListener
{

	/**
	The listener is called via this method when the underlying model has
	been changed. The lister is then responsible for updating the information
	displayed in the UI based on the state of the model.
	*/
	void ModelUpdated(DefectIntf defect);
	
	/**
	The listener is called via this method when the underlying model requests
	that it be updated by the information in the UI. Any information that
	the listener has changed and wants the model to reflect will be 
	changed by the listener
	*/
	void UpdateModel(DefectIntf defect);
		
	/** 
	the listener is called via this method when the model needs to determine
	if the listener needs to update the model.
	*/
	boolean isDirty(DefectIntf defect);
	
}

	