
/*
	file:	DetailForm
	

*/

package ui;
import businessmodel.DefectIntf;

import javax.swing.*;

/**
Tab panel for the BugTracker application. This class implements the
DefectModelListener interface, and coordinates updates to the model 
via this interface. 

Note that model updates are "on demand" from the model - the panels do not 
actively update the model until an update is requested by the model.

*/
public class DetailForm extends JPanel implements DefectModelListener
{
	
	
	JLabel label_datereported;
	JLabel label_lastupdated;
	JLabel label_reportedby;
	JLabel label_assignedto;
	JLabel label_subsystem;
	JLabel label_detaileddescription;
	JTextField text_datereported;
	JTextField text_reportedby;
	JTextField text_subsystem;
	JTextField text_lastupdated;
	JTextField text_assignedto;
	JTextArea text_detaileddescription;

	public DetailForm()
	{

		super();
		
		int nPos;
		
		setLayout(null);
		setSize(612,439);

		label_datereported = new JLabel();
		label_datereported.setText("Date reported:");
		label_datereported.setBounds(12,12,84,22);
		add(label_datereported);
		
		label_lastupdated = new JLabel();
		label_lastupdated.setText("Last updated");
		label_lastupdated.setBounds(288,12,84,22);
		add(label_lastupdated);
		
		label_reportedby = new JLabel();
		label_reportedby.setText("Reported by:");
		label_reportedby.setBounds(12,48,84,22);
		add(label_reportedby);
		
		label_assignedto = new JLabel();
		label_assignedto.setText("Assigned to:");
		label_assignedto.setBounds(288,48,84,22);
		add(label_assignedto);
		
		label_subsystem = new JLabel();
		label_subsystem.setText("Subsystem:");
		label_subsystem.setBounds(12,84,84,22);
		add(label_subsystem);
		
		label_detaileddescription = new JLabel();
		label_detaileddescription.setText("Detailed descripton:");
		label_detaileddescription.setBounds(12,120,138,22);
		add(label_detaileddescription);
		
		text_datereported = new JTextField();
		text_datereported.setBounds(108,12,142,22);
		add(text_datereported);
		
		text_reportedby = new JTextField();
		text_reportedby.setBounds(108,48,142,22);
		add(text_reportedby);
		
		text_subsystem = new JTextField();
		text_subsystem.setBounds(108,84,142,22);
		add(text_subsystem);
		
		text_lastupdated = new JTextField();
		text_lastupdated.setBounds(384,12,142,22);
		add(text_lastupdated);
		
		text_assignedto = new JTextField();
		text_assignedto.setBounds(384,48,142,22);
		add(text_assignedto);
		
		text_detaileddescription = new JTextArea();
		text_detaileddescription.setBounds(12,144,516,189);
		add(text_detaileddescription);
		
	
	}
	
	
	/**
	The listener is called via this method when the underlying model has
	been changed. The lister is then responsible for updating the information
	displayed in the UI based on the state of the model.
	*/
	public void ModelUpdated(DefectIntf defect)
	{
		// update display of date reported
		text_datereported.setText(apputil.util.LongToDateString(defect.getDateReported()));
		
		// update display of date last changed
		text_lastupdated.setText(apputil.util.LongToDateString(defect.getDateLastChanged()));
		
		// update display of reported by
		text_reportedby.setText(defect.getReportedBy());
		
		// update display of assigned to
		text_assignedto.setText(defect.getAssignedTo());
		
		// update display of subsystem
		text_subsystem.setText(defect.getSubsystem());
		
		// update display of defect detail
		text_detaileddescription.setText(defect.getDefectDetails());
		
		
	}
	
	
	/**
	The listener is called via this method when the underlying model requests
	that it be updated by the information in the UI. Any information that
	the listener has changed and wants the model to reflect will be 
	changed by the listener
	*/
	public void UpdateModel(DefectIntf defect)
	{
		if (isDirty(defect))
		{
		
			// update model of reported by
			defect.setReportedBy(text_reportedby.getText());
					
			// update display of assigned to
			defect.setAssignedTo(text_assignedto.getText());
					
			// update display of subsystem
			defect.setSubsystem(text_subsystem.getText());
						
			// update display of defect detail
			defect.setDefectDetails(text_detaileddescription.getText());
						
		};
		
	}
	
	/** 
	the listener is called via this method when the model needs to determine
	if the listener needs to update the model.
	*/
		
	public boolean isDirty(DefectIntf defect)
	{
		
		boolean retval;
		retval = true;
		if (text_reportedby.getText().trim().equals(defect.getReportedBy().trim()))
			if (text_assignedto.getText().trim().equals(defect.getAssignedTo().trim()))
				if (text_subsystem.getText().trim().equals(defect.getSubsystem().trim()))
					if (text_detaileddescription.getText().trim().equals(defect.getDefectDetails().trim()))
						retval = false;
		
		return retval;
	}
		
}	
		