
/*
		file	:	ResolutionForm.java

*/



package ui;
import businessmodel.DefectIntf;

import javax.swing.*;

/**
Tab panel for the BugTracker application. This class implements the
DefectModelListener interface, and coordinates updates to the model 
via this interface. 

Note that model updates are "on demand" from the model - the panels do not 
actively update the model until an update is requested by the model.

*/

public class ResolutionForm extends JPanel implements DefectModelListener
{
	
	JLabel label_resolutionnotes;
	JLabel label_moduleschanged;
	JLabel label_versionresolved;
	JTextArea text_resolutionnotes;
	JTextArea text_moduleschanged;
	JTextField text_versionresolved;
	
	public ResolutionForm()
	{

		super();
		
		int nPos;

		setLayout(null);
		setVisible(false);
		setSize(612,439);

		label_resolutionnotes = new JLabel();
		label_resolutionnotes.setText("Resolution:");
		label_resolutionnotes.setBounds(12,12,72,19);
		add(label_resolutionnotes);
		
		label_moduleschanged = new JLabel();
		label_moduleschanged.setText("Modules changed:");
		label_moduleschanged.setBounds(12,96,122,19);
		add(label_moduleschanged);
		
		label_versionresolved = new JLabel();
		label_versionresolved.setText("Version resolved:");
		label_versionresolved.setBounds(12,192,123,19);
		add(label_versionresolved);
		
		text_resolutionnotes = new JTextArea();
		text_resolutionnotes.setBounds(12,36,408,57);
		add(text_resolutionnotes);
		
		text_moduleschanged = new JTextArea();
		text_moduleschanged.setBounds(12,120,408,57);
		add(text_moduleschanged);
		
		text_versionresolved = new JTextField();
		text_versionresolved.setBounds(12,216,408,21);
		add(text_versionresolved);
		
		
	}
	
		/**
	The listener is called via this method when the underlying model has
	been changed. The lister is then responsible for updating the information
	displayed in the UI based on the state of the model.
	*/
	public void ModelUpdated(DefectIntf defect)
	{
		// update display of resolution notes
		text_resolutionnotes.setText(defect.getResolutionNotes());
		
		// update display of changed modules
		text_moduleschanged.setText(defect.getChangedModules());
		
		// update display of version for resolution
		text_versionresolved.setText(defect.getVersionResolved());
		
		
	}
	
	
	/**
	The listener is called via this method when the underlying model requests
	that it be updated by the information in the UI. Any information that
	the listener has changed and wants the model to reflect will be 
	changed by the listener
	*/
	public void UpdateModel(DefectIntf defect)
	{
		if (isDirty(defect))
		{
		
		// update model resolution notes
		defect.setResolutionNotes(text_resolutionnotes.getText());
		
		// update model changed modules
		defect.setChangedModules(text_moduleschanged.getText());
		
		// update model version for resolution
		defect.setVersionResolved(text_versionresolved.getText());
						
		};
		
	}
	
	/** 
	the listener is called via this method when the model needs to determine
	if the listener needs to update the model.
	*/
		
	public boolean isDirty(DefectIntf defect)
	{
		
		boolean retval;
		retval = true;
		if (text_resolutionnotes.getText().trim().equals(defect.getResolutionNotes().trim()))
			if (text_moduleschanged.getText().trim().equals(defect.getChangedModules().trim()))
				if (text_versionresolved.getText().trim().equals(defect.getVersionResolved().trim()))
					retval = false;
		
		return retval;
	}
		

	
}