
/*
	file:	SummaryForm
	

*/

package ui;
import businessmodel.DefectIntf;

import javax.swing.*;

/**
Tab panel for the BugTracker application. This class implements the
DefectModelListener interface, and coordinates updates to the model 
via this interface. 

Note that model updates are "on demand" from the model - the panels do not 
actively update the model until an update is requested by the model.

*/

public class SummaryForm extends JPanel implements DefectModelListener
{

	JLabel label_defectid;
	JTextField text_defectid;
	JLabel label_product;
	JTextField text_product;
	JLabel label_summary;
	JTextField text_summary;
	JLabel label_status;
	JComboBox combo_status;
	JComboBox combo_severity;
	JComboBox combo_priority;
	JLabel label_version;
	JTextField text_version;
	JLabel label_severity;
	JLabel label_priority;
	JLabel label_externalid;
	JTextField text_externalid;

	public SummaryForm()
	{
		
		super();
		
		int nPos;
		
		setLayout(null);
		setSize(612,439);
		
		label_defectid = new JLabel();
		label_defectid.setText("DefectID");
		label_defectid.setBounds(12,24,60,23);
		add(label_defectid);
		
		text_defectid = new JTextField();
		text_defectid.setBounds(84,24,96,26);
		add(text_defectid);

		label_product = new JLabel();
		label_product.setText("Product");
		label_product.setBounds(12,72,60,19);
		add(label_product);
		
		text_product = new JTextField();
		text_product.setBounds(84,72,207,26);
		add(text_product);
		
		label_summary = new JLabel();
		label_summary.setText("Defect Summary");
		label_summary.setBounds(12,144,108,21);
		
		add(label_summary);
		text_summary = new JTextField();
		text_summary.setBounds(12,168,481,24);
		add(text_summary);
		
		label_status = new JLabel();
		label_status.setText("Status");
		label_status.setBounds(12,204,48,24);
		add(label_status);
	
		combo_status = new JComboBox(businessmodel.DefectState.stateNames);
		combo_status.setBounds(12,228,140,22);
		add(combo_status);
		
		combo_severity = new JComboBox(businessmodel.DefectSeverity.severityNames);
		combo_severity.setBounds(168,228,140,22);
		add(combo_severity);
		
		combo_priority = new JComboBox(businessmodel.DefectPriority.priorityNames);
		combo_priority.setBounds(336,228,140,22);
		add(combo_priority);
		
		label_version = new JLabel();
		label_version.setText("Version");
		label_version.setBounds(324,72,60,26);
		add(label_version);
		
		text_version = new JTextField();
		text_version.setBounds(396,72,136,24);
		add(text_version);
		
		label_severity = new JLabel();
		label_severity.setText("Severity");
		label_severity.setBounds(168,204,48,24);
		add(label_severity);
		
		label_priority = new JLabel();
		label_priority.setText("Priority");
		label_priority.setBounds(336,204,48,24);
		add(label_priority);
		
		label_externalid = new JLabel();
		label_externalid.setText("External reference");
		label_externalid.setBounds(12, 264, 128, 24);
		add (label_externalid);
		
		text_externalid = new JTextField();
		text_externalid.setBounds(12, 288, 140, 26);
		add (text_externalid);
		
		
		
	}
	
	
	/**
	The listener is called via this method when the underlying model has
	been changed. The lister is then responsible for updating the information
	displayed in the UI based on the state of the model.
	*/
	public void ModelUpdated(DefectIntf defect)
	{
		// update display of id
		text_defectid.setText(Integer.toString(defect.getDefectID()));
		
		// update display of product
		text_product.setText(defect.getProduct());
		
		// update display of version
		text_version.setText(defect.getVersionReported());
		
		// update display of summary
		text_summary.setText(defect.getDefectSummary());
		
		// update display of status
		int state = defect.getState();
		combo_status.setSelectedItem(businessmodel.DefectState.stateNames[state]);
		
		// update display of severity
		int severity = defect.getSeverity();
		combo_severity.setSelectedItem(businessmodel.DefectSeverity.severityNames[severity]);
		
		// update display of priority
		int priority = defect.getPriority();
		combo_priority.setSelectedItem(businessmodel.DefectPriority.priorityNames[priority]);
		
		// update display of external reference
		text_externalid.setText(defect.getExternalId());
		
	}
	
	
	/**
	The listener is called via this method when the underlying model requests
	that it be updated by the information in the UI. Any information that
	the listener has changed and wants the model to reflect will be 
	changed by the listener
	*/
	public void UpdateModel(DefectIntf defect)
	{
		if (isDirty(defect))
		{
		
			// update model product
			defect.setProduct(text_product.getText());
			
			// update model version
			defect.setVersionReported(text_version.getText());
			
			// update model summmary
			defect.setDefectSummary(text_summary.getText());
			
			// update model status
			defect.setState(getState());
						
			// update model severity
			defect.setSeverity(getSeverity());
						
			// update model priority
			defect.setPriority(getPriority());
			
			// update external reference
			defect.setExternalId(text_externalid.getText());
		};
		
	}
	
	/** 
	the listener is called via this method when the model needs to determine
	if the listener needs to update the model.
	*/
		
	public boolean isDirty(DefectIntf defect)
	{
		
		boolean retval;
		retval = true;
		if (text_product.getText().trim().equals(defect.getProduct().trim()))
			if (text_version.getText().trim().equals(defect.getVersionReported().trim()))
				if (text_summary.getText().trim().equals(defect.getDefectSummary().trim()))
					if (getState() == defect.getState())
						if (getSeverity() == defect.getSeverity())
							if (getPriority() == defect.getPriority())
								if (text_externalid.getText().trim().equals(defect.getExternalId().trim()))
									retval = false;
		
			
		return retval;
	}
	
	int getState()
	{
		int retval = 0;
		int nPos = 0;
		String stateName = (String)combo_status.getSelectedItem();
		
		try
		{
			retval = apputil.util.getPosInArray(businessmodel.DefectState.stateNames, stateName);
		}
		catch(ArrayIndexOutOfBoundsException aioobe)
		{
			;
		}
				
		return retval;	 
		
	}
	
	int getPriority()
	{
		int retval = 0;
		int nPos = 0;
		
		String priorityName = (String)combo_priority.getSelectedItem();
		
		try
		{
			retval = apputil.util.getPosInArray(businessmodel.DefectPriority.priorityNames, priorityName);
		}
		catch(ArrayIndexOutOfBoundsException aioobe)
		{
			;
		}
				
		return retval;
		
	}
	
	int getSeverity()
	{
		int retval = 0;
		int nPos = 0;
		String severityName = (String)combo_severity.getSelectedItem();
		
		try
		{
			retval = apputil.util.getPosInArray(businessmodel.DefectSeverity.severityNames, severityName);
		}
		catch(ArrayIndexOutOfBoundsException aioobe)
		{
			;
		}
				
		return retval;		

		
	}
	
		
 }