
import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/*~

    file    :   InteractiveSQL.java
    revision history
    ---------------------------------------
    date        initials        description
    ---------------------------------------

~*/

/**
 * simple interactive sql tool for jdbc


 *
 */


 public class InteractiveSQL extends Frame implements ActionListener
 {


    public static void main(String args[])
    {

        InteractiveSQL theApp = new InteractiveSQL();

    }


    public InteractiveSQL()
    {
        super("InteractiveSQL/Java");
        LoginDialog = null;

        // build and add menu bar
        MenuBar theMenu = new MenuBar();

        Menu File;
        File = new Menu("File");

        File_Execute        = new MenuItem("Execute query");
        File_SaveResults    = new MenuItem("Save results to file...");
        File_ClearResults   = new MenuItem("Clear results");
        File_OpenConnection = new MenuItem("Open connection...");
        File_ShowExceptions = new MenuItem("Show exception detail...");
        File_Exit           = new MenuItem("Exit");


        File.add(File_Execute);
        File.add(File_SaveResults);
        File.add(File_ClearResults);
        File.add(File_OpenConnection);
        File.add(File_ShowExceptions);
        File.addSeparator();
        File.add(File_Exit);

        File_Execute.addActionListener(this);
        File_SaveResults.addActionListener(this);
        File_Exit.addActionListener(this);
        File_OpenConnection.addActionListener(this);
        File_ClearResults.addActionListener(this);
        File_ShowExceptions.addActionListener(this);

        theMenu.add(File);
        this.setMenuBar(theMenu);

        // create, add awt components
        this.setLayout(new BorderLayout());
        sqlLine = new TextField();
        statusLine = new TextField();
        Results = new TextArea();
        statementList = new List();


        this.add("North", new Button());

        this.add("Center", statementList);
        this.add("North", sqlLine);
        this.add("South", statusLine);
        this.add("Center", Results);
        statusLine.setBackground(Color.lightGray);
        this.setBackground(Color.lightGray);
        Results.setBackground(Color.lightGray);

        this.setBounds(10, 10, 600, 300);
        File_Execute.setEnabled(false);

        this.setVisible(true);
        sqlLine.requestFocus();

        doDatabaseLogin();

    }

    public void actionPerformed(ActionEvent e)
    {

        Object source = e.getSource();

        if (source == File_Execute)
            selectedExecute();

        else
        if (source == File_SaveResults)
            selectedSave();

        else
        if (source == File_ClearResults)
            Results.setText("");

        else
        if (source == File_OpenConnection)
            doDatabaseLogin();

        else

        if (source == File_ShowExceptions)
        {
            ShowExceptionDialog dlg;
            dlg = new ShowExceptionDialog(this, lastException);
        }

        else
        if (source == File_Exit)
        {
            this.dispose();
            System.exit(0);

         };

    }


    public synchronized void selectedExecute()
    {
        String theQuery = sqlLine.getText();
        int numRows;
        int thisCol;

        numRows = 0;

        try
        {

            Statement queryStatement = databaseConnection.createStatement();
            ResultSet theResults = queryStatement.executeQuery(theQuery);
            ResultSetMetaData rsmeta = theResults.getMetaData();

            int numColumns = rsmeta.getColumnCount();

            while(theResults.next())
            {
                String thisRow = new String("");
                numRows++;
                for (thisCol = 1; thisCol <= numColumns; thisCol++)
                {
                    String thisval = theResults.getString(thisCol);
                    if (thisval != null)
                        thisRow = thisRow.concat(thisval.trim());
                    else
                        thisRow = thisRow.concat("(null)");

                    thisRow = thisRow.concat("\t");
                }
                Results.setText(Results.getText().concat("\n" + thisRow));
            }

            showStatusText("Rows returned: " + numRows);
        }

        catch(SQLException sqle)
        {
            lastException = sqle;
            showErrorText(sqle.toString());

        }

    }


    public void showStatusText(String text)
    {
        statusLine.setForeground(Color.black);
        statusLine.setFont(new Font("Arial", Font.PLAIN, 10));
        statusLine.setText(text.trim());
    }

    public void showErrorText(String text)
    {
        statusLine.setForeground(Color.red);
        statusLine.setFont(new Font("Courier", Font.BOLD, 12));
        statusLine.setText(text.trim());

    }


    public void selectedSave()
    {

        // get a file name, open the file, and write out
        // the contents of the list box

        try
        {

            FileDialog fdlg = new FileDialog(this, "Save results", FileDialog.SAVE);
            fdlg.setVisible(true);

            String filename = fdlg.getFile();

            FileOutputStream fs = new FileOutputStream(filename);
            PrintStream ps = new PrintStream(fs);

            ps.println(Results.getText());

            fs.close();
        }
        catch (IOException ioe)
        {
            showErrorText(ioe.toString());
        }

    }

    public boolean doDatabaseLogin()
    {

        String userId, password, URL, className;

        if (LoginDialog == null)
            LoginDialog = new login(this);
        else
            LoginDialog.setVisible(true);

        // wait around while dialog is displayed
        while(LoginDialog.isVisible())
        {
            try
            {
                Thread.sleep(1000);
            }
            catch(InterruptedException ie)
            {
                ;
            }
        }

        if (LoginDialog.saved)
        {
            userId      = LoginDialog.UserName;
            password    = LoginDialog.Password;
            URL         = LoginDialog.URL;
            className   = LoginDialog.DriverName;

            try
            {
                // explicitly load driver class so it registers
                // with driver manager.

                Class.forName(className);

                databaseConnection = DriverManager.getConnection(URL, userId, password);
                showStatusText("Connected to " + URL);
                File_Execute.setEnabled(true);
                return true;

            }

            catch(SQLException sqle)
            {
                lastException = sqle;
                showErrorText(sqle.toString());
                File_Execute.setEnabled(false);
                return false;
            }

            catch(ClassNotFoundException cnfe)
            {
                showErrorText(cnfe.toString());
                File_Execute.setEnabled(false);
                return false;
            }


        }

        else    // canceled. Won't change status of execute menu item
        {
            return false;

        }

    }

    Connection databaseConnection;

    login LoginDialog;

    // awt objects
    TextField sqlLine;
    TextField statusLine;
    List      statementList;
    TextArea Results;

    MenuItem File_Execute;
    MenuItem File_SaveResults;
    MenuItem File_ClearResults;
    MenuItem File_OpenConnection;
    MenuItem File_ShowExceptions;
    MenuItem File_Exit;
    SQLException lastException;


}

class login extends Dialog implements ActionListener
{

    public login(Frame myFrame)
    {
        super(myFrame, true);

        this.setBackground(Color.lightGray);

        setLayout(null);
        addNotify();
        setSize(getInsets().left + getInsets().right + 307, getInsets().top + getInsets().bottom + 209);
        nameLabel=new Label("User id:");
        add(nameLabel);
        nameLabel.setBounds(getInsets().left + 12,getInsets().top + 13,77,25);
        passLabel=new Label("Password:");
        add(passLabel);
        passLabel.setBounds(getInsets().left + 12,getInsets().top + 48,77,25);
        urlLabel=new Label("URL:");
        add(urlLabel);
        urlLabel.setBounds(getInsets().left + 12,getInsets().top + 83,77,25);
        drvLabel=new Label("Driver name:");
        add(drvLabel);
        drvLabel.setBounds(getInsets().left + 12,getInsets().top + 118,77,25);
        nameText=new TextField(22);
        add(nameText);
        nameText.setBounds(getInsets().left + 105,getInsets().top + 6,182,26);
        passText=new TextField(22);
        add(passText);
        passText.setBounds(getInsets().left + 105,getInsets().top + 45,182,26);
        URLText=new TextField(22);
        add(URLText);
        URLText.setBounds(getInsets().left + 105,getInsets().top + 77,182,26);
        drvText=new TextField(22);
        add(drvText);
        drvText.setBounds(getInsets().left + 105,getInsets().top + 109,182,26);
        buttonOK=new Button("OK");
        add(buttonOK);
        buttonOK.setBounds(getInsets().left + 75,getInsets().top + 146,64,24);
        buttonCancel=new Button("Cancel");
        add(buttonCancel);
        buttonCancel.setBounds(getInsets().left + 154,getInsets().top + 146,64,24);


        nameText.setText(UserName);
        passText.setText(Password);
        URLText.setText(URL);
        drvText.setText(DriverName);

        saved = false;

        buttonOK.addActionListener(this);
        buttonCancel.addActionListener(this);

        this.setTitle("Database login");

        this.show();


    }

    public void actionPerformed(ActionEvent e)
    {

        Object source = e.getSource();

        if (source == buttonOK)
        {


            UserName = nameText.getText();
            Password = passText.getText();
            URL = URLText.getText();
            DriverName = drvText.getText();
            if ((UserName.length() > 0) &&
                (Password.length() > 0) &&
                (URL.length() > 0) &&
                (DriverName.length() > 0))
            {
                saved = true;
                this.setVisible(false);
            }
            else
            {
                // put the focus on the empty prompt
                if (UserName.length() == 0)
                    nameText.requestFocus();
                else
                if (Password.length() == 0)
                    passText.requestFocus();
                else
                if (URL.length() == 0)
                    URLText.requestFocus();
                else
                if (DriverName.length() == 0)
                    drvText.requestFocus();
            }

        }

        else
        if (source == buttonCancel)
            this.setVisible(false);


    }


    Label nameLabel;
    Label passLabel;
    Label urlLabel;
    Label drvLabel;
    Button buttonOK;
    Button buttonCancel;
    TextField passText;
    TextField URLText;
    TextField drvText;
    TextField nameText;

    public String UserName;
    public String Password;
    public String URL;
    public String DriverName;
    public boolean saved;

}


class ShowExceptionDialog extends Dialog implements ActionListener
{

    public ShowExceptionDialog(Frame myFrame, SQLException theException)
    {
        super(myFrame, true);

        this.setBackground(Color.lightGray);

        this.setLayout(new BorderLayout());
        this.setBounds(10, 10, 600, 300);

        ExceptionDetail = new TextArea();
        this.add("Center", ExceptionDetail);

        buttonClose = new Button("Close");
        this.add("South", buttonClose);

        buttonClose.addActionListener(this);

        this.setTitle("Exception Details");

        String detailText;
        // extract the information about the exception
        if (theException != null)
        {
            String sqlMessage = theException.getMessage();
            String sqlState   = theException.getSQLState();
            int vendorCode = theException.getErrorCode();

            detailText = "Exception occurred:\nMessage: \t" + sqlMessage +
                    "\nSQL state: \t" + sqlState +
                    "\nVendor code: \t" + vendorCode;

        }
        else
            detailText = "No exceptions encountered";

        this.ExceptionDetail.setText(detailText);


        this.setVisible(true);

    }

    public void actionPerformed(ActionEvent e)
    {

        Object source = e.getSource();

        if (source == buttonClose)
            this.setVisible(false);


    }

    TextArea ExceptionDetail;
    Button buttonClose;

}
