      /*       fichier POINT4.H  :  dclaration de la classe point */
class point
{  float r, t ;                   // coordonnes (polaires) du point
 public :
   point (float, float) ;         // constructeur
   void deplace (float, float) ;  // dplacement
   void homothetie (float) ;      // homothtie
   void rotation (float) ;        // rotation
   float abscisse () ;            // abscisse du point
   float ordonnee () ;            // ordonne du point
   float rho () ;                 // rayon vecteur
   float theta () ;               // angle
} ;



#include "point4.h"
#include <cmath>                     // pour cos, sin, sqrt et atan
#include <iostream> 
using namespace std ;
const int pi = 3.141592635 ;          // valeur de pi 
	/********** dfinition des fonctions de service ***********/
/* fonction de calcul de l'angle correspondant aux coordonnes     */
/*           cartsiennes fournies en argument                     */
/* On choisit une dtermination entre -pi et +pi (0 si x=0)        */
float angle (float x, float y)
{  float a = x ? atan (y/x) : 0 ;
   if (y<0) if (x>=0) return a + pi ;
		 else return a - pi ;
   return a ;
}
	/********** dfinition des fonctions membre *****************/
point::point (float abs, float ord)
{  r = sqrt (abs*abs + ord*ord) ;
   t = atan (ord/abs) ;
}
void point::deplace (float dx, float dy)
{  float x = r * cos (t) + dx ;   // nouvelle abscisse 
   float y = r * sin (t) + dy ;   // nouvelle ordonne 
   r = sqrt (x*x + y*y) ;
   t = angle (x, y) ;  
}
void point::homothetie (float hm)
{  r *= hm ;
}
void point::rotation (float th)
{  t += th ;
}
float point::abscisse ()
{ return r * cos (t) ;
}
float point::ordonnee ()
{ return r * sin (t) ;
}
float point::rho ()
{ return r ;
}
float point::theta ()
{ return t ;
}



