package org.genealogie.metier.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

import org.genealogie.log.Log;
import org.genealogie.metier.modele.Auth;
import org.genealogie.metier.modele.Commune;
import org.genealogie.metier.modele.RegistreActe;

public class TablesRegistresDAO {
	public static int DATE_ASC=0;
	public static int DATE_DESC=1;
	public static int NOM_ASC=2;
	public static int NOM_DESC=3;

	public static int NAISSANCE=1;
	public static int BAPTEME=2;
	public static int MARIAGE_CIVIL=3;
	public static int MARIAGE_RELIGIEUX=4;
	public static int DECES=5;

	private Connection connection;


	public TablesRegistresDAO(Connection connection) {
		this.connection=connection;
	}

	private Connection getConnection() throws SQLException {
		/*		try {
		 return DatabaseUtils.getConnection();
		 } catch(Exception ex) {
		 Log.log(ex);
		 ex.printStackTrace();
		 }
		 return null;*/
		return connection;
	}

	public int getActeRegistre(String nom,int idCommune,java.sql.Date date,int idPersonne,int idTypeActe) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		if( idCommune==0 || date==null )
			return 0;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select tables_id from tables");
			requete.append(" where tables_commune_id=? and tables_date_acte=?");
			requete.append(" and tables_personne_id=?");// and tables_type_acte=?");
			ps=conn.prepareStatement(requete.toString());
//			ps.setString(1,nom);
			ps.setInt(1,idCommune);
			ps.setDate(2,date);
			ps.setInt(3,idPersonne);
//			ps.setInt(3,idTypeActe);
			rs=ps.executeQuery();
			if( rs.next() )
				return rs.getInt("tables_id");
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			return 0;
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return 0;
	}


	public Vector getRegistres(int communeId,java.sql.Date borneSup,int order) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector registres=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select tables_id,tables_date_acte,tables_nom,tables_prenom,type_acte_id,");
			requete.append("type_acte_nom,tables_commune_id,commune_nom,departement_numero,tables_personne_id,");
			requete.append("tables_id_pere,tables_nom_pere,tables_prenom_pere,tables_id_mere,tables_nom_mere,tables_prenom_mere,");
			requete.append("tables_id_dependance,tables_doublon,tables_personne_homme,tables_personne_age,");
			requete.append("tables_doublon,tables_personne_homme,tables_personne_age,tables_personne_pere_age,");
			requete.append("tables_personne_mere_age,tables_personne_origine");
			requete.append(" from tables,type_acte,commune,departement");
			requete.append(" where tables.tables_type_acte_id=type_acte.type_acte_id");
			requete.append(" and tables.tables_commune_id=commune.commune_id");
			requete.append(" and departement.departement_id=commune.commune_departement_id");
			requete.append(" and tables_commune_id=?");
			if( borneSup!=null )
				requete.append(" and tables_date_acte<=?");
			if( order==DATE_ASC )
				requete.append(" order by tables_date_acte asc,tables_nom asc");
			else if( order==DATE_DESC )
				requete.append(" order by tables_date_acte desc,tables_nom desc");
			else if( order==NOM_ASC )
				requete.append(" order by tables_nom asc,tables_date_acte asc");
			else if( order==NOM_DESC )
				requete.append(" order by tables_nom desc,tables_date_acte asc");
			else
				requete.append(" order by tables_nom asc,tables_date_acte asc");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,communeId);
			if( borneSup!=null )
				ps.setDate(2,borneSup);
			rs=ps.executeQuery();
			while( rs.next() ) {
				RegistreActe rau=new RegistreActe(rs.getInt("tables_id"),
					rs.getString("tables_nom"),rs.getString("tables_prenom"),rs.getInt("type_acte_id"),rs.getString("type_acte_nom"),
					rs.getDate("tables_date_acte"),rs.getInt("tables_commune_id"),
					rs.getString("commune_nom")+" ( "+rs.getString("departement_numero")+" )",
					rs.getInt("tables_personne_id"),rs.getInt("tables_id_pere"),rs.getString("tables_nom_pere"),
					rs.getString("tables_prenom_pere"),rs.getInt("tables_personne_pere_age"),
					rs.getInt("tables_id_mere"),rs.getString("tables_nom_mere"),rs.getString("tables_prenom_mere"),
					rs.getInt("tables_personne_mere_age"),rs.getInt("tables_id_dependance"),
					rs.getInt("tables_doublon"),rs.getInt("tables_personne_homme"),rs.getInt("tables_personne_age"),
					rs.getString("tables_personne_origine"));
				registres.addElement(rau);
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}

		return registres;
	}

	public Vector getRegistresOrdonnes(int communeId,java.sql.Date borneSup) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector registres=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select tables_id,tables_date_acte,tables_nom,tables_prenom,type_acte_id,");
			requete.append("type_acte_nom,tables_commune_id,commune_nom,departement_numero,tables_personne_id,");
			requete.append("tables_id_pere,tables_nom_pere,tables_prenom_pere,tables_id_mere,tables_nom_mere,tables_prenom_mere,");
			requete.append("tables_id_dependance,tables_doublon,tables_personne_homme,tables_personne_age,");
			requete.append("tables_doublon,tables_personne_homme,tables_personne_age,tables_personne_pere_age,");
			requete.append("tables_personne_mere_age,tables_personne_origine");
			requete.append(" from tables,type_acte,commune,departement");
			requete.append(" where tables.tables_type_acte_id=type_acte.type_acte_id");
			requete.append(" and tables.tables_commune_id=commune.commune_id");
			requete.append(" and departement.departement_id=commune.commune_departement_id");
			requete.append(" and tables_commune_id=?");
			if( borneSup!=null )
				requete.append(" and tables_date_acte<=?");
			requete.append(" order by tables_id asc");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,communeId);
			if( borneSup!=null )
				ps.setDate(2,borneSup);
			rs=ps.executeQuery();
			while( rs.next() ) {
				RegistreActe rau=new RegistreActe(rs.getInt("tables_id"),
					rs.getString("tables_nom"),rs.getString("tables_prenom"),rs.getInt("type_acte_id"),rs.getString("type_acte_nom"),
					rs.getDate("tables_date_acte"),rs.getInt("tables_commune_id"),
					rs.getString("commune_nom")+" ( "+rs.getString("departement_numero")+" )",
					rs.getInt("tables_personne_id"),rs.getInt("tables_id_pere"),rs.getString("tables_nom_pere"),
					rs.getString("tables_prenom_pere"),rs.getInt("tables_personne_pere_age"),
					rs.getInt("tables_id_mere"),rs.getString("tables_nom_mere"),rs.getString("tables_prenom_mere"),
					rs.getInt("tables_personne_mere_age"),rs.getInt("tables_id_dependance"),
					rs.getInt("tables_doublon"),rs.getInt("tables_personne_homme"),rs.getInt("tables_personne_age"),
					rs.getString("tables_personne_origine"));
				registres.addElement(rau);
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}

		return registres;
	}

	public Vector getCommunesRegistres(java.sql.Date borneSup) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector communes=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select distinct commune.commune_id,commune.commune_nom,departement.departement_nom,departement.departement_numero,pays.pays_nom");
			requete.append(" from commune,departement,pays,tables");
			requete.append(" where commune.commune_departement_id=departement.departement_id");
			requete.append(" and departement.departement_pays_id=pays.pays_id");
			requete.append(" and tables.tables_commune_id=commune.commune_id");
			if( borneSup!=null )
				requete.append(" and tables.tables_date_acte<=?");
			requete.append(" order by commune.commune_nom asc");
			ps=conn.prepareStatement(requete.toString());
			if( borneSup!=null )
				ps.setDate(1,borneSup);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Commune commune=new Commune(rs.getInt("commune_id"),rs.getString("commune_nom"),
								rs.getString("departement_numero"),rs.getString("pays_nom"));
				communes.addElement(commune);
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}

		return communes;
	}

	public RegistreActe getTableElement(int id) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select tables_id,tables_date_acte,tables_nom,tables_prenom,type_acte_id,");
			requete.append("type_acte_nom,tables_commune_id,commune_nom,departement_numero,tables_personne_id,");
			requete.append("tables_id_pere,tables_nom_pere,tables_prenom_pere,tables_id_mere,tables_nom_mere,tables_prenom_mere,");
			requete.append("tables_id_dependance,tables_doublon,tables_personne_homme,tables_personne_age,");
			requete.append("tables_doublon,tables_personne_homme,tables_personne_age,tables_personne_pere_age,");
			requete.append("tables_personne_mere_age,tables_personne_origine");
			requete.append(" from tables,type_acte,commune,departement");
			requete.append(" where tables.tables_type_acte_id=type_acte.type_acte_id");
			requete.append(" and tables.tables_commune_id=commune.commune_id");
			requete.append(" and departement.departement_id=commune.commune_departement_id");
			requete.append(" and tables.tables_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,id);
			rs=ps.executeQuery();
			if( rs.next() ) {
				RegistreActe rau=new RegistreActe(rs.getInt("tables_id"),
					rs.getString("tables_nom"),rs.getString("tables_prenom"),rs.getInt("type_acte_id"),rs.getString("type_acte_nom"),
					rs.getDate("tables_date_acte"),rs.getInt("tables_commune_id"),
					rs.getString("commune_nom")+" ( "+rs.getString("departement_numero")+" )",
					rs.getInt("tables_personne_id"),rs.getInt("tables_id_pere"),rs.getString("tables_nom_pere"),
					rs.getString("tables_prenom_pere"),rs.getInt("tables_personne_pere_age"),
					rs.getInt("tables_id_mere"),rs.getString("tables_nom_mere"),rs.getString("tables_prenom_mere"),
					rs.getInt("tables_personne_mere_age"),rs.getInt("tables_id_dependance"),
					rs.getInt("tables_doublon"),rs.getInt("tables_personne_homme"),rs.getInt("tables_personne_age"),
					rs.getString("tables_personne_origine"));
				return rau;
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return null;
	}


	public Vector getResultatsRechercheTables(String rechercher,java.sql.Date date1,java.sql.Date date2,String lieu,int ordre) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector registres=new Vector();

		try {
			conn=getConnection();

			if( rechercher!=null ) {
				rechercher=rechercher.trim();
				rechercher=rechercher.toLowerCase();
			}
			if( lieu!=null ) {
				lieu=lieu.trim();
				lieu=lieu.toUpperCase();
			}
			StringBuffer requete=new StringBuffer();
			requete.append("select tables_id,tables_date_acte,tables_nom,tables_prenom,type_acte_id,");
			requete.append("type_acte_nom,tables_commune_id,commune_nom,departement_numero,tables_personne_id,");
			requete.append("tables_id_pere,tables_nom_pere,tables_prenom_pere,tables_id_mere,tables_nom_mere,tables_prenom_mere,");
			requete.append("tables_id_dependance,tables_doublon,tables_personne_homme,tables_personne_age,");
			requete.append("tables_doublon,tables_personne_homme,tables_personne_age,tables_personne_pere_age,");
			requete.append("tables_personne_mere_age,tables_personne_origine");
			requete.append(" from tables,type_acte,commune,departement");
			requete.append(" where tables.tables_type_acte_id=type_acte.type_acte_id");
			requete.append(" and tables.tables_commune_id=commune.commune_id");
			requete.append(" and departement.departement_id=commune.commune_departement_id");

			if( rechercher!=null && !rechercher.equals("") )
				requete.append(" and LOWER( tables.tables_nom ) like '%"+rechercher+"%'");
			if( lieu!=null && !lieu.equals("") )
				requete.append(" and UPPER(commune.commune_nom) like '"+lieu+"%'");

			if( date1!=null )
				requete.append(" and tables.tables_date_acte>=?");
			if( date2!=null )
				requete.append(" and tables.tables_date_acte<=?");

			if( ordre==DATE_ASC )
				requete.append(" order by tables_date_acte asc,tables_nom asc");
			else if( ordre==DATE_DESC )
				requete.append(" order by tables_date_acte desc,tables_nom desc");
			else if( ordre==NOM_ASC )
				requete.append(" order by tables_nom asc,tables_date_acte asc");
			else if( ordre==NOM_DESC )
				requete.append(" order by tables_nom desc,tables_date_acte asc");
			else
				requete.append(" order by tables_nom asc,tables_date_acte asc");
			ps=conn.prepareStatement(requete.toString());
			int indice=1;
			if( date1!=null ) {
				ps.setDate(indice,date1);
				indice++;
			}
			if( date2!=null )
				ps.setDate(indice,date2);
			//ps.setString(1,rechercher);
			rs=ps.executeQuery();
			while( rs.next() ) {
				RegistreActe rau=new RegistreActe(rs.getInt("tables_id"),
					rs.getString("tables_nom"),rs.getString("tables_prenom"),rs.getInt("type_acte_id"),rs.getString("type_acte_nom"),
					rs.getDate("tables_date_acte"),rs.getInt("tables_commune_id"),
					rs.getString("commune_nom")+" ( "+rs.getString("departement_numero")+" )",
					rs.getInt("tables_personne_id"),rs.getInt("tables_id_pere"),rs.getString("tables_nom_pere"),
					rs.getString("tables_prenom_pere"),rs.getInt("tables_personne_pere_age"),
					rs.getInt("tables_id_mere"),rs.getString("tables_nom_mere"),rs.getString("tables_prenom_mere"),
					rs.getInt("tables_personne_mere_age"),rs.getInt("tables_id_dependance"),
					rs.getInt("tables_doublon"),rs.getInt("tables_personne_homme"),rs.getInt("tables_personne_age"),
					rs.getString("tables_personne_origine"));
				registres.addElement(rau);
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}

		return registres;
	}
	

	public Vector getResultatsRechercheTables(String rechercher,java.sql.Date date1,java.sql.Date date2,String lieu,
				int ordre,Auth auth) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector registres=new Vector();

		try {
			conn=getConnection();

			if( rechercher!=null ) {
				rechercher=rechercher.trim();
				rechercher=rechercher.toLowerCase();
			}
			if( lieu!=null ) {
				lieu=lieu.trim();
				lieu=lieu.toUpperCase();
			}
			StringBuffer requete=new StringBuffer();
			requete.append("select tables_id,tables_date_acte,tables_nom,tables_prenom,type_acte_id,");
			requete.append("type_acte_nom,tables_commune_id,commune_nom,departement_numero,tables_personne_id,");
			requete.append("tables_id_pere,tables_nom_pere,tables_prenom_pere,tables_id_mere,tables_nom_mere,tables_prenom_mere,");
			requete.append("tables_id_dependance,tables_doublon,tables_personne_homme,tables_personne_age,");
			requete.append("tables_doublon,tables_personne_homme,tables_personne_age,tables_personne_pere_age,");
			requete.append("tables_personne_mere_age,tables_personne_origine");
			requete.append(" from tables,type_acte,commune,departement");
			requete.append(" where tables.tables_type_acte_id=type_acte.type_acte_id");
			requete.append(" and tables.tables_commune_id=commune.commune_id");
			requete.append(" and departement.departement_id=commune.commune_departement_id");

			if( rechercher!=null && !rechercher.equals("") )
				requete.append(" and LOWER( tables.tables_nom ) like '%"+rechercher+"%'");
			if( lieu!=null && !lieu.equals("") )
				requete.append(" and UPPER(commune.commune_nom) like '"+lieu+"%'");

			if( date1!=null )
				requete.append(" and tables.tables_date_acte>=?");
			if( date2!=null )
				requete.append(" and tables.tables_date_acte<=?");

			Vector pays=auth.getPays();
			Vector departements=auth.getDepartements();
			Vector communes=auth.getCommunes();
			Vector communesFamilles=auth.getCommunesFamilles();

			if( pays.size()>0 || departements.size()>0 || communes.size()>0 ||  communesFamilles.size()>0 )
				requete.append(" and ( ");

			String separateur="";
			if( pays.size()>0 ) {
				requete.append(" "+separateur+" departement.departement_pays_id in (");
				for(int cpt=0;cpt<pays.size();cpt++) {
					if( cpt!=0 )
						requete.append(",?");
					else
						requete.append("?");
				}
				requete.append(")");
				separateur="or";
			}

			if( departements.size()>0 ) {
				requete.append(" "+separateur+" commune.commune_departement_id in (");
				for(int cpt=0;cpt<departements.size();cpt++) {
					if( cpt!=0 )
						requete.append(",?");
					else
						requete.append("?");
				}
				requete.append(")");
				separateur="or";
			}

			if( communes.size()>0 ) {
				requete.append(" "+separateur+" commune.commune_id in (");
				for(int cpt=0;cpt<communes.size();cpt++) {
					if( cpt!=0 )
						requete.append(",?");
					else
						requete.append("?");
				}
				requete.append(")");
				separateur="or";
			}

			if( communesFamilles.size()>0 ) {
				requete.append(" "+separateur+" commune.commune_id in (");
				for(int cpt=0;cpt<communesFamilles.size();cpt++) {
					if( cpt!=0 )
						requete.append(",?");
					else
						requete.append("?");
				}
				requete.append(")");
			}

			if( pays.size()>0 || departements.size()>0 || communes.size()>0 ||  communesFamilles.size()>0 )
				requete.append(" ) ");

			if( ordre==DATE_ASC )
				requete.append(" order by tables_date_acte asc,tables_nom asc");
			else if( ordre==DATE_DESC )
				requete.append(" order by tables_date_acte desc,tables_nom desc");
			else if( ordre==NOM_ASC )
				requete.append(" order by tables_nom asc,tables_date_acte asc");
			else if( ordre==NOM_DESC )
				requete.append(" order by tables_nom desc,tables_date_acte asc");
			else
				requete.append(" order by tables_nom asc,tables_date_acte asc");
			ps=conn.prepareStatement(requete.toString());
			int indice=1;
			if( date1!=null ) {
				ps.setDate(indice,date1);
				indice++;
			}
			if( date2!=null ) {
				ps.setDate(indice,date2);
				indice++;
			}

			if( pays.size()>0 ) {
				for(int cpt=0;cpt<pays.size();cpt++) {
					int id=((Integer)pays.elementAt(cpt)).intValue();
					ps.setInt(indice,id);
					indice++;
				}
			}

			if( departements.size()>0 ) {
				for(int cpt=0;cpt<departements.size();cpt++) {
					int id=((Integer)departements.elementAt(cpt)).intValue();
					ps.setInt(indice,id);
					indice++;
				}
			}

			if( communes.size()>0 ) {
				for(int cpt=0;cpt<communes.size();cpt++) {
					int id=((Integer)communes.elementAt(cpt)).intValue();
					ps.setInt(indice,id);
					indice++;
				}
			}

			if( communesFamilles.size()>0 ) {
				for(int cpt=0;cpt<communesFamilles.size();cpt++) {
					int id=((Integer)communesFamilles.elementAt(cpt)).intValue();
					ps.setInt(indice,id);
					indice++;
				}
			}

			rs=ps.executeQuery();
			while( rs.next() ) {
				RegistreActe rau=new RegistreActe(rs.getInt("tables_id"),
					rs.getString("tables_nom"),rs.getString("tables_prenom"),rs.getInt("type_acte_id"),rs.getString("type_acte_nom"),
					rs.getDate("tables_date_acte"),rs.getInt("tables_commune_id"),
					rs.getString("commune_nom")+" ( "+rs.getString("departement_numero")+" )",
					rs.getInt("tables_personne_id"),rs.getInt("tables_id_pere"),rs.getString("tables_nom_pere"),
					rs.getString("tables_prenom_pere"),rs.getInt("tables_personne_pere_age"),
					rs.getInt("tables_id_mere"),rs.getString("tables_nom_mere"),rs.getString("tables_prenom_mere"),
					rs.getInt("tables_personne_mere_age"),rs.getInt("tables_id_dependance"),
					rs.getInt("tables_doublon"),rs.getInt("tables_personne_homme"),rs.getInt("tables_personne_age"),
					rs.getString("tables_personne_origine"));
				registres.addElement(rau);
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}

		return registres;
	}

	public Vector getDoublonsTables() {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector registres=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append(" select tables_nom,tables_date_acte,tables_type_acte_id,tables_commune_id,count(*) as nb,tables_id");
			requete.append(" from tables");
			requete.append(" group by tables_nom,tables_date_acte,tables_type_acte_id,tables_commune_id");
			ps=conn.prepareStatement(requete.toString());
			rs=ps.executeQuery();
			while( rs.next() ) {
				if( rs.getInt("nb")>1 )
					registres.addElement(new Integer(rs.getInt("tables_id")));
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}

		return registres;
	}
}