package org.genealogie.web;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.DocumentsDAO;
import org.genealogie.metier.dao.FamillesDAO;
import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.metier.modele.Acte;

public final class FicheActeAction extends CheckAction {
	public java.sql.Date getDate(String chaineDate) {
		java.sql.Date cDate=null;

		if( chaineDate==null || chaineDate.equals("") )
			return null;

		try {
			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			java.util.Date d=sdf.parse(chaineDate,pos);
			cDate=new java.sql.Date(d.getTime());

		} catch(Exception ex) {
		}
		return cDate;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id
			int id=0;
			if( request.getParameterValues("id")!=null ) {
				try {
					id=Integer.parseInt(request.getParameterValues("id")[0]);
				} catch(Exception ex) {}
			}

			if( id==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
			GenealogieDAO genealogie=new GenealogieDAO(conn);
			FamillesDAO familles=new FamillesDAO(conn);
			DocumentsDAO documents=new DocumentsDAO(conn);
			Acte acte=genealogie.getActe(id);

			if( acte==null ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'acte correspondant  l'id "+id);
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			//Vrifier les droits d'accs
			if( !isAccesTotal(request) ) {
				Vector famillesIds=familles.getFamillesActe(id);
				boolean contient=false;
				for(int cpt=0;cpt<famillesIds.size();cpt++) {
					int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
					if( contient(familleId,getAuth(request).getFamilles()) ) {
						contient=true;
						break;
					}
				}

				if( !contient ) {
					setNoCache(response);
					return (mapping.findForward("accueil"));
				}

				if( getAuth(request).getBorneSup()>0 ) {
					SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
					ParsePosition pos=new ParsePosition(0);
					java.util.Date tmp=sdf.parse("01/01/"+getAuth(request).getBorneSup(), pos);
					java.sql.Date dateBorneSup=new java.sql.Date(tmp.getTime());

					if( acte.getDate()!=null ) {
						if( (acte.getDate()).compareTo(dateBorneSup)>0 ) {
							setNoCache(response);
							return (mapping.findForward("accueil"));
						}
					}
				}
			}

			//Envoi des infos  la jsp
			request.setAttribute("acte",acte);
			String marge=acte.getMargeCommentaires();
			String corps=acte.getCommentaires();
			Vector lignesMarge=getTokens(marge);
			Vector lignesCorps=getTokens(corps);
			/*Vector lignesMarge=new Vector();
			Vector lignesCorps=new Vector();
			StringTokenizer st=new StringTokenizer(marge,"\n",false);
			StringTokenizer st1=new StringTokenizer(corps,"\n",false);
			while( st.hasMoreTokens() ) {
				lignesMarge.addElement(st.nextToken());
			}
			while( st1.hasMoreTokens() ) {
				lignesCorps.addElement(st1.nextToken());
			}*/
			request.setAttribute("marge",lignesMarge);
			request.setAttribute("corps",lignesCorps);
			StringTokenizer st2=new StringTokenizer(acte.getUrl(),",");
			Vector urls=new Vector();
			while( st2.hasMoreTokens() ) {
				String url=st2.nextToken();
				urls.addElement(url);
			}
			request.setAttribute("urls",urls);

			//Dependances
			Vector actesDependances=documents.getListeActesAssociesActe(id);
			Vector documentsDependances=documents.getListeDocumentsAssociesActe(id);
			actesDependances=filtrerActesBorneSup(actesDependances,getAuth(request).getBorneSup());
			request.setAttribute("actes-dependants",filtrerActes(familles,actesDependances,getAuth(request).getFamilles()));
			request.setAttribute("documents-dependants",filtrerDocuments(familles,documentsDependances,
							getAuth(request).getFamilles(),getAuth(request).getTypesDocuments()));

	
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}