package org.genealogie.web;

import java.io.IOException;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.genealogie.log.Log;

public final class LogoutAction extends Action {
	private Vector listeBases=null;
	private Vector listeBasesDescriptifs=null;

	private void setNoCache(HttpServletResponse response) {
		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Pragma", "no-cache");
		response.setHeader("Expires", "0");
	}

	public ActionForward execute(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		try {
			HttpSession session = request.getSession();
			session.invalidate();
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		}
	}
}