package org.genealogie.metier.arbre;

import java.util.Vector;

public class GraphicArbre {

	private EltCase racine;

	private Vector generations = new Vector();

	
	public GraphicArbre() {
		racine=null;
	}

	public EltCase getRacine() {
		return racine;
	}


	public Vector getGeneration(int generation) {
		if( generation>1 ) {
			generation-=2;
			if( generation>=0 && generation<generations.size() ) {
				return (Vector)generations.elementAt(generation);
			}
		}
		return null;
	}

	public int getNbGenerations() {
		if( racine==null )
			return 0;
		else
			return generations.size()+1;
	}

	public void setRacine(EltCase racine) {
		this.racine = racine;
	}

	public void setGeneration(Vector generation,int no) {
		if( no>1 && generation.size()==(new Double(Math.pow(2,no-1)).intValue()) ) {
			no-=2;
			if( no>=0 ) {
				if( no==generations.size() ) {
					generations.addElement(generation);
				} else if( no<generations.size() ) {
					generations.setElementAt(generation,no);
				}
			}
		}
	}
}