package org.genealogie.web;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.regexp.RE;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.metier.modele.Recherche;
import org.genealogie.utils.URLEncodingScheme;

public final class RechercherIdsPersonnesConsanguiniteAction extends CheckAction {
	private int NB_PAR_PAGES=20;
	public final static String NAISSANCE="naissance";
	public final static String BAPTEME="bapteme";
	public final static String MARIAGE="mariage";
	public final static String DECES="deces";
	public final static String INHUMATION="inhumation";

	public String getDate(String chaineDate) {

		if( chaineDate==null )
			return "";

		try {
			RE annee = new RE("^(\\d{4})$");
			RE moisAnnee = new RE("^(\\d{2}\\d{4})$");
			RE jourMoisAnnee = new RE("^(\\d{2}\\d{2}\\d{4})$");

			if( annee.match(chaineDate) )
				chaineDate="01/01/"+chaineDate;
			if( moisAnnee.match(chaineDate) )
				chaineDate="01/"+chaineDate;

			return chaineDate;
		} catch(Exception ex) {
		}
		return "";
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).isNull() ) {
				setNoCache(response);
				return (mapping.findForward("failure"));
			}

			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			StringBuffer chaineRecherche=new StringBuffer();
			String separateur="";
			//Chaine de recherche
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getNom()!=null ) {
				chaineRecherche.append(separateur+"nom=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getNom(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getPrenom()!=null ) {
				chaineRecherche.append(separateur+"prenom=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getPrenom(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getVille()!=null ) {
				chaineRecherche.append(separateur+"ville=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getVille(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getDateDebut()!=null ) {
				chaineRecherche.append(separateur+"dateDebut=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getDateDebut(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getDateFin()!=null ) {
				chaineRecherche.append(separateur+"dateFin=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getDateFin(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getNaissance()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getNaissance()).equals(NAISSANCE) ) {
				chaineRecherche.append(separateur+"naissance=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getNaissance(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getBapteme()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getBapteme()).equals(BAPTEME) ) {
				chaineRecherche.append(separateur+"bapteme=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getBapteme(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getMariage()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getMariage()).equals(MARIAGE) ) {
				chaineRecherche.append(separateur+"mariage=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getMariage(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getDeces()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getDeces()).equals(DECES) ) {
				chaineRecherche.append(separateur+"deces=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getDeces(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getInhumation()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getInhumation()).equals(INHUMATION) ) {
				chaineRecherche.append(separateur+"inhumation=");
				chaineRecherche.append(URLEncoder.encode(((RechercherIdsPersonnesConsanguiniteForm)form).getInhumation(),URLEncodingScheme.SCHEME));
				separateur="&";
			}

			//Page
			int page=0;
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getPage()!=null ) {
				try {
					page=Integer.parseInt(((RechercherIdsPersonnesConsanguiniteForm)form).getPage())-1;
					if( page<0 )
						page=0;
				} catch(Exception ex) {}
			}

			boolean rechercheNaissance=false;
			boolean rechercheBapteme=false;
			boolean rechercheMariage=false;
			boolean rechercheDeces=false;
			boolean rechercheInhumation=false;
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getNaissance()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getNaissance()).equals(NAISSANCE) )
				rechercheNaissance=true;
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getBapteme()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getBapteme()).equals(BAPTEME) )
				rechercheBapteme=true;
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getMariage()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getMariage()).equals(MARIAGE) )
				rechercheMariage=true;
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getDeces()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getDeces()).equals(DECES) )
				rechercheDeces=true;
			if( ((RechercherIdsPersonnesConsanguiniteForm)form).getInhumation()!=null
					&& (((RechercherIdsPersonnesConsanguiniteForm)form).getInhumation()).equals(INHUMATION) )
				rechercheInhumation=true;

			String nom="";
			String prenom="";
			String lieu="";
			String dateDebut="";
			String dateFin="";
			if( ((RechercherIdsPersonnesConsanguiniteForm) form).getNom()!=null )
				nom=((RechercherIdsPersonnesConsanguiniteForm) form).getNom();
			if( ((RechercherIdsPersonnesConsanguiniteForm) form).getPrenom()!=null )
				prenom=((RechercherIdsPersonnesConsanguiniteForm) form).getPrenom();
			if( ((RechercherIdsPersonnesConsanguiniteForm) form).getVille()!=null )
				lieu=((RechercherIdsPersonnesConsanguiniteForm) form).getVille();
			if( ((RechercherIdsPersonnesConsanguiniteForm) form).getDateDebut()!=null )
				dateDebut=((RechercherIdsPersonnesConsanguiniteForm) form).getDateDebut();
			if( ((RechercherIdsPersonnesConsanguiniteForm) form).getDateFin()!=null )
				dateFin=((RechercherIdsPersonnesConsanguiniteForm) form).getDateFin();

			String espace="";
			StringBuffer rech=new StringBuffer();
			//Nom & prenom
			if( !nom.equals("") ) {
				rech.append(espace+nom);
				espace=" ";
			}
			if( !prenom.equals("") ) {
				rech.append(espace+prenom);
				espace=" ";
			}

			//Type
			String and="";
			if( rechercheNaissance ) {
				rech.append(espace+"n(s)");
				and=" et ";
				espace=" ";
			}
			if( rechercheBapteme ) {
				rech.append(espace+and+"baptis(s)");
				and="et ";
				espace=" ";
			}
			if( rechercheMariage ) {
				rech.append(espace+and+"mari(s)");
				and=" et ";
				espace=" ";
			}
			if( rechercheDeces ) {
				rech.append(espace+and+"dcd(s)");
				and=" et ";
				espace=" ";
			}
			if( rechercheInhumation ) {
				rech.append(espace+and+"inhum(s)");
				and=" et ";
				espace=" ";
			}

			//Dates
			if( !dateDebut.equals("") || !dateFin.equals("") ) {
				if( !dateDebut.equals("") && !dateFin.equals("") ) {
					rech.append(espace+"entre "+dateDebut+" et "+dateFin);
					espace=" ";
				}
				if( !dateDebut.equals("") && dateFin.equals("") ) {
					rech.append(espace+"aprs "+dateDebut);
					espace=" ";
				}
				if( dateDebut.equals("") && !dateFin.equals("") ) {
					rech.append(espace+"avant "+dateFin);
					espace=" ";
				}
			}

			//Lieu
			if( !lieu.equals("") )
				rech.append(espace+" "+lieu);

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
			//do what you wish with myConnection
			GenealogieDAO genealogie=new GenealogieDAO(conn);
			Recherche ru=new Recherche(
				nom.toLowerCase(),prenom.toLowerCase(),
				rechercheNaissance,rechercheBapteme,rechercheMariage,rechercheDeces,rechercheInhumation,
				lieu.toUpperCase(),getDate(dateDebut),getDate(dateFin) );
			Vector personnes=null;
			if( isAccesTotal(request) )
				personnes=genealogie.getResultatsRecherche(ru);
			else
				personnes=genealogie.getResultatsRecherche(ru,getAuth(request).getFamilles());
			Vector resultats=new Vector();
			for(int cpt=page*NB_PAR_PAGES;cpt<personnes.size() && cpt<(page*NB_PAR_PAGES+NB_PAR_PAGES);cpt++) {
				resultats.addElement(personnes.elementAt(cpt));
			}

			int debut=0;
			int fin=personnes.size()/NB_PAR_PAGES;
			if( page-10>=0 )
				debut=page-10;
			if( page+10<=fin )
				fin=page+10;
			if( debut==0 )
				if( (personnes.size()/NB_PAR_PAGES)>=20 )
					fin=20;
			if( fin==((personnes.size()/NB_PAR_PAGES)) )
				if( (personnes.size()/NB_PAR_PAGES)-20>=0 )
					debut=(personnes.size()/NB_PAR_PAGES)-20;

			//Envoi des infos  la jsp
			request.setAttribute("result",resultats);
			request.setAttribute("page_debut",new Integer(debut+1));
			if( personnes.size()%NB_PAR_PAGES==0 )
				request.setAttribute("page_fin",new Integer(fin));
			else
				request.setAttribute("page_fin",new Integer(fin+1));
			request.setAttribute("page",new Integer(page+1));
			request.setAttribute("nombre",new Integer(personnes.size()));
			request.setAttribute("recherche",rech.toString());
			request.setAttribute("urlRecherche",chaineRecherche.toString());

			//Etape
			if( ((RechercherIdsPersonnesConsanguiniteForm) form).getEtape()!=null ) {
				String etape=((RechercherIdsPersonnesConsanguiniteForm) form).getEtape();
				if( etape.equals("1") )
					request.setAttribute("etape","2");
				else if( etape.equals("2") )
					request.setAttribute("etape","3");
				else
					request.setAttribute("etape","1");
			} else {
				request.setAttribute("etape","1");
			}
			if( ((RechercherIdsPersonnesConsanguiniteForm) form).getId()!=null ) {
				String id=((RechercherIdsPersonnesConsanguiniteForm) form).getId();
				request.setAttribute("id1",id);
			}
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}