package org.genealogie.web;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.regexp.RE;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.ejbs.sessions.genealogie.GenealogieBean;
import org.genealogie.log.Log;
import org.genealogie.utils.URLEncodingScheme;

public final class RechercherActesAction extends CheckAction {
	private int NB_PAR_PAGES=20;
	private final static String MARGE="marge";
	private final static String CORPS="corps";

	public java.sql.Date getDate(String chaineDate) {
		java.sql.Date cDate=null;

		if( chaineDate==null || chaineDate.equals("") )
			return null;

		try {
			RE annee = new RE("^(\\d{4})$");
			RE moisAnnee = new RE("^(\\d{2}\\d{4})$");
			RE jourMoisAnnee = new RE("^(\\d{2}\\d{2}\\d{4})$");

			if( annee.match(chaineDate) )
				chaineDate="01/01/"+chaineDate;
			if( moisAnnee.match(chaineDate) )
				chaineDate="01/"+chaineDate;

			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			java.util.Date d=sdf.parse(chaineDate,pos);
			cDate=new java.sql.Date(d.getTime());

		} catch(Exception ex) {
		}
		return cDate;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			if( ((RechercherActesForm)form).isNull() ) {
				setNoCache(response);
				return (mapping.findForward("failure"));
			}

			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			StringBuffer chaineRecherche=new StringBuffer();
			String separateur="";
			//Chaine de recherche
			if( ((RechercherActesForm)form).getRechercher()!=null ) {
				chaineRecherche.append(separateur+"rechercher=");
				chaineRecherche.append(URLEncoder.encode(((RechercherActesForm)form).getRechercher(),URLEncodingScheme.SCHEME));
				separateur="&";
			}			
			if( ((RechercherActesForm)form).getMarge()!=null ) {
				chaineRecherche.append(separateur+"marge=");
				chaineRecherche.append(URLEncoder.encode(((RechercherActesForm)form).getMarge(),URLEncodingScheme.SCHEME));
				separateur="&";
			}			
			if( ((RechercherActesForm)form).getCorps()!=null ) {
				chaineRecherche.append(separateur+"corps=");
				chaineRecherche.append(URLEncoder.encode(((RechercherActesForm)form).getCorps(),URLEncodingScheme.SCHEME));
				separateur="&";
			}			
			if( ((RechercherActesForm)form).getDateDebut()!=null ) {
				chaineRecherche.append(separateur+"dateDebut=");
				chaineRecherche.append(URLEncoder.encode(((RechercherActesForm)form).getDateDebut(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherActesForm)form).getDateFin()!=null ) {
				chaineRecherche.append(separateur+"dateFin=");
				chaineRecherche.append(URLEncoder.encode(((RechercherActesForm)form).getDateFin(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherActesForm)form).getVille()!=null ) {
				chaineRecherche.append(separateur+"ville=");
				chaineRecherche.append(URLEncoder.encode(((RechercherActesForm)form).getVille(),URLEncodingScheme.SCHEME));
				separateur="&";
			}			

			boolean rechercheMarge=false;
			boolean rechercheCorps=false;
			if( ((RechercherActesForm)form).getMarge()!=null
					&& (((RechercherActesForm)form).getMarge()).equals(MARGE) )
				rechercheMarge=true;
			if( ((RechercherActesForm)form).getCorps()!=null
					&& (((RechercherActesForm)form).getCorps()).equals(CORPS) )
				rechercheCorps=true;

			//Page
			int page=0;
			if( ((RechercherActesForm)form).getPage()!=null ) {
				try {
					page=Integer.parseInt(((RechercherActesForm)form).getPage())-1;
					if( page<0 )
						page=0;
				} catch(Exception ex) {}
			}

			String lieu="";
			String dateDebut="";
			String dateFin="";
			if( ((RechercherActesForm) form).getVille()!=null )
				lieu=((RechercherActesForm) form).getVille();
			if( ((RechercherActesForm) form).getDateDebut()!=null )
				dateDebut=((RechercherActesForm) form).getDateDebut();
			if( ((RechercherActesForm) form).getDateFin()!=null )
				dateFin=((RechercherActesForm) form).getDateFin();

			//Recherche
			StringBuffer rech=new StringBuffer();
			if( ((RechercherActesForm)form).getRechercher()!=null
						&& (((RechercherActesForm)form).getRechercher()).equals("") ) {
				rech.append(((RechercherActesForm)form).getRechercher());
				String and="";
				if( rechercheMarge ) {
					rech.append(" dans la marge");
					and=" et";
				}
				if( rechercheCorps )
					rech.append(and+" dans le corps");
			}

			String espace="";
			//Dates
			if( !dateDebut.equals("") || !dateFin.equals("") ) {
				if( !dateDebut.equals("") && !dateFin.equals("") ) {
					rech.append(espace+"entre "+dateDebut+" et "+dateFin);
					espace=" ";
				}
				if( !dateDebut.equals("") && dateFin.equals("") ) {
					rech.append(espace+"aprs "+dateDebut);
					espace=" ";
				}
				if( dateDebut.equals("") && !dateFin.equals("") ) {
					rech.append(espace+"avant "+dateFin);
					espace=" ";
				}
			}

			//Lieu
			if( !lieu.equals("") )
				rech.append(espace+" "+lieu);

			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			int borneSup=getAuth(request).getBorneSup();
			java.util.Date tmp=sdf.parse("01/01/"+borneSup, pos);
			java.sql.Date dateBorneSup=new java.sql.Date(tmp.getTime());

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
			GenealogieBean genealogie=new GenealogieBean(conn);
			Vector actes=null;
			//Vrifier les droits d'accs
			if( !isAccesTotal(request) ) {
				java.sql.Date debut=getDate(dateDebut);
				java.sql.Date fin=getDate(dateFin);
				if( borneSup>0 ) {
					if( fin!=null ) {
						if( fin.compareTo(dateBorneSup)>0 )
							fin=dateBorneSup;
					} else
						fin=dateBorneSup;
				}
				actes=genealogie.getResultatsRechercheActes(
						((RechercherActesForm)form).getRechercher(),
						rechercheMarge,rechercheCorps,
						debut,fin,lieu.toUpperCase(),
						getAuth(request)
				);
			} else {
				actes=genealogie.getResultatsRechercheActes(
						((RechercherActesForm)form).getRechercher(),
						rechercheMarge,rechercheCorps,
						getDate(dateDebut),getDate(dateFin),lieu.toUpperCase()
				);
			}
			Vector resultats=new Vector();
			for(int cpt=page*NB_PAR_PAGES;cpt<actes.size() && cpt<(page*NB_PAR_PAGES+NB_PAR_PAGES);cpt++) {
				resultats.addElement(actes.elementAt(cpt));
			}

			int debut=0;
			int fin=actes.size()/NB_PAR_PAGES;
			if( page-10>=0 )
				debut=page-10;
			if( page+10<=fin )
				fin=page+10;
			if( debut==0 )
				if( (actes.size()/NB_PAR_PAGES)>=20 )
					fin=20;
			if( fin==((actes.size()/NB_PAR_PAGES)) )
				if( (actes.size()/NB_PAR_PAGES)-20>=0 )
					debut=(actes.size()/NB_PAR_PAGES)-20;

			//Envoi des infos  la jsp
			request.setAttribute("result",resultats);
			request.setAttribute("page_debut",new Integer(debut+1));
			if( actes.size()%NB_PAR_PAGES==0 )
				request.setAttribute("page_fin",new Integer(fin));
			else
				request.setAttribute("page_fin",new Integer(fin+1));
			request.setAttribute("page",new Integer(page+1));
			request.setAttribute("nombre",new Integer(actes.size()));
			request.setAttribute("recherche",rech.toString());
			request.setAttribute("urlRecherche",chaineRecherche.toString());

			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
				else
					request.removeAttribute(mapping.getAttribute());
			}

			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
		}
	}
}