package org.genealogie.ejbs.entites.personne;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;

import org.genealogie.log.Log;
import org.genealogie.utils.CommuneUtils;
import org.genealogie.utils.PersonneUtils;

public class PersonneBean {
	public int personneId=0;
	public String personneNom=null;
	public String personnePrenom1=null;
	public String personnePrenom2=null;
	public String personnePrenom3=null;
	public String personneNaissance=null;
	public Date personneDateNaissance=null;
	public String personneDateNaissanceApp=null;
	public int personneCommuneIdNaissance=0;
	public String personneCommuneNaissance=null;
	public String personneBapteme=null;
	public Date personneDateBapteme=null;
	public String personneDateBaptemeApp=null;
	public int personneCommuneIdBapteme=0;
	public String personneCommuneBapteme=null;
	public String personneProfession=null;
	public String personneDeces=null;
	public Date personneDateDeces=null;
	public String personneDateDecesApp=null;
	public int personneCommuneIdDeces=0;
	public String personneCommuneDeces=null;
	public String personneInhumation=null;
	public Date personneDateInhumation=null;
	public String personneDateInhumationApp=null;
	public int personneCommuneIdInhumation=0;
	public String personneCommuneInhumation=null;
	public int personnePereId=0;
	public int personneMereId=0;
	public int personneParrainId=0;
	public int personneMarraineId=0;
	public String personnePere=null;
	public String personneMere=null;
	public String personneParrain=null;
	public String personneMarraine=null;
	public int personneEnfantNaturel=0;
	public String personneCommentaires=null;
	public String personneAdresses=null;
	public int personneHomme=1;

	public boolean naissanceCommunicable=true;
	public boolean baptemeCommunicable=true;
	public boolean decesCommunicable=true;
	public boolean inhumationCommunicable=true;

	public PersonnePK pk;

	private Connection connection;

	public PersonneBean(Connection connection) {
		this.connection=connection;
	}

	private Connection getConnection() throws SQLException {
		return connection;
	}

	private CommuneUtils getInfoCommune(int communeId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		CommuneUtils commune=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select commune_id,commune_nom,departement_nom,departement_numero,pays_nom");
			requete.append(" from commune,departement,pays");
			requete.append(" where commune.commune_departement_id=departement.departement_id");
			requete.append(" and departement.departement_pays_id=pays.pays_id");
			requete.append(" and commune.commune_id=?");
			requete.append(" order by commune_nom asc");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,communeId);
			rs=ps.executeQuery();
			if( rs.next() ) {
				commune=new CommuneUtils(rs.getInt("commune_id"),rs.getString("commune_nom"),rs.getString("departement_numero"),rs.getString("pays_nom"));
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return commune;
	}

	private PersonneUtils getPersonne(int personneId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		PersonneUtils personne=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select p1.personne_id,p1.personne_nom,p1.personne_prenom1,");
			requete.append("p1.personne_prenom2,p1.personne_prenom3");
			requete.append(" from personne p1");
			requete.append(" where personne_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,personneId);
			rs=ps.executeQuery();
			if( rs.next() ) {
				StringBuffer prenom=new StringBuffer();
				prenom.append(rs.getString("personne_prenom1"));
				if( rs.getString("personne_prenom2")!=null && !rs.getString("personne_prenom2").equals("") )
					prenom.append(" "+rs.getString("personne_prenom2"));
				if( rs.getString("personne_prenom3")!=null && !rs.getString("personne_prenom3").equals("") )
					prenom.append(" "+rs.getString("personne_prenom3"));
				personne=new PersonneUtils(rs.getInt("personne_id"),rs.getString("personne_nom"),prenom.toString());
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return personne;
	}

	public PersonnePK ejbCreate(String personneNom,String personnePrenom1) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();
			int personneId=1;
//			ps=conn.prepareStatement("select NEXTVAL('personne_id_seq') as id");
			ps=conn.prepareStatement("select max(personne_id) as id from personne");
			rs=ps.executeQuery();
			if( rs.next() ) {
				personneId=rs.getInt("id")+1;
			}

			String requete="insert into personne (personne_id,personne_nom,personne_prenom1,personne_enfant_naturel,personne_homme) values(?,?,?,0,0)";
			ps=conn.prepareStatement(requete);
			ps.setInt(1,personneId);
			ps.setString(2,personneNom);
			ps.setString(3,personnePrenom1);

			int nb=ps.executeUpdate();
			conn.commit();
			this.personneId=personneId;
			this.personneNom=personneNom;
			this.personnePrenom1=personnePrenom1;

			pk=new PersonnePK();
			pk.personneId=personneId;
			return pk;
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return null;
	}

	public PersonnePK ejbFindByPrimaryKey(PersonnePK pk) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();
			ps=conn.prepareStatement("select personne_id from personne where personne_id=?");
			ps.setInt(1,pk.personneId);
			rs=ps.executeQuery();
			if( !rs.next() )
				return null;
			this.pk=pk;
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return pk;
	}

	public void ejbLoad() {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();
			String requete="select personne_id,personne_nom,personne_prenom1,personne_prenom2,personne_prenom3,personne_parrain_id,personne_marraine_id,personne_date_naissance,personne_date_naissance_app,personne_commune_id_naissance,personne_date_bapteme,personne_date_bapteme_app,personne_commune_id_bapteme,personne_profession,personne_date_deces,personne_date_deces_app,personne_commune_id_deces,personne_date_inhumation,personne_date_inhumation_app,personne_commune_id_inhumation,personne_pere_id,personne_mere_id,personne_enfant_naturel,personne_commentaires,personne_adresses,personne_homme from personne where personne_id=?";
			ps=conn.prepareStatement(requete);
			ps.setInt(1,pk.personneId);
			rs=ps.executeQuery();
			if( rs.next() ) {
				personneId=pk.personneId;
				personneNom=rs.getString("personne_nom");
				personnePrenom1=rs.getString("personne_prenom1");
				personnePrenom2=rs.getString("personne_prenom2");
				personnePrenom3=rs.getString("personne_prenom3");
				personneParrainId=rs.getInt("personne_parrain_id");
				personneMarraineId=rs.getInt("personne_marraine_id");
				personneDateNaissance=rs.getDate("personne_date_naissance");
				personneDateNaissanceApp=rs.getString("personne_date_naissance_app");
				personneCommuneIdNaissance=rs.getInt("personne_commune_id_naissance");
				personneDateBapteme=rs.getDate("personne_date_bapteme");
				personneDateBaptemeApp=rs.getString("personne_date_bapteme_app");
				personneCommuneIdBapteme=rs.getInt("personne_commune_id_bapteme");
				personneProfession=rs.getString("personne_profession");
				personneDateDeces=rs.getDate("personne_date_deces");
				personneDateDecesApp=rs.getString("personne_date_deces_app");
				personneCommuneIdDeces=rs.getInt("personne_commune_id_deces");
				personneDateInhumation=rs.getDate("personne_date_inhumation");
				personneDateInhumationApp=rs.getString("personne_date_inhumation_app");
				personneCommuneIdInhumation=rs.getInt("personne_commune_id_inhumation");
				personnePereId=rs.getInt("personne_pere_id");
				personneMereId=rs.getInt("personne_mere_id");
				personneEnfantNaturel=rs.getInt("personne_enfant_naturel");
				personneCommentaires=rs.getString("personne_commentaires");
				personneAdresses=rs.getString("personne_adresses");
				personneHomme=rs.getInt("personne_homme");
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}

		getPersonneNaissance();
		getPersonneBapteme();
		getPersonneDeces();
		getPersonneInhumation();

		getPersonnePere();
		getPersonneMere();
		getPersonneParrain();
		getPersonneMarraine();
	}

	public void ejbStore() {
		Connection conn=null;
		PreparedStatement ps=null;

		try {
			conn=getConnection();
			StringBuffer requete=new StringBuffer("update personne set ");

			requete.append("personne_nom=?");
			requete.append(",personne_prenom1=?");
			if( personnePrenom2!=null )
				requete.append(",personne_prenom2=?");
			else
				requete.append(",personne_prenom2=null");
			if( personnePrenom3!=null )
				requete.append(",personne_prenom3=?");
			else
				requete.append(",personne_prenom3=null");
			if( personneDateNaissance!=null )
				requete.append(",personne_date_naissance=?");
			else
				requete.append(",personne_date_naissance=null");
			if( personneDateNaissanceApp!=null )
				requete.append(",personne_date_naissance_app=?");
			else
				requete.append(",personne_date_naissance_app=null");
			if( personneCommuneIdNaissance!=0 )
				requete.append(",personne_commune_id_naissance=?");
			else
				requete.append(",personne_commune_id_naissance=null");
			if( personneDateBapteme!=null )
				requete.append(",personne_date_bapteme=?");
			else
				requete.append(",personne_date_bapteme=null");
			if( personneDateBaptemeApp!=null )
				requete.append(",personne_date_bapteme_app=?");
			else
				requete.append(",personne_date_bapteme_app=null");
			if( personneCommuneIdBapteme!=0 )
				requete.append(",personne_commune_id_bapteme=?");
			else
				requete.append(",personne_commune_id_bapteme=null");
			if( personneProfession!=null )
				requete.append(",personne_profession=?");
			else
				requete.append(",personne_profession=null");
			if( personneDateDeces!=null )
				requete.append(",personne_date_deces=?");
			else
				requete.append(",personne_date_deces=null");
			if( personneDateDecesApp!=null )
				requete.append(",personne_date_deces_app=?");
			else
				requete.append(",personne_date_deces_app=null");
			if( personneCommuneIdDeces!=0 )
				requete.append(",personne_commune_id_deces=?");
			else
				requete.append(",personne_commune_id_deces=null");
			if( personneDateInhumation!=null )
				requete.append(",personne_date_inhumation=?");
			else
				requete.append(",personne_date_inhumation=null");
			if( personneDateInhumationApp!=null )
				requete.append(",personne_date_inhumation_app=?");
			else
				requete.append(",personne_date_inhumation_app=null");
			if( personneCommuneIdInhumation!=0 )
				requete.append(",personne_commune_id_inhumation=?");
			else
				requete.append(",personne_commune_id_inhumation=null");
			if( personnePereId!=0 )
				requete.append(",personne_pere_id=?");
			else
				requete.append(",personne_pere_id=null");
			if( personneMereId!=0 )
				requete.append(",personne_mere_id=?");
			else
				requete.append(",personne_mere_id=null");
			if( personneParrainId!=0 )
				requete.append(",personne_parrain_id=?");
			else
				requete.append(",personne_parrain_id=null");
			if( personneMarraineId!=0 )
				requete.append(",personne_marraine_id=?");
			else
				requete.append(",personne_marraine_id=null");
			requete.append(",personne_enfant_naturel=?");
			if( personneCommentaires!=null )
				requete.append(",personne_commentaires=?");
			else
				requete.append(",personne_commentaires=null");
			if( personneAdresses!=null )
				requete.append(",personne_adresses=?");
			else
				requete.append(",personne_adresses=null");
			requete.append(",personne_homme=?");
			requete.append(" where personne_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setString(1,personneNom);
			ps.setString(2,personnePrenom1);
			int indice=3;
			if( personnePrenom2!=null ) {
				ps.setString(indice,personnePrenom2);
				indice++;
			}
			if( personnePrenom3!=null ) {
				ps.setString(indice,personnePrenom3);
				indice++;
			}
			if( personneDateNaissance!=null ) {
				ps.setDate(indice,personneDateNaissance);
				indice++;
			}
			if( personneDateNaissanceApp!=null ) {
				ps.setString(indice,personneDateNaissanceApp);
				indice++;
			}
			if( personneCommuneIdNaissance!=0 ) {
				ps.setInt(indice,personneCommuneIdNaissance);
				indice++;
			}
			if( personneDateBapteme!=null ) {
				ps.setDate(indice,personneDateBapteme);
				indice++;
			}
			if( personneDateBaptemeApp!=null ) {
				ps.setString(indice,personneDateBaptemeApp);
				indice++;
			}
			if( personneCommuneIdBapteme!=0 ) {
				ps.setInt(indice,personneCommuneIdBapteme);
				indice++;
			}
			if( personneProfession!=null ) {
				ps.setString(indice,personneProfession);
				indice++;
			}
			if( personneDateDeces!=null ) {
				ps.setDate(indice,personneDateDeces);
				indice++;
			}
			if( personneDateDecesApp!=null ) {
				ps.setString(indice,personneDateDecesApp);
				indice++;
			}
			if( personneCommuneIdDeces!=0 ) {
				ps.setInt(indice,personneCommuneIdDeces);
				indice++;
			}
			if( personneDateInhumation!=null ) {
				ps.setDate(indice,personneDateInhumation);
				indice++;
			}
			if( personneDateInhumationApp!=null ) {
				ps.setString(indice,personneDateInhumationApp);
				indice++;
			}
			if( personneCommuneIdInhumation!=0 ) {
				ps.setInt(indice,personneCommuneIdInhumation);
				indice++;
			}
			if( personnePereId!=0 ) {
				ps.setInt(indice,personnePereId);
				indice++;
			}
			if( personneMereId!=0 ) {
				ps.setInt(indice,personneMereId);
				indice++;
			}
			if( personneParrainId!=0 ) {
				ps.setInt(indice,personneParrainId);
				indice++;
			}
			if( personneMarraineId!=0 ) {
				ps.setInt(indice,personneMarraineId);
				indice++;
			}
			ps.setInt(indice,personneEnfantNaturel);
			indice++;
			if( personneCommentaires!=null ) {
				ps.setString(indice,personneCommentaires);
				indice++;
			}
			if( personneAdresses!=null ) {
				ps.setString(indice,personneAdresses);
				indice++;
			}
			ps.setInt(indice,personneHomme);
			indice++;
			ps.setInt(indice,pk.personneId);
			int nb=ps.executeUpdate();
			conn.commit();
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
		} finally {
			try {
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
	}

	public void ejbRemove() {
		Connection conn=null;
		PreparedStatement ps=null;

		try {
			conn=getConnection();
			ps=conn.prepareStatement("delete from personne where personne_id=?");
			ps.setInt(1,personneId);
			int nb=ps.executeUpdate();
			conn.commit();
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
		} finally {
			try {
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
	}

	public int getPersonneId() {
		return personneId;
	}

	public void setPersonneId(int personneId) {
		this.personneId=personneId;
	}

	public String getPersonneNom() {
		return personneNom;
	}

	public void setPersonneNom(String personneNom) {
		this.personneNom=personneNom;
	}
	public String getPersonnePrenom1() {
		return personnePrenom1;
	}

	public void setPersonnePrenom1(String personnePrenom1) {
		this.personnePrenom1=personnePrenom1;
	}
	public String getPersonnePrenom2() {
		return personnePrenom2;
	}

	public void setPersonnePrenom2(String personnePrenom2) {
		this.personnePrenom2=personnePrenom2;
	}
	public String getPersonnePrenom3() {
		return personnePrenom3;
	}

	public void setPersonnePrenom3(String personnePrenom3) {
		this.personnePrenom3=personnePrenom3;
	}

	public String getPersonneNaissance() {
		if( !naissanceCommunicable )
			return "( date & lieu non communicables )";

		if( personneNaissance==null ) {
			StringBuffer chaine=new StringBuffer();
			if( personneDateNaissance!=null )
				chaine.append(getPersonneDateNaissanceString());
			else if( personneDateNaissanceApp!=null && !personneDateNaissanceApp.equals("") )
				chaine.append(getPersonneDateNaissanceApp());

			String espace="";
			if( !(chaine.toString()).equals("") )
				espace=" ";

			if( personneCommuneIdNaissance!=0 )
				chaine.append(espace+" "+getPersonneCommuneNaissance());
			personneNaissance=chaine.toString();
		}

		return personneNaissance;
	}

	public Date getPersonneDateNaissance() {
		return personneDateNaissance;
	}
	public String getPersonneDateNaissanceString() {
		SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
		if( personneDateNaissance!=null )
			return sdf.format( personneDateNaissance );
		return "";
	}

	public void setPersonneDateNaissance(Date personneDateNaissance) {
		this.personneDateNaissance=personneDateNaissance;
	}
	public String getPersonneDateNaissanceApp() {
		return personneDateNaissanceApp;
	}

	public void setPersonneDateNaissanceApp(String personneDateNaissanceApp) {
		this.personneDateNaissanceApp=personneDateNaissanceApp;
	}
	public int getPersonneCommuneIdNaissance() {
		return personneCommuneIdNaissance;
	}
	public String getPersonneCommuneNaissance() {
		if( personneCommuneNaissance==null ) {
			if( personneCommuneIdNaissance!=0 ) {
				CommuneUtils commune=getInfoCommune(personneCommuneIdNaissance);
				if( commune!=null )
					personneCommuneNaissance=commune.getNom()+" ( "+commune.getDepartement()+" )";
			} else
				personneCommuneNaissance="";
		}
		return personneCommuneNaissance;
	}

	public void setPersonneCommuneIdNaissance(int personneCommuneIdNaissance) {
		this.personneCommuneIdNaissance=personneCommuneIdNaissance;
	}

	public String getPersonneBapteme() {
		if( !baptemeCommunicable )
			return "( date & lieu non communicables )";

		if( personneBapteme==null ) {
			StringBuffer chaine=new StringBuffer();
			if( personneDateNaissance!=null )
				chaine.append(getPersonneDateBaptemeString());
			else if( getPersonneDateBaptemeApp()!=null && !getPersonneDateBaptemeApp().equals("") )
				chaine.append(getPersonneDateBaptemeApp());

			String espace="";
			if( !(chaine.toString()).equals("") )
				espace=" ";

			if( personneCommuneIdBapteme!=0 )
				chaine.append(espace+" "+getPersonneCommuneBapteme());

			personneBapteme=chaine.toString();
		}

		return personneBapteme;
	}

	public Date getPersonneDateBapteme() {
		return personneDateBapteme;
	}
	public String getPersonneDateBaptemeString() {
		SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
		if( personneDateBapteme!=null )
			return sdf.format( personneDateBapteme );
		return "";
	}

	public void setPersonneDateBapteme(Date personneDateBapteme) {
		this.personneDateBapteme=personneDateBapteme;
	}
	public String getPersonneDateBaptemeApp() {
		return personneDateBaptemeApp;
	}

	public void setPersonneDateBaptemeApp(String personneDateBaptemeApp) {
		this.personneDateBaptemeApp=personneDateBaptemeApp;
	}
	public int getPersonneCommuneIdBapteme() {
		return personneCommuneIdBapteme;
	}

	public String getPersonneCommuneBapteme() {
		if( personneCommuneBapteme==null ) {
			if( personneCommuneIdBapteme!=0 ) {
				CommuneUtils commune=getInfoCommune(personneCommuneIdBapteme);
				personneCommuneBapteme=commune.getNom()+" ( "+commune.getDepartement()+" )";
			} else
				personneCommuneBapteme="";
		}
		return personneCommuneBapteme;
	}

	public void setPersonneCommuneIdBapteme(int personneCommuneIdBapteme) {
		this.personneCommuneIdBapteme=personneCommuneIdBapteme;
	}

	public String getPersonneProfession() {
		return personneProfession;
	}

	public void setPersonneProfession(String personneProfession) {
		this.personneProfession=personneProfession;
	}

	public String getPersonneDeces() {
		if( !decesCommunicable )
			return "( date & lieu non communicables )";

		if( personneDeces==null ) {
			StringBuffer chaine=new StringBuffer();
			if( personneDateDeces!=null )
				chaine.append(getPersonneDateDecesString());
			else if( getPersonneDateDecesApp()!=null && !getPersonneDateDecesApp().equals("") )
				chaine.append(getPersonneDateDecesApp());

			String espace="";
			if( !(chaine.toString()).equals("") )
				espace=" ";

			if( personneCommuneIdDeces!=0 )
				chaine.append(espace+" "+getPersonneCommuneDeces());

			personneDeces=chaine.toString();
		}

		return personneDeces;
	}

	public Date getPersonneDateDeces() {
		return personneDateDeces;
	}
	public String getPersonneDateDecesString() {
		SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
		if( personneDateDeces!=null )
			return sdf.format( personneDateDeces );
		return "";
	}

	public void setPersonneDateDeces(Date personneDateDeces) {
		this.personneDateDeces=personneDateDeces;
	}
	public String getPersonneDateDecesApp() {
		return personneDateDecesApp;
	}

	public void setPersonneDateDecesApp(String personneDateDecesApp) {
		this.personneDateDecesApp=personneDateDecesApp;
	}
	public int getPersonneCommuneIdDeces() {
		return personneCommuneIdDeces;
	}

	public String getPersonneCommuneDeces() {
		if( personneCommuneDeces==null ) {
			if( personneCommuneIdDeces!=0 ) {
				CommuneUtils commune=getInfoCommune(personneCommuneIdDeces);
				personneCommuneDeces=commune.getNom()+" ( "+commune.getDepartement()+" )";
			} else
				personneCommuneDeces="";
		}
		return personneCommuneDeces;
	}

	public void setPersonneCommuneIdDeces(int personneCommuneIdDeces) {
		this.personneCommuneIdDeces=personneCommuneIdDeces;
	}

	public String getPersonneInhumation() {
		if( !inhumationCommunicable )
			return "( date & lieu non communicables )";

		if( personneInhumation==null ) {
			StringBuffer chaine=new StringBuffer();
			if( personneDateInhumation!=null )
				chaine.append(getPersonneDateInhumationString());
			else if( getPersonneDateInhumationApp()!=null && !getPersonneDateInhumationApp().equals("") )
				chaine.append(getPersonneDateInhumationApp());

			String espace="";
			if( !(chaine.toString()).equals("") )
				espace=" ";

			if( personneCommuneIdInhumation!=0 )
				chaine.append(espace+" "+getPersonneCommuneInhumation());

			personneInhumation=chaine.toString();
		}

		return personneInhumation;
	}

	public Date getPersonneDateInhumation() {
		return personneDateInhumation;
	}

	public String getPersonneDateInhumationString() {
		SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
		if( personneDateInhumation!=null )
			return sdf.format( personneDateInhumation );
		return "";
	}

	public void setPersonneDateInhumation(Date personneDateInhumation) {
		this.personneDateInhumation=personneDateInhumation;
	}
	public String getPersonneDateInhumationApp() {
		return personneDateInhumationApp;
	}

	public void setPersonneDateInhumationApp(String personneDateInhumationApp) {
		this.personneDateInhumationApp=personneDateInhumationApp;
	}
	public String getPersonneCommuneInhumation() {
		if( personneCommuneInhumation==null ) {
			if( personneCommuneIdInhumation!=0 ) {
				CommuneUtils commune=getInfoCommune(personneCommuneIdInhumation);
				personneCommuneInhumation=commune.getNom()+" ( "+commune.getDepartement()+" )";
			} else
				personneCommuneInhumation="";
		}
		return personneCommuneInhumation;
	}

	public void setPersonneCommuneIdInhumation(int personneCommuneIdInhumation) {
		this.personneCommuneIdInhumation=personneCommuneIdInhumation;
	}
	public int getPersonnePereId() {
		return personnePereId;
	}
	public String getPersonnePere() {
		if( personnePere==null ) {
			if( personnePereId!=0 ) {
				PersonneUtils p=getPersonne(personnePereId);
				personnePere=p.getNom()+" "+p.getPrenom();
			} else
				personnePere="";
		}
		return personnePere;
	}

	public void setPersonnePereId(int personnePereId) {
		this.personnePereId=personnePereId;
	}
	public int getPersonneMereId() {
		return personneMereId;
	}
	public String getPersonneMere() {
		if( personneMere==null ) {
			if( personneMereId!=0 ) {
				PersonneUtils p=getPersonne(personneMereId);
				personneMere=p.getNom()+" "+p.getPrenom();
			} else
				personneMere="";
		}
		return personneMere;
	}

	public void setPersonneMereId(int personneMereId) {
		this.personneMereId=personneMereId;
	}

	public int getPersonneParrainId() {
		return personneParrainId;
	}

	public String getPersonneParrain() {
		if( personneParrain==null ) {
			if( personneParrainId!=0 ) {
				PersonneUtils p=getPersonne(personneParrainId);
				personneParrain=p.getNom()+" "+p.getPrenom();
			} else
				personneParrain="";
		}
		return personneParrain;
	}

	public void setPersonneParrainId(int personneParrainId) {
		this.personneParrainId=personneParrainId;
	}
	public int getPersonneMarraineId() {
		return personneMarraineId;
	}

	public String getPersonneMarraine() {
		if( personneMarraine==null ) {
			if( personneMarraineId!=0 ) {
				PersonneUtils p=getPersonne(personneMarraineId);
				personneMarraine=p.getNom()+" "+p.getPrenom();
			} else
				personneMarraine="";
		}
		return personneMarraine;
	}

	public void setPersonneMarraineId(int personneMarraineId) {
		this.personneMarraineId=personneMarraineId;
	}

	public int getPersonneEnfantNaturel() {
		return personneEnfantNaturel;
	}

	public void setPersonneEnfantNaturel(int personneEnfantNaturel) {
		this.personneEnfantNaturel=personneEnfantNaturel;
	}
	public String getPersonneCommentaires() {
		return personneCommentaires;
	}

	public void setPersonneCommentaires(String personneCommentaires) {
		this.personneCommentaires=personneCommentaires;
	}
	public String getPersonneAdresses() {
		return personneAdresses;
	}

	public void setPersonneAdresses(String personneAdresses) {
		this.personneAdresses=personneAdresses;
	}

	public int getPersonneHomme() {
		return personneHomme;
	}

	public void setPersonneHomme(int personneHomme) {
		this.personneHomme=personneHomme;
	}

	public void setNaissanceCommunicable(boolean naissanceCommunicable) {
		this.naissanceCommunicable=naissanceCommunicable;
	}

	public void setBaptemeCommunicable(boolean baptemeCommunicable) {
		this.baptemeCommunicable=baptemeCommunicable;
	}

	public void setDecesCommunicable(boolean decesCommunicable) {
		this.decesCommunicable=decesCommunicable;
	}

	public void setInhumationCommunicable(boolean inhumationCommunicable) {
		this.inhumationCommunicable=inhumationCommunicable;
	}
}
