package org.genealogie.ejbs.sessions.genealogie;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

import org.genealogie.log.Log;
import org.genealogie.utils.AuthUtils;

public class AuthentificationBean {

	private Connection connection;


	public AuthentificationBean(Connection connection) {
		this.connection=connection;
	}

	private Connection getConnection() throws SQLException {
		return connection;
	}

	public AuthUtils authentifier(String login,String password) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			/*
			    ACCES_ID                        INTEGER           not null,
			    ACCES_LOGIN                     VARCHAR(50)       not null,
			    ACCES_PASSWORD                  VARCHAR(50)       not null,
			    ACCES_TOTAL                     INTEGER           not null,
			    ACCES_TOUT_TYPE_DOCUMENT_SAUF   INTEGER           not null,
			    ACCES_TOUTE_FAMILLE_SAUF        INTEGER           not null,
			    ACCES_TOUT_PAYS_SAUF            INTEGER           not null,
			    ACCES_TOUT_DEPARTEMENT_SAUF     INTEGER           not null,
			    ACCES_TOUTE_COMMUNE_SAUF        INTEGER           not null,
			*/

			StringBuffer requete=new StringBuffer();
			requete.append("select acces_id,acces_total,acces_active,acces_borne_sup");
			requete.append(" from acces");
			requete.append(" where acces_login=? and acces_password=? and acces_active=1");
			ps=conn.prepareStatement(requete.toString());
			ps.setString(1,login);
			ps.setString(2,password);
			rs=ps.executeQuery();
			int idAcces=0;
			int accesTotal=0;
			int accesActive=0;
			int borneSup=0;
			if( rs.next() ) {
				idAcces=rs.getInt("acces_id");
				accesTotal=rs.getInt("acces_total");
				accesActive=rs.getInt("acces_active");
				borneSup=rs.getInt("acces_borne_sup");
			}

			if( idAcces!=0 ) {
				//Familles
				requete=new StringBuffer();
				requete.append("select famille_id from acces_famille where acces_id=?");
				ps=conn.prepareStatement(requete.toString());
				ps.setInt(1,idAcces);
				Vector familles=new Vector();
				rs=ps.executeQuery();
				while( rs.next() ) {
					familles.addElement(new Integer(rs.getInt("famille_id")));
				}

				//Types de documents
				requete=new StringBuffer();
				requete.append("select type_document_id from acces_type_document where acces_id=?");
				ps=conn.prepareStatement(requete.toString());
				ps.setInt(1,idAcces);
				Vector typesDocuments=new Vector();
				rs=ps.executeQuery();
				while( rs.next() ) {
					typesDocuments.addElement(new Integer(rs.getInt("type_document_id")));
				}

				//Pays
				requete=new StringBuffer();
				requete.append("select pays_id from acces_pays where acces_id=?");
				ps=conn.prepareStatement(requete.toString());
				ps.setInt(1,idAcces);
				Vector pays=new Vector();
				rs=ps.executeQuery();
				while( rs.next() ) {
					pays.addElement(new Integer(rs.getInt("pays_id")));
				}

				//Departements
				requete=new StringBuffer();
				requete.append("select departement_id from acces_departement where acces_id=?");
				ps=conn.prepareStatement(requete.toString());
				ps.setInt(1,idAcces);
				Vector departements=new Vector();
				rs=ps.executeQuery();
				while( rs.next() ) {
					departements.addElement(new Integer(rs.getInt("departement_id")));
				}

				//Communes
				requete=new StringBuffer();
				requete.append("select commune_id from acces_commune where acces_id=?");
				ps=conn.prepareStatement(requete.toString());
				ps.setInt(1,idAcces);
				Vector communes=new Vector();
				rs=ps.executeQuery();
				while( rs.next() ) {
					communes.addElement(new Integer(rs.getInt("commune_id")));
				}

				return new AuthUtils(idAcces,login,password,accesTotal==1?true:false,
					accesActive==1?true:false,borneSup,
					familles,typesDocuments,pays,departements,communes);
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return null;
	}
}