package org.genealogie.ejbs.sessions.genealogie;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

import org.genealogie.log.Log;
import org.genealogie.utils.FamilleUtils;
import org.genealogie.utils.PersonneUtils;

public class FamillesBean {

	private Connection connection;


	public FamillesBean(Connection connection) {
		this.connection=connection;
	}

	private Connection getConnection() throws SQLException {
		return connection;
	}

	public Vector getListeFamilles() {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector familles=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select famille_id,famille_nom");
			requete.append(" from famille");
			requete.append(" order by famille_nom asc");
			ps=conn.prepareStatement(requete.toString());
			rs=ps.executeQuery();
			while( rs.next() ) {
				FamilleUtils p=new FamilleUtils(rs.getInt("famille_id"),rs.getString("famille_nom"));
				familles.addElement(p);
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return familles;
	}

	public FamilleUtils getFamille(int familleId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select famille_id,famille_nom");
			requete.append(" from famille");
			requete.append(" where famille_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,familleId);
			rs=ps.executeQuery();
			if( rs.next() ) {
				FamilleUtils p=new FamilleUtils(rs.getInt("famille_id"),rs.getString("famille_nom"));
				return p;
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return null;
	}

	public FamilleUtils ajouterFamille(FamilleUtils famille) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			int id=1;
//			ps=conn.prepareStatement("select NEXTVAL('document_id_seq') as id");
			ps=conn.prepareStatement("select max(famille_id) as id from famille");
			rs=ps.executeQuery();
			if( rs.next() ) {
				id=rs.getInt("id")+1;
			}

			StringBuffer requete=new StringBuffer();
			requete.append("insert into famille values(?,?)");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,id);
			famille.setId(id);
			ps.setString(2,famille.getNom());
			int nb=ps.executeUpdate();
			if( nb==0 )
				return null;
			conn.commit();
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
			return null;
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return famille;
	}

	public int supprimerFamille(int idFamille) {
		Connection conn=null;
		PreparedStatement ps=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("delete from famille where famille_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,idFamille);
			int nb=ps.executeUpdate();
			conn.commit();
			return nb;
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
			return 0;
		} finally {
			try {
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
	}

	public FamilleUtils modifierFamille(FamilleUtils famille) {
		Connection conn=null;
		PreparedStatement ps=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("update famille set famille_nom=?");
			requete.append(" where famille_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setString(1,famille.getNom());
			ps.setInt(2,famille.getId());
			int nb=ps.executeUpdate();
			conn.commit();
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
		} finally {
			try {
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return famille;
	}

	public int associerPersonneFamille(int personneId,int familleId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select * from liaison_famille");
			requete.append(" where personne_id=? and famille_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,personneId);
			ps.setInt(2,familleId);
			rs=ps.executeQuery();
			if( rs.next() )
				return 1;

			requete=new StringBuffer();
			requete.append("insert into liaison_famille (famille_id,personne_id) values(?,?)");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,familleId);
			ps.setInt(2,personneId);
			int nb=ps.executeUpdate();
			if( nb==0 )
				return 0;
			conn.commit();
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
			return 0;
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return 2;
	}

	public int associerPersonneFamille(Vector personnesId,int familleId) {
		Connection conn=null;
		PreparedStatement ps=null;
		PreparedStatement ps1=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select * from liaison_famille");
			requete.append(" where personne_id=? and famille_id=?");
			ps=conn.prepareStatement(requete.toString());

			requete=new StringBuffer();
			requete.append("insert into liaison_famille (personne_id,famille_id) values(?,?)");
			ps1=conn.prepareStatement(requete.toString());

			for(int cpt=0;cpt<personnesId.size();cpt++) {
				int personneId=((Integer)personnesId.elementAt(cpt)).intValue();

				//Existe dj
				ps.setInt(1,personneId);
				ps.setInt(2,familleId);
				rs=ps.executeQuery();
				if( rs.next() )
					continue;

				//MAJ
				ps1.setInt(1,personneId);
				ps1.setInt(2,familleId);
				int nb=ps1.executeUpdate();
				if( nb==0 )
					return 1;
			}
			conn.commit();
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
			return 0;
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
				if( ps1!=null )
					ps1.close();
			} catch(SQLException ex) {
			}
		}
		return 2;
	}

	public boolean deassocierPersonneFamille(int personneId,int familleId) {
		Connection conn=null;
		PreparedStatement ps=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("delete from liaison_famille where famille_id=? and personne_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,familleId);
			ps.setInt(2,personneId);
			int nb=ps.executeUpdate();
			if( nb==0 )
				return false;
			conn.commit();
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
			return false;
		} finally {
			try {
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return true;
	}

	public boolean deassocierPersonneFamille(Vector personnesId,int familleId) {
		Connection conn=null;
		PreparedStatement ps=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("delete from liaison_famille where famille_id=? and personne_id=?");
			ps=conn.prepareStatement(requete.toString());

			for(int cpt=0;cpt<personnesId.size();cpt++) {
				int personneId=((Integer)personnesId.elementAt(cpt)).intValue();
				ps.setInt(1,familleId);
				ps.setInt(2,personneId);
				int nb=ps.executeUpdate();
			}
			conn.commit();
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
			return false;
		} finally {
			try {
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return true;
	}

	public boolean isAssocierPersonneFamille(int familleId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select * from liaison_famille where famille_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,familleId);
			rs=ps.executeQuery();
			if( rs.next() )
				return true;
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			return false;
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return false;
	}

	public boolean viderPersonnesFamille(int familleId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("delete from liaison_famille where famille_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,familleId);
			ps.executeUpdate();
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
			return false;
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return true;
	}

	public Vector getListePersonnesFamille(int familleId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector noms=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select personne_id,personne_nom,personne_prenom1,personne_prenom2,personne_prenom3");
			requete.append(" from personne,liaison_famille");
			requete.append(" where liaison_famille.personne_id=personne.personne_id");
			requete.append(" and liaison_famille.famille_id=?");
			requete.append(" order by personne_nom,personne_prenom1");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,familleId);
			rs=ps.executeQuery();
			while( rs.next() ) {
				StringBuffer prenom=new StringBuffer();
				prenom.append(rs.getString("personne_prenom1"));
				if( rs.getString("personne_prenom2")!=null && !rs.getString("personne_prenom2").equals("") )
					prenom.append(" "+rs.getString("personne_prenom2"));
				if( rs.getString("personne_prenom3")!=null && !rs.getString("personne_prenom3").equals("") )
					prenom.append(" "+rs.getString("personne_prenom3"));
				PersonneUtils p=new PersonneUtils(rs.getInt("personne_id"),rs.getString("personne_nom"),prenom.toString());
				noms.addElement(p);
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return noms;
	}

	public Vector getListePersonnesFamille(String familleNom) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector noms=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select personne_id,personne_nom,personne_prenom1,personne_prenom2,personne_prenom3");
			requete.append(" from personne,liaison_famille,famille");
			requete.append(" where liaison_famille.personne_id=personne.personne_id");
			requete.append(" and liaison_famille.famille_id=famille.famille_id");
			requete.append(" and famille.famille_nom=?");
			requete.append(" order by personne_nom,personne_prenom1");
			ps=conn.prepareStatement(requete.toString());
			ps.setString(1,familleNom);
			rs=ps.executeQuery();
			while( rs.next() ) {
				StringBuffer prenom=new StringBuffer();
				prenom.append(rs.getString("personne_prenom1"));
				if( rs.getString("personne_prenom2")!=null && !rs.getString("personne_prenom2").equals("") )
					prenom.append(" "+rs.getString("personne_prenom2"));
				if( rs.getString("personne_prenom3")!=null && !rs.getString("personne_prenom3").equals("") )
					prenom.append(" "+rs.getString("personne_prenom3"));
				PersonneUtils p=new PersonneUtils(rs.getInt("personne_id"),rs.getString("personne_nom"),prenom.toString());
				noms.addElement(p);
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return noms;
	}

	public Vector getFamillesPersonne(int personneId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector idsFamilles=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select famille_id");
			requete.append(" from liaison_famille");
			requete.append(" where personne_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,personneId);
			rs=ps.executeQuery();
			while( rs.next() ) {
				idsFamilles.addElement(new Integer(rs.getInt("famille_id")));
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return idsFamilles;
	}

	public Vector getFamillesActe(int acteId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector idsFamilles=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select famille_id");
			requete.append(" from liaison_famille,liaison_acte");
			requete.append(" where liaison_acte.personne_id=liaison_famille.personne_id");
			requete.append(" and acte_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,acteId);
			rs=ps.executeQuery();
			while( rs.next() ) {
				idsFamilles.addElement(new Integer(rs.getInt("famille_id")));
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return idsFamilles;
	}

	public Vector getFamillesDocument(int documentId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector idsFamilles=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select famille_id");
			requete.append(" from liaison_famille,liaison_document");
			requete.append(" where liaison_famille.personne_id=liaison_document.personne_id");
			requete.append(" and document_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,documentId);
			rs=ps.executeQuery();
			while( rs.next() ) {
				idsFamilles.addElement(new Integer(rs.getInt("famille_id")));
			}
		} catch(SQLException ex) {
			Log.log(ex);
			ex.printStackTrace();
		} finally {
			try {
				if( rs!=null )
					rs.close();
				if( ps!=null )
					ps.close();
			} catch(SQLException ex) {
			}
		}
		return idsFamilles;
	}
}