package org.genealogie.utils;

import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;

public class ActeUtils implements Serializable {

	private int id;

	private String nom;

	private String url;

	private Date date;

	private int lieuId;

	private String lieu;

	private int typeId;

	private String type;

	private String source;

	private String auteur;

	private String commentaires;

	private String margeCommentaires;


	public ActeUtils(int id,String nom,String url,Date date,int lieuId,String lieu,int typeId,String type,String source,String auteur,String commentaires,String margeCommentaires) {
		this.id=id;
		this.nom=nom;
		this.url=url;
		this.date=date;
		this.lieuId=lieuId;
		this.lieu=lieu;
		this.typeId=typeId;
		this.type=type;
		this.source=source;
		this.auteur=auteur;
		this.commentaires=commentaires;
		this.margeCommentaires=margeCommentaires;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getNom() {
		return nom;
	}

	public String getUrl() {
		return url;
	}

	public Date getDate() {
		return date;
	}


	public String getDateString() {
		SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
		if( date!=null )
			return sdf.format( date );
		return "";
	}

	public int getLieuId() {
		return lieuId;
	}

	public String getLieu() {
		return lieu;
	}

	public int getTypeId() {
		return typeId;
	}

	public String getSource() {
		if (source != null)
			return source;
		else
			return "";
	}

	public String getAuteur() {
		if (auteur != null)
			return auteur;
		else
			return "";
	}

	public String getType() {
		return type;
	}

	public String getCommentaires() {
		return commentaires;
	}

	public String getMargeCommentaires() {
		return margeCommentaires;
	}

	public void setNom(String nom) {
		this.nom = nom;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public void setLieuId(int lieuId) {
		this.lieuId = lieuId;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public void setAuteur(String auteur) {
		this.auteur = auteur;
	}

	public void setTypeId(int typeId) {
		this.typeId = typeId;
	}

	public void setCommentaires(String commentaires) {
		this.commentaires = commentaires;
	}

	public void setMargeCommentaires(String margeCommentaires) {
		this.margeCommentaires = margeCommentaires;
	}

}