package org.genealogie.web;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.ejbs.sessions.genealogie.DocumentsBean;
import org.genealogie.log.Log;
import org.genealogie.utils.TypesDocumentUtils;

public final class ListeTypeDocumentAction extends CheckAction {
	private int NB_PAR_PAGES=20;

	private Vector filtrerTypesDocuments(Vector typesDocuments,Vector typesDocumentsAutorises) {
		Vector newTypesDocuments=new Vector();

		for(int cpt=0;cpt<typesDocuments.size();cpt++) {
			TypesDocumentUtils tdu=(TypesDocumentUtils)typesDocuments.elementAt(cpt);
			if( contient(tdu.getId(),typesDocumentsAutorises) )
				newTypesDocuments.addElement(tdu);
		}
		return newTypesDocuments;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Page
			int page=0;
			if( ((ListeTypeDocumentForm)form).getPage()!=null ) {
				try {
					page=Integer.parseInt(((ListeTypeDocumentForm)form).getPage())-1;
					if( page<0 )
						page=0;
				} catch(Exception ex) {}
			}


			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
			DocumentsBean documents=new DocumentsBean(conn);
			Vector typesDocuments=documents.getTypesDocuments();

			//Vrifier les droits d'accs
			if( !isAccesTotal(request) ) {
				typesDocuments=filtrerTypesDocuments(typesDocuments,getAuth(request).getTypesDocuments());
			}

			Vector resultats=new Vector();
			for(int cpt=page*NB_PAR_PAGES;cpt<typesDocuments.size() && cpt<(page*NB_PAR_PAGES+NB_PAR_PAGES);cpt++) {
				resultats.addElement(typesDocuments.elementAt(cpt));
			}

			int debut=0;
			int fin=typesDocuments.size()/NB_PAR_PAGES;
			if( page-10>=0 )
				debut=page-10;
			if( page+10<=fin )
				fin=page+10;
			if( debut==0 )
				if( (typesDocuments.size()/NB_PAR_PAGES)>=20 )
					fin=20;
			if( fin==((typesDocuments.size()/NB_PAR_PAGES)) )
				if( (typesDocuments.size()/NB_PAR_PAGES)-20>=0 )
					debut=(typesDocuments.size()/NB_PAR_PAGES)-20;

			//Envoi des infos  la jsp
			request.setAttribute("result",resultats);
			request.setAttribute("page_debut",new Integer(debut+1));
			if( typesDocuments.size()%NB_PAR_PAGES==0 )
				request.setAttribute("page_fin",new Integer(fin));
			else
				request.setAttribute("page_fin",new Integer(fin+1));
			request.setAttribute("page",new Integer(page+1));
			request.setAttribute("nombre",new Integer(typesDocuments.size()));

			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}