package org.genealogie.web;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.consanguinite.ConsanguiniteCalculator;
import org.genealogie.ejbs.sessions.genealogie.FamillesBean;
import org.genealogie.ejbs.sessions.genealogie.GenealogieBean;
import org.genealogie.log.Log;
import org.genealogie.utils.PersonneUtils;

public final class RechercherPersonnesConsanguiniteAction extends CheckAction {

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id1
			int id1=0;
			if( request.getParameterValues("id1")!=null ) {
				try {
					id1=Integer.parseInt(request.getParameterValues("id1")[0]);
				} catch(Exception ex) {}
			}

			if( id1==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id de la premire personne");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			//Id2
			int id2=0;
			if( request.getParameterValues("id2")!=null ) {
				try {
					id2=Integer.parseInt(request.getParameterValues("id2")[0]);
				} catch(Exception ex) {}
			}

			if( id2==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id de la deuxime personne");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();

			GenealogieBean genealogie=new GenealogieBean(conn);
			FamillesBean familles=new FamillesBean(conn);

			if( !isAccesTotal(request) ) {
				Vector famillesIds1=familles.getFamillesPersonne(id1);
				boolean contient1=false;
				for(int cpt=0;cpt<famillesIds1.size();cpt++) {
					int familleId=((Integer)famillesIds1.elementAt(cpt)).intValue();
					if( contient(familleId,getAuth(request).getFamilles()) ) {
						contient1=true;
						break;
					}
				}
				Vector famillesIds2=familles.getFamillesPersonne(id2);
				boolean contient2=false;
				for(int cpt=0;cpt<famillesIds2.size();cpt++) {
					int familleId=((Integer)famillesIds2.elementAt(cpt)).intValue();
					if( contient(familleId,getAuth(request).getFamilles()) ) {
						contient2=true;
						break;
					}
				}
				if( !contient1 || !contient2 ) {
					setNoCache(response);
					return (mapping.findForward("accueil"));
				}
			}

			PersonneUtils personne1=genealogie.getPersonne(id1);
			PersonneUtils personne2=genealogie.getPersonne(id2);

			if( personne1!=null && personne2!=null ) {
				ConsanguiniteCalculator cc=new ConsanguiniteCalculator(request,genealogie,id1,id2);
				cc.calculer();
				request.setAttribute("personne1",personne1);
				request.setAttribute("personne2",personne2);
			} else if( personne1==null ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer la personne correspondant  l'id "+id1);
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			} else if( personne2==null ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer la personne correspondant  l'id "+id2);
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}