package org.genealogie.web;

import java.io.IOException;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.metier.dao.DocumentsDAO;
import org.genealogie.metier.dao.GenealogieDAO;

public final class AccueilAction extends CheckAction {
	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		// Report any errors we have discovered back to the original form
		ActionMessages errors = new ActionMessages();
		if (!errors.isEmpty()) {
			saveErrors(request, errors);
			return (new ActionForward(mapping.getInput()));
		}
		// Save our logged-in user in the session
		HttpSession session = request.getSession();

		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}
			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
			//do what you wish with myConnection
			GenealogieDAO genealogie=new GenealogieDAO(conn);
			DocumentsDAO documents=new DocumentsDAO(conn);
			if( isAccesTotal(request) ) {
				int nb=genealogie.getNombrePersonnes();
				int nb_actes=genealogie.getNombreActes();
				int nb_documents=documents.getNombreDocuments();
				request.setAttribute("nb",new Integer(nb));
				request.setAttribute("nb-actes",new Integer(nb_actes));
				request.setAttribute("nb-documents",new Integer(nb_documents));
			} else {
				int nb=genealogie.getNombrePersonnesFamille(getAuth(request).getFamilles());
				int nb_actes=genealogie.getNombreActes(getAuth(request).getFamilles(),getAuth(request).getBorneSup());
				int nb_documents=documents.getNombreDocuments(getAuth(request).getFamilles(),
						getAuth(request).getTypesDocuments());
				request.setAttribute("nb",new Integer(nb));
				request.setAttribute("nb-actes",new Integer(nb_actes));
				request.setAttribute("nb-documents",new Integer(nb_documents));
			}
			request.setAttribute("auth",getAuth(request));
		} catch (SQLException sqle) {
			getServlet().log("Connection.process", sqle);
		} finally {
			//enclose this in a finally block to make //sure the connection is closed
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
		}
		
		// Remove the obsolete form bean
		if (mapping.getAttribute() != null) {
			if ("request".equals(mapping.getScope()))
				request.removeAttribute(mapping.getAttribute());
			else
				session.removeAttribute(mapping.getAttribute());
		}

		setNoCache(response);
		return (mapping.findForward("success"));
	}
}