package org.genealogie.web;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.regexp.RE;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.TablesRegistresDAO;
import org.genealogie.utils.URLEncodingScheme;

public final class RechercherTablesAction extends CheckAction {
	public java.sql.Date getDate(String chaineDate) {
		java.sql.Date cDate=null;

		if( chaineDate==null || chaineDate.equals("") )
			return null;

		try {
			RE annee = new RE("^(\\d{4})$");
			RE moisAnnee = new RE("^(\\d{2}\\d{4})$");
			RE jourMoisAnnee = new RE("^(\\d{2}\\d{2}\\d{4})$");

			if( annee.match(chaineDate) )
				chaineDate="01/01/"+chaineDate;
			if( moisAnnee.match(chaineDate) )
				chaineDate="01/"+chaineDate;

			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			java.util.Date d=sdf.parse(chaineDate,pos);
			cDate=new java.sql.Date(d.getTime());

		} catch(Exception ex) {
		}
		return cDate;
	}

	public int getOrdre(int ordre) {
		if( ordre!=TablesRegistresDAO.DATE_ASC && 
				ordre!=TablesRegistresDAO.DATE_DESC &&
				ordre!=TablesRegistresDAO.NOM_ASC &&
				ordre!=TablesRegistresDAO.NOM_DESC )
			return TablesRegistresDAO.DATE_ASC;
		return ordre;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			if( ((RechercherTablesForm)form).isNull() ) {
				setNoCache(response);
				return (mapping.findForward("failure"));
			}

			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			StringBuffer chaineRecherche=new StringBuffer();
			String separateur="";
			//Chaine de recherche
			if( ((RechercherTablesForm)form).getRechercher()!=null ) {
				chaineRecherche.append(separateur+"rechercher=");
				chaineRecherche.append(URLEncoder.encode(((RechercherTablesForm)form).getRechercher(),URLEncodingScheme.SCHEME));
				separateur="&";
			}			
			if( ((RechercherTablesForm)form).getVille()!=null ) {
				chaineRecherche.append(separateur+"ville=");
				chaineRecherche.append(URLEncoder.encode(((RechercherTablesForm)form).getVille(),URLEncodingScheme.SCHEME));
				separateur="&";
			}			
			if( ((RechercherTablesForm)form).getDateDebut()!=null ) {
				chaineRecherche.append(separateur+"dateDebut=");
				chaineRecherche.append(URLEncoder.encode(((RechercherTablesForm)form).getDateDebut(),URLEncodingScheme.SCHEME));
				separateur="&";
			}			
			if( ((RechercherTablesForm)form).getDateFin()!=null ) {
				chaineRecherche.append(separateur+"dateFin=");
				chaineRecherche.append(URLEncoder.encode(((RechercherTablesForm)form).getDateFin(),URLEncodingScheme.SCHEME));
				separateur="&";
			}			
			chaineRecherche.append(separateur+"ordre=");
			chaineRecherche.append(URLEncoder.encode(""+((RechercherTablesForm)form).getOrdre(),URLEncodingScheme.SCHEME));

			String lieu="";
			String dateDebut="";
			String dateFin="";
			if( ((RechercherTablesForm) form).getVille()!=null )
				lieu=((RechercherTablesForm) form).getVille();
			if( ((RechercherTablesForm) form).getDateDebut()!=null )
				dateDebut=((RechercherTablesForm) form).getDateDebut();
			if( ((RechercherTablesForm) form).getDateFin()!=null )
				dateFin=((RechercherTablesForm) form).getDateFin();

			StringBuffer rech=new StringBuffer();
			String espace="";
			//Rechercher
			if( ((RechercherTablesForm) form).getRechercher()!=null
					&& !(((RechercherTablesForm) form).getRechercher()).equals("") ) {
				rech.append(((RechercherTablesForm) form).getRechercher());
				espace=" ";
			}
			//Dates
			if( !dateDebut.equals("") || !dateFin.equals("") ) {
				if( !dateDebut.equals("") && !dateFin.equals("") ) {
					rech.append(espace+"entre "+dateDebut+" et "+dateFin);
					espace=" ";
				}
				if( !dateDebut.equals("") && dateFin.equals("") ) {
					rech.append(espace+"aprs "+dateDebut);
					espace=" ";
				}
				if( dateDebut.equals("") && !dateFin.equals("") ) {
					rech.append(espace+"avant "+dateFin);
					espace=" ";
				}
			}

			//Lieu
			if( !lieu.equals("") )
				rech.append(espace+" "+lieu);

			//Page
			int page=0;
			if( ((RechercherTablesForm)form).getPage()!=null ) {
				try {
					page=Integer.parseInt(((RechercherTablesForm)form).getPage())-1;
					if( page<0 )
						page=0;
				} catch(Exception ex) {}
			}

			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			int borneSup=getAuth(request).getBorneSup();
			java.util.Date tmp=sdf.parse("01/01/"+borneSup, pos);
			java.sql.Date dateBorneSup=new java.sql.Date(tmp.getTime());

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
			TablesRegistresDAO registres=new TablesRegistresDAO(conn);
			Vector tables=null;
			if( isAccesTotal(request) )
				tables=registres.getResultatsRechercheTables(((RechercherTablesForm) form).getRechercher(),
					getDate(dateDebut),getDate(dateFin),
					lieu,getOrdre(((RechercherTablesForm) form).getOrdre()) );
			else {
				java.sql.Date ddebut=getDate(dateDebut);
				java.sql.Date dfin=getDate(dateFin);
				if( borneSup>0 ) {
					if( dfin!=null ) {
						if( dfin.compareTo(dateBorneSup)>0 )
							dfin=dateBorneSup;
					} else
						dfin=dateBorneSup;
				}
				tables=registres.getResultatsRechercheTables(((RechercherTablesForm) form).getRechercher(),
					ddebut,dfin,lieu,getOrdre(((RechercherTablesForm) form).getOrdre()),
					getAuth(request));
			}
			Vector resultats=new Vector();
			for(int cpt=page*NB_PAR_PAGES;cpt<tables.size() && cpt<(page*NB_PAR_PAGES+NB_PAR_PAGES);cpt++) {
				resultats.addElement(tables.elementAt(cpt));
			}

			int debut=0;
			int fin=tables.size()/NB_PAR_PAGES;
			if( page-10>=0 )
				debut=page-10;
			if( page+10<=fin )
				fin=page+10;
			if( debut==0 )
				if( (tables.size()/NB_PAR_PAGES)>=20 )
					fin=20;
			if( fin==((tables.size()/NB_PAR_PAGES)) )
				if( (tables.size()/NB_PAR_PAGES)-20>=0 )
					debut=(tables.size()/NB_PAR_PAGES)-20;

			//Envoi des infos  la jsp
			request.setAttribute("result",resultats);
			request.setAttribute("page_debut",new Integer(debut+1));
			if( tables.size()%NB_PAR_PAGES==0 )
				request.setAttribute("page_fin",new Integer(fin));
			else
				request.setAttribute("page_fin",new Integer(fin+1));
			request.setAttribute("page",new Integer(page+1));
			request.setAttribute("nombre",new Integer(tables.size()));
			request.setAttribute("recherche",rech.toString());
			request.setAttribute("urlRecherche",chaineRecherche.toString());
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}