package org.genealogie.metier.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.genealogie.utils.JdbcConnectionSelector;

public abstract class AbstractDAO {
	private Throwable exception = null;
	
	protected Connection getConnection() throws SQLException {
		return JdbcConnectionSelector.getInstance().getConnection();
	}
	
	protected void closeConnection(Connection pConn,ResultSet[] pRs,PreparedStatement[] pPs) {
		for(int i=0;i<pRs.length;i++) {
			try {
				pRs[i].close();
			}
			catch (SQLException e){
			}
		}
		for(int i=0;i<pPs.length;i++) {
			try {
				pPs[i].close();
			}
			catch (SQLException e){
			}
		}
		try {
			if (pConn!=null) {
				pConn.close();
			}
		}
		catch (SQLException e){
		}
		forwardException();
	}
	
	protected void setException(Throwable pException) {
		exception = pException;
	}
	
	protected void forwardException() {
		if(exception!=null) {
			throw new RuntimeException(exception);
		}
	}
}
