package org.genealogie.metier.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.regexp.RE;
import org.genealogie.metier.modele.Acte;
import org.genealogie.metier.modele.Auth;
import org.genealogie.metier.modele.Document;
import org.genealogie.metier.modele.TypesDocument;

public class DocumentsDAO extends AbstractDAO {

	public DocumentsDAO() {
	}

	public int getNombreDocuments() {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select count(d.document_id) as nb");
			requete.append(" from document d");
			ps=conn.prepareStatement(requete.toString());
			rs=ps.executeQuery();
			if( rs.next() ) {
				return rs.getInt("nb");
			}
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return 0;
	}

	public int getNombreDocuments(Vector familles,Vector typesDocuments) {
		if( familles==null || familles.size()==0 ) {
			return 0;
		}

		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select d.document_id as nb");
			requete.append(" from document d,liaison_document l,liaison_famille lf");
			requete.append(" where d.document_id=l.document_id");
			requete.append(" and l.personne_id=lf.personne_id");
			if( familles.size()>0 ) {
				requete.append(" and lf.famille_id in (");
				for(int cpt=0;cpt<familles.size();cpt++) {
					if( cpt!=0 )
						requete.append(",?");
					else
						requete.append("?");
				}
				requete.append(" )");
			}

			requete.append(" union select d.document_id as nb");
			requete.append(" from document d,liaison_document l,liaison_famille lf");

			if( typesDocuments.size()>0 ) {
				requete.append(" where d.document_type_id ");
				requete.append("in (");
				for(int cpt=0;cpt<typesDocuments.size();cpt++) {
					if( cpt!=0 )
						requete.append(",?");
					else
						requete.append("?");
				}
				requete.append(" )");
			}
			ps=conn.prepareStatement(requete.toString());
			int indice=1;
			for(int cpt=0;cpt<familles.size();cpt++) {
				Integer id=(Integer)familles.elementAt(cpt);
				ps.setInt(indice,id.intValue());
				indice++;
			}
			for(int cpt=0;cpt<typesDocuments.size();cpt++) {
				Integer id=(Integer)typesDocuments.elementAt(cpt);
				ps.setInt(indice,id.intValue());
				indice++;
			}
			rs=ps.executeQuery();
			int nb=0;
			while( rs.next() ) {
				nb++;
			}
			return nb;
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return 0;
	}

	public Vector getListeDocuments() {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector documents=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select p.document_id,p.document_libelle,p.document_type_id,p.document_url_image,");
			requete.append(" p.document_source,p.document_date,p.document_transcription,");
			requete.append(" p.document_commentaires,p.document_marge_commentaires,td.type_document_nom");
			requete.append(" from document p,type_document td");
			requete.append(" where p.document_type_id=td.type_document_id");
			requete.append(" order by document_libelle asc");
			ps=conn.prepareStatement(requete.toString());
			rs=ps.executeQuery();
			while( rs.next() ) {
				Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
					rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
					rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
					rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
				documents.addElement(p);
			}
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return documents;
	}

	public Vector getListeDocumentsId(int idDocument) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector documents=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select p.document_id,p.document_libelle,p.document_type_id,p.document_url_image,");
			requete.append(" p.document_source,p.document_date,p.document_transcription,");
			requete.append(" p.document_commentaires,p.document_marge_commentaires,td.type_document_nom");
			requete.append(" from document p,type_document td");
			requete.append(" where p.document_type_id=td.type_document_id");
			requete.append(" and p.document_id=?");
			requete.append(" order by document_libelle asc");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,idDocument);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
					rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
					rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
					rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
				documents.addElement(p);
			}
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return documents;
	}

	public Vector getListeDocumentsType(int typeDocumentId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector documents=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select p.document_id,p.document_libelle,p.document_type_id,p.document_url_image,");
			requete.append(" p.document_source,p.document_date,p.document_transcription,");
			requete.append(" p.document_commentaires,p.document_marge_commentaires,td.type_document_nom");
			requete.append(" from document p,type_document td");
			requete.append(" where p.document_type_id=td.type_document_id");
			requete.append(" and p.document_type_id=?");
			requete.append(" order by p.document_libelle asc");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,typeDocumentId);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
					rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
					rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
					rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
				documents.addElement(p);
			}
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return documents;
	}


	public Vector getListeDocumentsFiche(int mariId,int femmeId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector documents=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
//			requete.append("select distinct(p.document_id),p.document_libelle,p.document_url_image,p.document_commentaires,lp.personne_id");
			requete.append("select distinct p.document_id,p.document_libelle,p.document_type_id,p.document_date,");
			requete.append(" p.document_source,p.document_url_image,p.document_transcription,");
			requete.append(" p.document_commentaires,p.document_marge_commentaires,");
			requete.append(" lp.personne_id,td.type_document_nom");
			requete.append(" from document p,liaison_document lp,type_document td");
			requete.append(" where p.document_type_id=td.type_document_id");
			requete.append(" and p.document_id=lp.document_id");
			if( mariId!=0 && femmeId!=0 )
				requete.append(" and ( lp.personne_id=? or lp.personne_id=?)");
			else if( mariId!=0 && femmeId==0 )
				requete.append(" and lp.personne_id=?");
			else if( mariId==0 && femmeId!=0 )
				requete.append(" and lp.personne_id=?");
			else
				return documents;
			requete.append(" order by personne_id,document_libelle asc");
			ps=conn.prepareStatement(requete.toString());
			if( mariId!=0 && femmeId!=0 ) {
				ps.setInt(1,mariId);
				ps.setInt(2,femmeId);
			} else if( mariId!=0 && femmeId==0 )
				ps.setInt(1,mariId);
			else if( mariId==0 && femmeId!=0 )
				ps.setInt(1,femmeId);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
					rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
					rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
					rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
				documents.addElement(p);
			}
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return documents;
	}

	public Vector getListeDocuments(int personneId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector documents=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select p.document_id,p.document_libelle,p.document_type_id,p.document_url_image,");
			requete.append(" p.document_source,p.document_date,p.document_transcription,");
			requete.append(" p.document_commentaires,p.document_marge_commentaires,td.type_document_nom");
			requete.append(" from document p,liaison_document lp,type_document td");
			requete.append(" where p.document_type_id=td.type_document_id");
			requete.append(" and p.document_id=lp.document_id");
			requete.append(" and lp.personne_id=?");
			requete.append(" order by document_libelle asc");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,personneId);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
					rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
					rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
					rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
				documents.addElement(p);
			}
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return documents;
	}

	public Document getDocument(int documentId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select d.document_id,d.document_libelle,d.document_type_id,d.document_url_image,");
			requete.append(" d.document_source,d.document_date,d.document_transcription,");
			requete.append(" d.document_commentaires,d.document_marge_commentaires,td.type_document_nom");
			requete.append(" from document d,type_document td");
			requete.append(" where d.document_type_id=td.type_document_id");
			requete.append(" and d.document_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,documentId);
			rs=ps.executeQuery();
			if( rs.next() ) {
				Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
					rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
					rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
					rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
				return p;
			}
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return null;
	}

	public Vector getTypesDocuments() {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector typesDocument=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select type_document_id,type_document_nom");
			requete.append(" from type_document");
			requete.append(" order by type_document_id asc");
			ps=conn.prepareStatement(requete.toString());
			rs=ps.executeQuery();
			while( rs.next() ) {
				TypesDocument td=new TypesDocument(rs.getInt("type_document_id"),rs.getString("type_document_nom"));
				typesDocument.addElement(td);
			}
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return typesDocument;
	}

	public TypesDocument getTypeDocument(int typeId) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select type_document_id,type_document_nom");
			requete.append(" from type_document");
			requete.append(" where type_document_id=?");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,typeId);
			rs=ps.executeQuery();
			while( rs.next() ) {
				return new TypesDocument(rs.getInt("type_document_id"),rs.getString("type_document_nom"));
			}
		} catch(SQLException ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return null;
	}


	public Vector getListeActesAssociesActe(int idActe) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector actes=new Vector();
		Hashtable ids=new Hashtable();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select distinct a.acte_id,a.acte_libelle,a.acte_url_image,a.acte_source,a.acte_auteur,a.acte_texte,a.acte_marge_texte,a.acte_type_id,a.acte_date,a.acte_lieu_id,");
			requete.append("c.commune_nom,ta.type_acte_nom");
			requete.append(" from acte a,commune c,type_acte ta,liaison_actes l");
			requete.append(" where a.acte_type_id=ta.type_acte_id");
			requete.append(" and a.acte_lieu_id=c.commune_id");
			requete.append(" and a.acte_id=l.acte1_id");
			requete.append(" and acte2_id=?");
			requete.append(" order by a.acte_date,a.acte_libelle");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,idActe);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Acte a=new Acte(rs.getInt("acte_id"),rs.getString("acte_libelle"),
					rs.getString("acte_url_image"),rs.getDate("acte_date"),rs.getInt("acte_lieu_id"),rs.getString("commune_nom"),
					rs.getInt("acte_type_id"),rs.getString("type_acte_nom"),rs.getString("acte_source"),
					rs.getString("acte_auteur"),rs.getString("acte_texte"),rs.getString("acte_marge_texte"));
				ids.put(new Integer(a.getId()),"");
				actes.addElement(a);
			}

			requete=new StringBuffer();
			requete.append("select distinct a.acte_id,a.acte_libelle,a.acte_url_image,a.acte_source,a.acte_auteur,a.acte_texte,a.acte_marge_texte,a.acte_type_id,a.acte_date,a.acte_lieu_id,");
			requete.append("c.commune_nom,ta.type_acte_nom");
			requete.append(" from acte a,commune c,type_acte ta,liaison_actes l");
			requete.append(" where a.acte_type_id=ta.type_acte_id");
			requete.append(" and a.acte_lieu_id=c.commune_id");
			requete.append(" and a.acte_id=l.acte2_id");
			requete.append(" and acte1_id=?");
			requete.append(" order by a.acte_date,a.acte_libelle");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,idActe);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Acte a=new Acte(rs.getInt("acte_id"),rs.getString("acte_libelle"),
					rs.getString("acte_url_image"),rs.getDate("acte_date"),rs.getInt("acte_lieu_id"),rs.getString("commune_nom"),
					rs.getInt("acte_type_id"),rs.getString("type_acte_nom"),rs.getString("acte_source"),
					rs.getString("acte_auteur"),rs.getString("acte_texte"),rs.getString("acte_marge_texte"));
				if( ids.get(new Integer(a.getId()))==null )
					actes.addElement(a);
			}
		} catch(SQLException ex) {
			setException(ex);
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return actes;
	}

	public Vector getListeActesAssociesDocument(int idDocument) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector actes=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select distinct a.acte_id,a.acte_libelle,a.acte_url_image,a.acte_source,a.acte_auteur,a.acte_texte,a.acte_marge_texte,a.acte_type_id,a.acte_date,a.acte_lieu_id,");
			requete.append("c.commune_nom,ta.type_acte_nom");
			requete.append(" from acte a,commune c,type_acte ta,liaison_acte_document l");
			requete.append(" where a.acte_type_id=ta.type_acte_id");
			requete.append(" and a.acte_lieu_id=c.commune_id");
			requete.append(" and a.acte_id=l.acte_id");
			requete.append(" and l.document_id=?");
			requete.append(" order by a.acte_date,a.acte_libelle");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,idDocument);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Acte a=new Acte(rs.getInt("acte_id"),rs.getString("acte_libelle"),
					rs.getString("acte_url_image"),rs.getDate("acte_date"),rs.getInt("acte_lieu_id"),rs.getString("commune_nom"),
					rs.getInt("acte_type_id"),rs.getString("type_acte_nom"),rs.getString("acte_source"),
					rs.getString("acte_auteur"),rs.getString("acte_texte"),rs.getString("acte_marge_texte"));
				actes.addElement(a);
			}
		} catch(SQLException ex) {
			setException(ex);
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return actes;
	}

	public Vector getListeDocumentsAssociesDocument(int idDocument) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector documents=new Vector();
		Hashtable ids=new Hashtable();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select d.document_id,d.document_libelle,d.document_type_id,d.document_date,d.document_source,");
			requete.append("d.document_url_image,d.document_commentaires,d.document_marge_commentaires,d.document_transcription,");
			requete.append("td.type_document_nom");
			requete.append(" from document d,liaison_documents l,type_document td");
			requete.append(" where d.document_type_id=td.type_document_id");
			requete.append(" and d.document_id=l.document1_id");
			requete.append(" and document2_id=?");
			requete.append(" order by d.document_libelle");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,idDocument);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
					rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
					rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
					rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
				ids.put(new Integer(p.getId()),"");
				documents.addElement(p);
			}

			requete=new StringBuffer();
			requete.append("select d.document_id,d.document_libelle,d.document_type_id,d.document_date,d.document_source,");
			requete.append("d.document_url_image,d.document_commentaires,d.document_marge_commentaires,d.document_transcription,");
			requete.append("td.type_document_nom");
			requete.append(" from document d,liaison_documents l,type_document td");
			requete.append(" where d.document_type_id=td.type_document_id");
			requete.append(" and d.document_id=l.document2_id");
			requete.append(" and document1_id=?");
			requete.append(" order by d.document_libelle");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,idDocument);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
					rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
					rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
					rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
				if( ids.get(new Integer(p.getId()))==null )
					documents.addElement(p);
			}
		} catch(SQLException ex) {
			setException(ex);
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return documents;
	}

	public Vector getListeDocumentsAssociesActe(int idActe) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector documents=new Vector();

		try {
			conn=getConnection();

			StringBuffer requete=new StringBuffer();
			requete.append("select d.document_id,d.document_libelle,d.document_type_id,d.document_date,d.document_source,");
			requete.append("d.document_url_image,d.document_commentaires,d.document_marge_commentaires,d.document_transcription,");
			requete.append("td.type_document_nom");
			requete.append(" from document d,liaison_acte_document l,type_document td");
			requete.append(" where d.document_type_id=td.type_document_id");
			requete.append(" and d.document_id=l.document_id");
			requete.append(" and l.acte_id=?");
			requete.append(" order by d.document_libelle");
			ps=conn.prepareStatement(requete.toString());
			ps.setInt(1,idActe);
			rs=ps.executeQuery();
			while( rs.next() ) {
				Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
					rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
					rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
					rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
				documents.addElement(p);
			}
		} catch(SQLException ex) {
			setException(ex);
			try {
				conn.rollback();
			} catch(SQLException ex1) {}
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return documents;
	}

	private boolean contient(String chaine1,RE r) {
		chaine1=chaine1.toLowerCase();
		StringTokenizer st=new StringTokenizer(chaine1,"\n");
		while( st.hasMoreTokens() ) {
			String c=st.nextToken();
			if( r.match(c) )
				return true;
		}
		return false;
	}
	

	public Vector getResultatsRechercheDocuments(String rechercher,boolean marge,boolean corps) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector documents=new Vector();

		try {
			RE r = new RE(rechercher);
			conn=getConnection();
			StringBuffer requete=new StringBuffer();
			requete.append("select d.document_id,d.document_libelle,d.document_type_id,d.document_date,d.document_source,");
			requete.append("d.document_url_image,d.document_commentaires,d.document_marge_commentaires,d.document_transcription,");
			requete.append("td.type_document_nom");
			requete.append(" from document d,type_document td");
			requete.append(" where d.document_type_id=td.type_document_id");
			requete.append(" order by d.document_libelle");
			ps=conn.prepareStatement(requete.toString());
			rs=ps.executeQuery();
			while( rs.next() ) {
				if( rechercher.equals("") ) {
					Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
						rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
						rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
						rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
					documents.addElement(p);
				} else if( corps && contient(rs.getString("document_commentaires"),r)
						|| marge && contient(rs.getString("document_marge_commentaires"),r)
						|| contient(rs.getString("document_libelle"),r) ) {
					Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
						rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
						rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
						rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
					documents.addElement(p);
				}
			}
		} catch(Exception ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return documents;
	}


	public Vector getResultatsRechercheDocuments(String rechercher,boolean marge,boolean corps,Auth auth) {
		Connection conn=null;
		PreparedStatement ps=null;
		ResultSet rs=null;
		Vector documents=new Vector();

		try {
			RE r = new RE(rechercher);
			conn=getConnection();
			StringBuffer requete=new StringBuffer();
			requete.append("select d.document_id,d.document_libelle,d.document_type_id,d.document_date,d.document_source,");
			requete.append("d.document_url_image,d.document_commentaires,d.document_marge_commentaires,d.document_transcription,");
			requete.append("td.type_document_nom");
			requete.append(" from document d,type_document td,liaison_document ld,liaison_famille lf");
			requete.append(" where d.document_type_id=td.type_document_id");
			requete.append(" and d.document_id=ld.document_id");
			requete.append(" and ld.personne_id=lf.personne_id");

			Vector familles=auth.getFamilles();
			Vector typesDocumentsAutorises=auth.getTypesDocuments();

			if( familles.size()>0 ) {
				requete.append(" and lf.famille_id in (");
				for(int cpt=0;cpt<familles.size();cpt++) {
					if( cpt!=0 )
						requete.append(",?");
					else
						requete.append("?");
				}
				requete.append(")");
			}

			requete.append(" order by d.document_libelle");

			requete.append(" union select d.document_id,d.document_libelle,d.document_type_id,d.document_date,d.document_source,");
			requete.append("d.document_url_image,d.document_commentaires,d.document_marge_commentaires,d.document_transcription,");
			requete.append("td.type_document_nom");
			requete.append(" from document d,type_document td,liaison_document ld,liaison_famille lf");
			requete.append(" where d.document_type_id=td.type_document_id");

			if( typesDocumentsAutorises.size()>0 ) {
				requete.append(" and d.document_type_id in (");
				for(int cpt=0;cpt<typesDocumentsAutorises.size();cpt++) {
					if( cpt!=0 )
						requete.append(",?");
					else
						requete.append("?");
				}
				requete.append(")");
			}

			requete.append(" order by d.document_libelle");
			ps=conn.prepareStatement(requete.toString());

			int indice=1;
			if( familles.size()>0 ) {
				for(int cpt=0;cpt<familles.size();cpt++) {
					int id=((Integer)familles.elementAt(cpt)).intValue();
					ps.setInt(indice,id);
					indice++;
				}
			}

			if( typesDocumentsAutorises.size()>0 ) {
				for(int cpt=0;cpt<typesDocumentsAutorises.size();cpt++) {
					int id=((Integer)typesDocumentsAutorises.elementAt(cpt)).intValue();
					ps.setInt(indice,id);
					indice++;
				}
			}

			rs=ps.executeQuery();
			while( rs.next() ) {
				if( rechercher.equals("") ) {
					Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
						rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
						rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
						rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
					documents.addElement(p);
				} else if( corps && contient(rs.getString("document_commentaires"),r)
						|| marge && contient(rs.getString("document_marge_commentaires"),r)
						|| contient(rs.getString("document_libelle"),r) ) {
					Document p=new Document(rs.getInt("document_id"),rs.getString("document_libelle"),
						rs.getInt("document_type_id"),rs.getString("type_document_nom"),rs.getString("document_url_image"),
						rs.getString("document_date"),rs.getString("document_source"),rs.getInt("document_transcription")==1?true:false,
						rs.getString("document_commentaires"),rs.getString("document_marge_commentaires"));
					documents.addElement(p);
				}
			}
		} catch(Exception ex) {
			setException(ex);
		} finally {
			ResultSet[] trs = {rs};
			PreparedStatement[] tps = {ps};
			closeConnection(conn,trs,tps);
		}
		return documents;
	}
}