package org.genealogie.web;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.metier.modele.Auth;
import org.genealogie.metier.modele.CommuneDetail;

public final class FicheVilleAction extends CheckAction {

	private boolean isVilleAutorisee(CommuneDetail commune,Auth au) {
		Vector communes=au.getCommunes();
		Vector communesFamilles=au.getCommunesFamilles();
		Vector departements=au.getDepartements();
		Vector pays=au.getPays();

		for(int cpt=0;cpt<pays.size();cpt++) {
			int id=((Integer)pays.elementAt(cpt)).intValue();
			if( id==commune.getPaysId() )
				return true;
		}

		for(int cpt=0;cpt<departements.size();cpt++) {
			int id=((Integer)departements.elementAt(cpt)).intValue();
			if( id==commune.getDepartementId() )
				return true;
		}

		for(int cpt=0;cpt<communes.size();cpt++) {
			int id=((Integer)communes.elementAt(cpt)).intValue();
			if( id==commune.getId() )
				return true;
		}

		for(int cpt=0;cpt<communesFamilles.size();cpt++) {
			int id=((Integer)communesFamilles.elementAt(cpt)).intValue();
			if( id==commune.getId() )
				return true;
		}

		return false;
	}

	public java.sql.Date getDate(String chaineDate) {
		java.sql.Date cDate=null;

		if( chaineDate==null || chaineDate.equals("") )
			return null;

		try {
			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			java.util.Date d=sdf.parse(chaineDate,pos);
			cDate=new java.sql.Date(d.getTime());

		} catch(Exception ex) {
		}
		return cDate;
	}

	public ActionForward execute(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {

		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id
			int id=0;
			if( request.getParameterValues("id")!=null ) {
				try {
					id=Integer.parseInt(request.getParameterValues("id")[0]);
				} catch(Exception ex) {}
			}

			if( id==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			GenealogieDAO genealogie=new GenealogieDAO();
			CommuneDetail commune=genealogie.getDetailCommune(id);
			//Envoi des infos  la jsp
			request.setAttribute("commune",commune);
			if( !isAccesTotal(request) ) {
				if( isVilleAutorisee(commune,getAuth(request)) )
					request.setAttribute("active","1");
				else
					request.setAttribute("active","0");
			} else
				request.setAttribute("active","1");
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		}
	}
}