package org.genealogie.web;

import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.DocumentsDAO;
import org.genealogie.metier.dao.FamillesDAO;
import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.metier.modele.Acte;
import org.genealogie.metier.modele.Auth;
import org.genealogie.metier.modele.Document;
import org.genealogie.utils.RessourcesUtils;

import Acme.JPM.Encoders.GifEncoder;

public final class AffichageImageAction extends CheckAction {
	private final static String RACINE_IMAGES=RessourcesUtils.getInstance().getChaine("IMAGES");
	private final static String IMG_SMALL=RessourcesUtils.getInstance().getChaine("IMG-SMALL");

	private boolean isActeAutorise(Acte acte,FamillesDAO familles,HttpServletRequest request) {
		//Vrifier les droits d'accs
		if( !isAccesTotal(request) ) {
			Vector famillesIds=familles.getFamillesActe(acte.getId());
			boolean contient=false;
			for(int cpt=0;cpt<famillesIds.size();cpt++) {
				int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
				if( contient(familleId,getAuth(request).getFamilles()) ) {
					return true;
				}
			}
		} else {
			return true;
		}
		return false;
	}

	private boolean isDocumentAutorise(Document document,FamillesDAO familles,Auth auth,HttpServletRequest request) {
		//Vrifier les droits d'accs
		if( !isAccesTotal(request) ) {
			Vector famillesIds=familles.getFamillesDocument(document.getId());
			boolean contient=false;
			for(int cpt=0;cpt<famillesIds.size();cpt++) {
				int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
				if( contient(familleId,getAuth(request).getFamilles()) ) {
					return true;
				}
			}

			Vector typesDocumentsAutorises=getAuth(request).getTypesDocuments();
			for(int cpt=0;cpt<typesDocumentsAutorises.size();cpt++) {
				int idTypeDocument=((Integer)typesDocumentsAutorises.elementAt(cpt)).intValue();
				if( idTypeDocument==document.getTypeId() ) {
					return true;
				}
			}
		} else {
			return true;
		}
		return false;
	}

	private boolean contientFichier(String fichier,String listeFichiers) {
		fichier=fichier.trim();
		StringTokenizer st=new StringTokenizer(listeFichiers,",");
		while( st.hasMoreTokens() ) {
			String elt=st.nextToken();
			elt=elt.trim();
			if( elt.equals(fichier) )
				return true;
		}
		return false;
	}

	private String getNomSmall(String nomImage) {
		StringTokenizer st=new StringTokenizer(nomImage,".");
		int cpt=0;
		String nom="";
		String extension="";
		while( st.hasMoreTokens() ) {
			String tmp=st.nextToken();
			if( cpt==0 )
				nom=tmp;
			if( cpt==1 )
				extension=tmp;
			cpt++;
		}
		if( !nom.equals("") && !extension.equals("") )
			return nom+IMG_SMALL+"."+extension;
		else
			return nomImage;
	}

	private Image getImageRetaillee(String path,int width,int height) {
		Image src=Toolkit.getDefaultToolkit().getImage(path);
		int widthOrig=src.getWidth(null);
		int heightOrig=src.getHeight(null);
		float tmpWidth=(float)width;
		float tmpHeight=(float)height;
		float tmpWidthOrig=(float)widthOrig;
		float tmpHeightOrig=(float)heightOrig;
		float ratio=tmpWidthOrig/tmpHeightOrig;
		if( height==0 && width!=0 ) {
			tmpHeight=tmpWidth/ratio;
			height=(int)tmpHeight;
		} else if( height==0 && width!=0 ) {
			tmpWidth=tmpHeight*ratio;
			width=(int)tmpWidth;
		}

		//BufferedImage buffer=new BufferedImage(width,height,BufferedImage.TYPE_3BYTE_BGR);
		Frame frame = new Frame ();
		// addNotify () is required to create an image (this will call Toolkit.getDefaultToolkit ())
		frame.addNotify ();
		Image image = frame.createImage (width, height);
		Graphics2D g=(Graphics2D)image.getGraphics();
		g.drawImage(src,0,0,width,height,null);
		g.dispose();
		return image;
	}

	public ActionForward execute(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		
		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id
			int id=0;
			if( request.getParameterValues("id")!=null ) {
				try {
					id=Integer.parseInt(request.getParameterValues("id")[0]);
				} catch(Exception ex) {}
			}

			if( id==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			int width=0;
			int height=0;
			if( request.getParameterValues("width")!=null ) {
				try {
					width=Integer.parseInt(request.getParameterValues("width")[0]);
				} catch(Exception ex) {}
			}
			if( request.getParameterValues("height")!=null ) {
				try {
					height=Integer.parseInt(request.getParameterValues("height")[0]);
				} catch(Exception ex) {}
			}

			//Acte ou document
			boolean isActe=false;
			boolean isDocument=false;
			if( request.getParameterValues("acte")!=null )
				isActe=true;
			else if( request.getParameterValues("document")!=null )
				isDocument=true;

			if( !isActe && !isDocument ) {
				request.setAttribute("exception","Erreur: impossible de dterminer s'il s'agit d'un document ou d'un acte");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			//Acte ou document
			String fichier="";
			if( request.getParameterValues("fichier")!=null )
				fichier=(request.getParameterValues("fichier")[0]).trim();

			if( fichier.equals("") ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer le fichier  afficher");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			//Acte ou document
			boolean mini=false;
			if( request.getParameterValues("mini")!=null )
				mini=true;

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			GenealogieDAO genealogie=new GenealogieDAO();
			DocumentsDAO documents=new DocumentsDAO();
			FamillesDAO familles=new FamillesDAO();

			boolean autorise=false;
			if( isActe ) {
				Acte acte=genealogie.getActe(id);
				if( acte!=null ) {
					if( isActeAutorise(acte,familles,request) ) {
						autorise=contientFichier(fichier,acte.getUrl());
					}
				}
			} else if( isDocument ) {
				Document document=documents.getDocument(id);
				if( document!=null ) {
					if( isDocumentAutorise(document,familles,getAuth(request),request) ) {
						autorise=contientFichier(fichier,document.getUrl());
					}
				}
			}

			if( !autorise ) {
				request.setAttribute("exception","Erreur: vous n'tes pas autorises  afficher ce fichier");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			} else {
				if( mini )
					fichier=getNomSmall(fichier);

				if( !RACINE_IMAGES.endsWith(File.separator) )
					fichier=File.separator+fichier;
				fichier=RACINE_IMAGES+fichier;

				File f=new File(fichier);
				if( !f.exists() ) {
					request.setAttribute("exception","Erreur: le fichier spcifi n'existe pas -> "+fichier);
					request.setAttribute("stack","");
					setNoCache(response);
					return (mapping.findForward("exception"));
				}
				long taille=f.length();

				if( width!=0 || height!=0 ) {
					//response.setContentType("image/gif");
				} else if( fichier.endsWith(".gif") )
					response.setContentType("image/gif");
				else if( fichier.endsWith(".jpg") )
					response.setContentType("image/jpeg");
				else if( fichier.endsWith(".png") )
					response.setContentType("image/png");
					
				if( width==0 && height==0 ) {
					response.setContentLength((int)taille);
					ServletOutputStream out=null;
					FileInputStream fis=null;
					DataInputStream dis=null;
					try {
						out=response.getOutputStream();
						setNoCache(response);
						fis=new FileInputStream(f);
						dis=new DataInputStream(fis);

						byte buf[] = new byte[1000];
						int len=0;
						int off=0;
						while( (len=dis.read(buf,0,1000 ))!=-1 ) {
							out.write(buf,off,len);
							out.flush();
						}
					} catch(Exception ex) {
						Log.log(ex);
						ex.printStackTrace();
					} finally {
						if( out!=null )
							out.flush();
						if( dis!=null )
							dis.close();
						if( fis!=null )
							fis.close();
					}
				} else {
					OutputStream out = response.getOutputStream();
					setNoCache(response);
					Image image=getImageRetaillee(fichier,width,height);
					GifEncoder encoder = new GifEncoder(image, out);
					encoder.encode();
				}

				/*byte[] contenuFichier=new byte[(int)taille];
				fos.read(contenuFichier);

				out.write(contenuFichier);
				out.flush();*/

				return null;
			}
		} catch(Exception ex) {
			/*request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));*/
			ex.printStackTrace();
			return null;
		}
	}
}