package org.genealogie.web;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.genealogie.metier.dao.FamillesDAO;
import org.genealogie.metier.modele.Acte;
import org.genealogie.metier.modele.Auth;
import org.genealogie.metier.modele.Document;
import org.genealogie.utils.DatabaseUtils;

public abstract class CheckAction extends Action {
	protected void setNoCache(HttpServletResponse response) {
		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Pragma", "no-cache");
		response.setHeader("Expires", "0");
	}

	protected Vector filtrerActesBorneSup(Vector actes,int borneSup) {
		if( borneSup==0 )
			return actes;

		Vector newActes=new Vector();
		SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
		ParsePosition pos=new ParsePosition(0);
		java.util.Date tmp=sdf.parse("01/01/"+borneSup, pos);
		java.sql.Date dateBorneSup=new java.sql.Date(tmp.getTime());

		for(int cpt=0;cpt<actes.size();cpt++) {
			Acte acte=(Acte)actes.elementAt(cpt);
			if( acte.getDate()!=null ) {
				if( (acte.getDate()).compareTo(dateBorneSup)<=0 )
					newActes.addElement(acte);
			}
		}
		return newActes;
		
	}

	protected Vector filtrerActes(FamillesDAO famille,Vector actes,Vector familles) {
		for(int cpt=0;cpt<actes.size();cpt++) {
			Acte au=(Acte)actes.elementAt(cpt);
			Vector famillesIds=famille.getFamillesActe(au.getId());
			boolean contient=false;
			for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
				int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient )
				au.setId(0);
		}
		return actes;
	}

	protected Vector filtrerDocuments(FamillesDAO famille,Vector documents,Vector familles,Vector typesDocumentsAutorises) {
		for(int cpt=0;cpt<documents.size();cpt++) {
			Document du=(Document)documents.elementAt(cpt);
			Vector famillesIds=famille.getFamillesActe(du.getId());
			boolean contient=false;
			for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
				int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}

			if( !contient ) {
				for(int cpt1=0;cpt1<typesDocumentsAutorises.size();cpt1++) {
					int typeDocumentId=((Integer)typesDocumentsAutorises.elementAt(cpt1)).intValue();
					if( typeDocumentId==du.getTypeId() ) {
						contient=true;
						break;
					}
				}
			}

			if( !contient )
				du.setId(0);
		}
		return documents;
	}

	protected String getIdPool() {
		return DatabaseUtils.getIdPool();
	}

	protected void setIdPool(String idPool) {
		DatabaseUtils.setIdPool(idPool);
	}

	protected boolean contient(int id,Vector liste) {
		for(int cpt=0;cpt<liste.size();cpt++) {
			Integer i=(Integer)liste.elementAt(cpt);
			if( id==i.intValue() )
				return true;
		}
		return false;
	}

	protected Vector getTokens(String ligne) {
		Vector tokens=new Vector();

		ligne=ligne.trim();
		if( !ligne.equals("") ) {
			int indice=0;
			while( (indice=ligne.indexOf("\n"))!=-1 ) {
				String token=ligne.substring(0,indice);
				//if( !(token.trim()).equals("") )
					tokens.addElement(token);
				ligne=ligne.substring(indice+1);
			}
			tokens.addElement(ligne);
		}
		return tokens;
	}

	private boolean isAuthentifier(HttpServletRequest request) {
		HttpSession session=request.getSession();
		if( session!=null ) {
			Auth login=(Auth)session.getAttribute("auth");
			if( login!=null )
				return true;
			else
				return false;
		} else
			return false;
	}

	protected Auth getAuth(HttpServletRequest request) {
		HttpSession session=request.getSession();
		if( session!=null ) {
			return (Auth)session.getAttribute("auth");
		} else
			return null;
	}

	protected boolean isAccesTotal(HttpServletRequest request) {
		Auth au=getAuth(request);
		return au.isAccesTotal();
	}

	public ActionForward execute(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		return mapping.findForward("accueil");
	}
	
	protected static final int NB_PAR_PAGES = 20;
}