package org.genealogie.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.genealogie.metier.modele.Auth;

public aspect CheckAuth {
	   private pointcut checkpoint(
                     ActionMapping mapping,
                     ActionForm form,
                     HttpServletRequest request,
                     HttpServletResponse response) :
		   execution(ActionForward *.execute(ActionMapping,
          ActionForm,HttpServletRequest,HttpServletResponse)) &&
		   args(mapping,form,request,response) &&
		   !within(LoginAction) &&
		   !within(LogoutAction);
	
	   Object around(ActionMapping mapping,ActionForm form,
    HttpServletRequest request,HttpServletResponse response) : 
     checkpoint(mapping,form,request,response) {
		   if( isAuthentifier(request) ) {
			return proceed(mapping,form,request,response);
		   } else {
			setNoCache(response);
			return mapping.findForward("login");
		   }
	   }
	
	   private boolean isAuthentifier(HttpServletRequest request) {
		HttpSession session=request.getSession();
		if( session!=null ) {
			Auth login=(Auth)session.getAttribute("auth");
			if( login!=null )
				return true;
			else
				return false;
		} else
			return false;
	   }
	
	   private void setNoCache(HttpServletResponse response) {
		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Pragma", "no-cache");
		response.setHeader("Expires", "0");
	   }
}