package org.genealogie.web;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.DocumentsDAO;
import org.genealogie.metier.dao.FamillesDAO;
import org.genealogie.metier.modele.Document;

public final class FicheDocumentListeAction extends CheckAction {
	public ActionForward execute(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {

		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Type
			int type=0;
			if( request.getParameterValues("type")!=null ) {
				try {
					type=Integer.parseInt(request.getParameterValues("type")[0]);
				} catch(Exception ex) {}
			}

			if( type==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id du type de document");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			//No
			int no=0;
			if( request.getParameterValues("no")!=null ) {
				try {
					no=Integer.parseInt(request.getParameterValues("no")[0]);
				} catch(Exception ex) {}
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			DocumentsDAO documents=new DocumentsDAO();
			FamillesDAO familles=new FamillesDAO();
			Vector docs=documents.getListeDocumentsType(type);

			if( docs.size()==0 ) {
				request.setAttribute("exception","Ce type de documents ne contient aucun document!");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			Document document=null;
			if( no<docs.size() )
				document=(Document)docs.elementAt(no);
			else
				document=(Document)docs.elementAt(docs.size()-1);

			if( document==null ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'acte correspondant au type et  l'indice");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			//Vrifier les droits d'accs
			if( !isAccesTotal(request) ) {
				int id=document.getId();
				Vector famillesIds=familles.getFamillesDocument(id);
				boolean contient=false;
				for(int cpt=0;cpt<famillesIds.size();cpt++) {
					int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
					if( contient(familleId,getAuth(request).getFamilles()) ) {
						contient=true;
						break;
					}
				}
				if( !contient ) {
					Vector typesDocumentsAutorises=getAuth(request).getTypesDocuments();
					for(int cpt=0;cpt<typesDocumentsAutorises.size();cpt++) {
						int idTypeDocument=((Integer)typesDocumentsAutorises.elementAt(cpt)).intValue();
						if( idTypeDocument==document.getTypeId() ) {
							contient=true;
							break;
						}
					}
				}

				if( !contient ) {
					setNoCache(response);
					return (mapping.findForward("accueil"));
				}
			}

			//Envoi des infos  la jsp
			if( no>0 )
				request.setAttribute("precedent",String.valueOf(no-1));
			else
				request.setAttribute("precedent",String.valueOf(-1));
			if( no<(docs.size()-1) )
				request.setAttribute("suivant",String.valueOf(no+1));
			else
				request.setAttribute("suivant",String.valueOf(-1));
			request.setAttribute("type",String.valueOf(type));

			request.setAttribute("document",document);
			String marge=document.getMargeCommentaires();
			String corps=document.getCommentaires();
			Vector lignesMarge=getTokens(marge);
			Vector lignesCorps=getTokens(corps);
			/*Vector lignesMarge=new Vector();
			Vector lignesCorps=new Vector();
			StringTokenizer st=new StringTokenizer(marge,"\n",false);
			StringTokenizer st1=new StringTokenizer(corps,"\n",false);
			while( st.hasMoreTokens() ) {
				lignesMarge.addElement(st.nextToken());
			}
			while( st1.hasMoreTokens() ) {
				lignesCorps.addElement(st1.nextToken());
			}*/
			request.setAttribute("marge",lignesMarge);
			request.setAttribute("corps",lignesCorps);
			StringTokenizer st2=new StringTokenizer(document.getUrl(),",");
			Vector urls=new Vector();
			while( st2.hasMoreTokens() ) {
				String url=st2.nextToken();
				urls.addElement(url);
			}
			request.setAttribute("urls",urls);

			//Dependances
			Vector actesDependances=documents.getListeActesAssociesDocument(document.getId());
			Vector documentsDependances=documents.getListeDocumentsAssociesDocument(document.getId());
			request.setAttribute("actes-dependants",filtrerActes(familles,actesDependances,getAuth(request).getFamilles()));
			request.setAttribute("documents-dependants",filtrerDocuments(familles,documentsDependances,
							getAuth(request).getFamilles(),getAuth(request).getTypesDocuments()));
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		}
	}
}