package org.genealogie.metier.arbre;

import java.util.Vector;

import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.metier.modele.Chrono;
import org.genealogie.metier.modele.Personne;

public class ChargementArbre {
	private int idBase;
	private int numeroBase;
	private int generationBase;

	private GenealogieDAO genealogie;

	public ChargementArbre(int id,int no,int generation,GenealogieDAO genealogie) {
		this.idBase=id;
		this.numeroBase=no;
		this.generationBase=generation;
		this.genealogie=genealogie;
	}

	private boolean isNull(Vector generation) {
		for(int cpt=0;cpt<generation.size();cpt++) {
			Elt c=(Elt)generation.elementAt(cpt);
			if( c!=null )
				return false;
		}
		return true;
	}

	public GraphicArbre chargerGraphics() {
		return chargerGraphics(1000);
	}

	public GraphicArbre chargerGraphics(int nbGeneration) {
		GraphicArbre ga=new GraphicArbre();

		try {
			Personne base=genealogie.getPersonne(idBase);
			Chrono chronoBase=genealogie.getChronologieSimple(idBase);
			ga.setRacine(new EltCase(idBase,numeroBase,base.getNom(),base.getPrenom(),chronoBase.getNaissance()+" - "+chronoBase.getDeces()));

			Vector generation=new Vector();
			int gen=1;
			generation.addElement(new Elt(idBase,numeroBase,generationBase,base.getNom(),base.getPrenom(),chronoBase.getNaissance()+" - "+chronoBase.getDeces()));
			while( generation.size()>0 && !isNull(generation) && gen<=nbGeneration ) {
				//Charger la gnration
				Vector tmp=new Vector();
				Vector personnes=new Vector();
				for(int cpt=0;cpt<generation.size();cpt++) {
					Elt p=(Elt)generation.elementAt(cpt);
					if( p!=null ) {
						int id=p.getIdPersonne();
						int no=p.getNumeroPersonne();
						Personne current=genealogie.getPersonne(id);
						Chrono chronoCurrent=genealogie.getChronologieSimple(id);
						Personne pere=genealogie.getPere(id);
						Chrono chronoPere=null;
						if( pere!=null )
							chronoPere=genealogie.getChronologieSimple(pere.getId());
						Personne mere=genealogie.getMere(id);
						Chrono chronoMere=null;
						if( mere!=null )
							chronoMere=genealogie.getChronologieSimple(mere.getId());
						personnes.addElement(new EltCase(p.getIdPersonne(),p.getNumeroPersonne(),current.getNom(),current.getPrenom(),chronoCurrent.getNaissance()+" - "+chronoCurrent.getDeces()));
						if( mere!=null && pere!=null ) {
							tmp.addElement(new Elt(pere.getId(),2*no,gen,pere.getNom(),pere.getPrenom(),chronoPere.getNaissance()+" - "+chronoPere.getDeces()));
							tmp.addElement(new Elt(mere.getId(),2*no+1,gen,mere.getNom(),mere.getPrenom(),chronoMere.getNaissance()+" - "+chronoMere.getDeces()));
						} else if( pere!=null && mere==null ) {
							tmp.addElement(new Elt(pere.getId(),2*no,gen,pere.getNom(),pere.getPrenom(),chronoPere.getNaissance()+" - "+chronoPere.getDeces()));
							tmp.addElement(null);
						} else if( mere!=null && pere==null ) {
							tmp.addElement(null);
							tmp.addElement(new Elt(mere.getId(),2*no+1,gen,mere.getNom(),mere.getPrenom(),chronoMere.getNaissance()+" - "+chronoMere.getDeces()));
						} else if( mere==null && pere==null ) {
							tmp.addElement(null);
							tmp.addElement(null);
						}
					} else {
						personnes.addElement(null);
						tmp.addElement(null);
						tmp.addElement(null);
					}
				}

				//Ajouter dans l'arbre
				ga.setGeneration(personnes,gen);

				//Passer  la gnration suivante
				generation=new Vector(tmp);
				gen++;
			}
		} catch(Exception ex) {
			ex.printStackTrace();
		}
		return ga;
	}

	public GraphicDescendantArbre chargerDescendantGraphics() {
		GraphicDescendantArbre ga=new GraphicDescendantArbre();

		try {
			//Racine
			ga.setRacine(new EltDescendant(idBase,genealogie.getEnfants(idBase)));

			//Generation 2
			Vector generation2=(ga.getRacine()).getEnfants();
			Vector gen2=new Vector();
			for(int cpt=0;cpt<generation2.size();cpt++) {
				Personne pu=(Personne)generation2.elementAt(cpt);
				gen2.addElement(new EltDescendant(pu.getId(),genealogie.getEnfants(pu.getId())));
			}
			ga.setGeneration(gen2,2);

/*			//Generation 3
			Vector generation3=(ga.getGeneration(2)).getEnfants();
			Vector gen3=new Vector();
			for(int cpt=0;cpt<generation3.size();cpt++) {
				PersonneUtils pu=(PersonneUtils)generation3.elementAt(cpt);
				gen3.addElement(new EltDescendant(pu.getId(),genealogie.getEnfants(pu.getId())));
			}
			ga.setGeneration(gen3,3);

			//Generation 4
			Vector generation4=(ga.getGeneration(3)).getEnfants();
			Vector gen4=new Vector();
			for(int cpt=0;cpt<generation4.size();cpt++) {
				PersonneUtils pu=(PersonneUtils)generation4.elementAt(cpt);
				gen4.addElement(new EltDescendant(pu.getId(),genealogie.getEnfants(pu.getId())));
			}
			ga.setGeneration(gen4,4);*/

		} catch(Exception ex) {
			ex.printStackTrace();
		}
		return ga;
	}

	public Vector chargerFiches() {
		Vector personnes=new Vector();

/*		try {
			personnes.addElement(new Elt(idBase,numeroBase,generationBase));

			Vector generation=new Vector();
			int gen=generationBase+1;
			generation.addElement(new Elt(idBase,numeroBase,generationBase));
			while( generation.size()>0 ) {
				Vector tmp=new Vector();
				for(int cpt=0;cpt<generation.size();cpt++) {
					Elt p=(Elt)generation.elementAt(cpt);
					int id=p.getIdPersonne();
					int no=p.getNumeroPersonne();
					PersonneUtils pere=genealogie.getPere(id);
					PersonneUtils mere=genealogie.getMere(id);
					if( mere!=null && pere!=null ) {
						personnes.addElement(new Fiche(pere.getId(),mere.getId(),2*no,2*no+1,gen));
						tmp.addElement(new Elt(pere.getId(),2*no,gen));
						tmp.addElement(new Elt(mere.getId(),2*no+1,gen));
					} else if( pere!=null && mere==null ) {
						personnes.addElement(new Fiche(pere.getId(),0,2*no,0,gen));
						tmp.addElement(new Elt(pere.getId(),2*no,gen));
					} else if( mere!=null && pere==null ) {
						personnes.addElement(new Fiche(0,mere.getId(),0,2*no+1,gen));
						tmp.addElement(new Elt(mere.getId(),2*no+1,gen));
					}
				}
				generation=new Vector(tmp);
				gen++;
			}
		} catch(Exception ex) {
			ex.printStackTrace();
		}*/
		return personnes;
	}
}