package org.genealogie.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import org.genealogie.log.Log;

public class DirectJdbcConnSelector implements IJdbcConnectionSelector {
    private String url;
	private String user;
	private String password;
	
	public DirectJdbcConnSelector(String pDriver,String pUrl,String pUser,String pPwd) {
		url = pUrl;
		user = pUser;
		password = pPwd;
		try {
			Class.forName(pDriver);
		}
		catch(ClassNotFoundException e) {
			Log.log(e);
			throw new RuntimeException(e);
		}
	}
	
	public Connection getConnection() throws SQLException {
		return DriverManager.getConnection(url,user,password);
	}

}
