package org.genealogie.utils;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.genealogie.log.Log;

public class JdbcConnectionSelector implements IJdbcConnectionSelector {
	public static final int J2EE_DATASOURCE = 1;

	public static final int JDBC_DIRECT = 2;

	private static JdbcConnectionSelector instance = new JdbcConnectionSelector();

	private IJdbcConnectionSelector selector = null;

	private JdbcConnectionSelector() {
	}

	public static JdbcConnectionSelector getInstance() {
		return instance;
	}

	public synchronized void setStrategy(int pStrategy, Object[] pParams) {
		if (selector == null) {
			switch (pStrategy) {
			case J2EE_DATASOURCE:
				selector = new StrutsJdbcConnSelector((DataSource) pParams[0]);
				break;
			case JDBC_DIRECT:
				selector = new DirectJdbcConnSelector((String) pParams[0],
						(String) pParams[1], (String) pParams[2],
						(String) pParams[3]);
				break;
			}
		}
	}

	public Connection getConnection() throws SQLException {
		if (selector == null) {
			Log.log("Le slectionneur de connexion n'est pas initialis. Il faut appeler la mthode setStrategie avant getConnection.");
			throw new RuntimeException();
		}
		return selector.getConnection();
	}

	public boolean isInitialized() {
		return (selector != null);
	}
}
