package org.genealogie.web;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.arbre.ChargementArbre;
import org.genealogie.metier.arbre.EltDescendant;
import org.genealogie.metier.arbre.GraphicDescendantArbre;
import org.genealogie.metier.dao.FamillesDAO;
import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.metier.modele.Mariage;
import org.genealogie.metier.modele.Personne;
import org.genealogie.utils.EltArbreDescendant;

public final class ArbreDescendantPersonneAction extends CheckAction {

	private Vector filtrerArbre(FamillesDAO famille,Vector personnes,Vector familles) {
		for(int cpt=0;cpt<personnes.size();cpt++) {
			EltArbreDescendant ead=(EltArbreDescendant)personnes.elementAt(cpt);

			//Personne
			Vector famillesIds=famille.getFamillesPersonne(ead.getId());
			boolean contient=false;
			for(int c=0;c<famillesIds.size();c++) {
				int familleId=((Integer)famillesIds.elementAt(c)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient ) {
				ead.setId(0);
			}

			//Conjoint
			famillesIds=famille.getFamillesPersonne(ead.getIdConjoint());
			contient=false;
			for(int c=0;c<famillesIds.size();c++) {
				int familleId=((Integer)famillesIds.elementAt(c)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient ) {
				ead.setIdConjoint(0);
			}

			Vector enfants1=null;
			if( ead.getId()==0 && ead.getIdConjoint()==0 ) {
				enfants1=new Vector();
				ead.setEnfants(enfants1);
			} else
				enfants1=ead.getEnfants();
			for(int cpt1=0;cpt1<enfants1.size();cpt1++) {
				EltArbreDescendant ead1=(EltArbreDescendant)enfants1.elementAt(cpt1);

				//Personne
				famillesIds=famille.getFamillesPersonne(ead1.getId());
				contient=false;
				for(int c1=0;c1<famillesIds.size();c1++) {
					int familleId=((Integer)famillesIds.elementAt(c1)).intValue();
					if( contient(familleId,familles) ) {
						contient=true;
						break;
					}
				}
				if( !contient ) {
					ead1.setId(0);
				}

				//Conjoint
				famillesIds=famille.getFamillesPersonne(ead1.getIdConjoint());
				contient=false;
				for(int c1=0;c1<famillesIds.size();c1++) {
					int familleId=((Integer)famillesIds.elementAt(c1)).intValue();
					if( contient(familleId,familles) ) {
						contient=true;
						break;
					}
				}
				if( !contient ) {
					ead1.setIdConjoint(0);
				}

				Vector enfants2=null;
				if( ead1.getId()==0 && ead1.getIdConjoint()==0 ) {
					enfants2=new Vector();
					ead1.setEnfants(enfants2);
				} else
					enfants2=ead1.getEnfants();
				for(int cpt2=0;cpt2<enfants2.size();cpt2++) {
					EltArbreDescendant ead2=(EltArbreDescendant)enfants2.elementAt(cpt2);

					//Personne
					famillesIds=famille.getFamillesPersonne(ead2.getId());
					contient=false;
					for(int c2=0;c2<famillesIds.size();c2++) {
						int familleId=((Integer)famillesIds.elementAt(c2)).intValue();
						if( contient(familleId,familles) ) {
							contient=true;
							break;
						}
					}
					if( !contient ) {
						ead2.setId(0);
					}

					//Conjoint
					famillesIds=famille.getFamillesPersonne(ead2.getIdConjoint());
					contient=false;
					for(int c2=0;c2<famillesIds.size();c2++) {
						int familleId=((Integer)famillesIds.elementAt(c2)).intValue();
						if( contient(familleId,familles) ) {
							contient=true;
							break;
						}
					}
					if( !contient ) {
						ead2.setIdConjoint(0);
					}

					Vector enfants3=null;
					if( ead2.getId()==0 && ead2.getIdConjoint()==0 ) {
						enfants3=new Vector();
						ead2.setEnfants(enfants2);
					} else
						enfants3=ead2.getEnfants();
					for(int cpt3=0;cpt3<enfants3.size();cpt3++) {
						EltArbreDescendant ead3=(EltArbreDescendant)enfants3.elementAt(cpt3);

						//Personne
						famillesIds=famille.getFamillesPersonne(ead3.getId());
						contient=false;
						for(int c3=0;c3<famillesIds.size();c3++) {
							int familleId=((Integer)famillesIds.elementAt(c3)).intValue();
							if( contient(familleId,familles) ) {
								contient=true;
								break;
							}
						}
						if( !contient ) {
							ead3.setId(0);
						}

						//Conjoint
						famillesIds=famille.getFamillesPersonne(ead3.getIdConjoint());
						contient=false;
						for(int c3=0;c3<famillesIds.size();c3++) {
							int familleId=((Integer)famillesIds.elementAt(c3)).intValue();
							if( contient(familleId,familles) ) {
								contient=true;
								break;
							}
						}
						if( !contient ) {
							ead3.setIdConjoint(0);
						}
					}
				}
			}
		}

		return personnes;
	}

	private Vector getMariagesSansEnfant(GenealogieDAO genealogie,int personneId) {
		boolean isHomme=genealogie.isHomme(personneId);
		Vector mariages=genealogie.getMariages(personneId,isHomme?1:0);
		Vector conjoints=new Vector();
		for(int cpt=0;cpt<mariages.size();cpt++) {
			Mariage mu=(Mariage)mariages.elementAt(cpt);
			Vector enfants=null;
			if( isHomme )
				enfants=genealogie.getEnfants(personneId,mu.getIdConjoint());
			else
				enfants=genealogie.getEnfants(mu.getIdConjoint(),personneId);
			if( enfants.size()==0 ) {
				Personne conjoint=genealogie.getPersonne(mu.getIdConjoint());
				conjoints.addElement(conjoint);
			}
		}
		return conjoints;
	}

	private Hashtable classerEnfantsDescendants(GenealogieDAO genealogie,Vector enfants) {
		Hashtable enfs=new Hashtable();

		for(int cpt=0;cpt<enfants.size();cpt++) {
			Personne pu=(Personne)enfants.elementAt(cpt);
			Personne pere=genealogie.getPere(pu.getId());
			
			String pereString="";
			if( genealogie.isEnfantNaturel(pu.getId()) )
				pereString="Pre inconnu$0";
			else
				pereString="?$0";

			if( pere!=null ) {
				pereString=pere.getNom()+" "+getPrenomCourt(pere.getPrenom())+"$"+pere.getId();
			}
			Personne mere=genealogie.getMere(pu.getId());
			String mereString="?$0";
			if( mere!=null ) {
				mereString=mere.getNom()+" "+getPrenomCourt(mere.getPrenom())+"$"+mere.getId();
			}
			if( enfs.get(pereString+"|"+mereString)==null ) {
				Vector v=new Vector();
				v.addElement(pu);
				enfs.put(pereString+"|"+mereString,v);
			} else {
				((Vector)enfs.get(pereString+"|"+mereString)).addElement(pu);
			}
		}

		return enfs;
	}

	private Hashtable classerEnfants(GenealogieDAO genealogie,Vector enfants) {
		Hashtable enfs=new Hashtable();

		for(int cpt=0;cpt<enfants.size();cpt++) {
			Personne pu=(Personne)enfants.elementAt(cpt);
			Personne pere=genealogie.getPere(pu.getId());
			
			String pereString="";
			if( genealogie.isEnfantNaturel(pu.getId()) )
				pereString="Pre inconnu$0";
			else
				pereString="?$0";

			if( pere!=null ) {
				pereString=pere.getNom()+" "+getPrenomCourt(pere.getPrenom())+"$"+pere.getId();
			}
			Personne mere=genealogie.getMere(pu.getId());
			String mereString="?$0";
			if( mere!=null ) {
				mereString=mere.getNom()+" "+getPrenomCourt(mere.getPrenom())+"$"+mere.getId();
			}
			if( enfs.get(pereString+"|"+mereString)==null ) {
				Vector v=new Vector();
				v.addElement(pu);
				enfs.put(pereString+"|"+mereString,v);
			} else {
				((Vector)enfs.get(pereString+"|"+mereString)).addElement(pu);
			}
		}

		return enfs;
	}

	private String getPrenomCourt(String prenom) {
		int indice=0;
		if( (indice=prenom.indexOf(" "))!=-1 ) {
			prenom=prenom.substring(0,indice);
		}
		return prenom;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {

		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id
			int id=0;
			if( request.getParameterValues("id")!=null ) {
				try {
					id=Integer.parseInt(request.getParameterValues("id")[0]);
				} catch(Exception ex) {}
			}

			if( id==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			GenealogieDAO genealogie=new GenealogieDAO();
			FamillesDAO familles=new FamillesDAO();

			//Vrifier les droits d'accs
			if( !isAccesTotal(request) ) {
				Vector famillesIds=familles.getFamillesPersonne(id);
				boolean contient=false;
				for(int cpt=0;cpt<famillesIds.size();cpt++) {
					int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
					if( contient(familleId,getAuth(request).getFamilles()) ) {
						contient=true;
						break;
					}
				}
				if( !contient ) {
					setNoCache(response);
					return (mapping.findForward("accueil"));
				}
			}

			ChargementArbre ca=new ChargementArbre(id,0,0,genealogie);
			GraphicDescendantArbre ga=ca.chargerDescendantGraphics();
			Vector personnes=new Vector();

			EltDescendant ed=ga.getRacine();
			Personne ps=genealogie.getPersonne(ed.getIdPersonne());

			Vector enfants=ed.getEnfants();
			int indice=0;
			if( enfants.size()!=0 ) {
				Hashtable enfantsHash=classerEnfantsDescendants(genealogie,enfants);

				for(Enumeration e=enfantsHash.keys();e.hasMoreElements();) {
					String cle=(String)e.nextElement();
					String pere=cle.substring(0,cle.indexOf("|"));
					int idPere=0;
					if( (indice=pere.indexOf("$"))!=-1 ) {
						try {
							idPere=Integer.parseInt(pere.substring(indice+1));
						} catch(Exception ex1) {}
						pere=pere.substring(0,indice);
					}
					String mere=cle.substring(cle.indexOf("|")+1);
					int idMere=0;
					if( (indice=mere.indexOf("$"))!=-1 ) {
						try {
							idMere=Integer.parseInt(mere.substring(indice+1));
						} catch(Exception ex1) {}
						mere=mere.substring(0,indice);
					}
					EltArbreDescendant elt=new EltArbreDescendant(idPere,pere,idMere,mere);
					personnes.addElement(elt);

					enfants=(Vector)enfantsHash.get(cle);

					for(int cpt=0;cpt<enfants.size();cpt++) {
						Personne pu=(Personne)enfants.elementAt(cpt);

						Vector enfants1=genealogie.getEnfants(pu.getId());
						if( enfants1.size()!=0 ) {
							Hashtable enfants1Hash=classerEnfants(genealogie,enfants1);

							for(Enumeration e1=enfants1Hash.keys();e1.hasMoreElements();) {
								String cle1=(String)e1.nextElement();
								String pere1=cle1.substring(0,cle1.indexOf("|"));
								int idPere1=0;
								if( (indice=pere1.indexOf("$"))!=-1 ) {
									try {
										idPere1=Integer.parseInt(pere1.substring(indice+1));
									} catch(Exception ex1) {}
									pere1=pere1.substring(0,indice);
								}
								String mere1=cle1.substring(cle1.indexOf("|")+1);
								int idMere1=0;
								if( (indice=mere1.indexOf("$"))!=-1 ) {
									try {
										idMere1=Integer.parseInt(mere1.substring(indice+1));
									} catch(Exception ex1) {}
									mere1=mere1.substring(0,indice);
								}
								EltArbreDescendant elt1=new EltArbreDescendant(idPere1,pere1,idMere1,mere1);
								elt.addEnfant(elt1);

								enfants1=(Vector)enfants1Hash.get(cle1);

								for(int cpt1=0;cpt1<enfants1.size();cpt1++) {
										Personne pu1=(Personne)enfants1.elementAt(cpt1);

									Vector enfants2=genealogie.getEnfants(pu1.getId());
									if( enfants2.size()!=0 ) {
										Hashtable enfants2Hash=classerEnfants(genealogie,enfants2);

										for(Enumeration e2=enfants2Hash.keys();e2.hasMoreElements();) {
											String cle2=(String)e2.nextElement();

											String pere2=cle2.substring(0,cle2.indexOf("|"));
											int idPere2=0;
											if( (indice=pere2.indexOf("$"))!=-1 ) {
												try {
													idPere2=Integer.parseInt(pere2.substring(indice+1));
												} catch(Exception ex1) {}
												pere2=pere2.substring(0,indice);
											}
											String mere2=cle2.substring(cle2.indexOf("|")+1);
											int idMere2=0;
											if( (indice=mere2.indexOf("$"))!=-1 ) {
												try {
													idMere2=Integer.parseInt(mere2.substring(indice+1));
												} catch(Exception ex1) {}
												mere2=mere2.substring(0,indice);
											}
											EltArbreDescendant elt2=new EltArbreDescendant(idPere2,pere2,idMere2,mere2);
											elt1.addEnfant(elt2);

											enfants2=(Vector)enfants2Hash.get(cle2);
											for(int cpt2=0;cpt2<enfants2.size();cpt2++) {
												Personne pu2=(Personne)enfants2.elementAt(cpt2);
												elt2.addEnfant(new EltArbreDescendant(pu2.getId(),pu2.getNom()+" "+getPrenomCourt(pu2.getPrenom()),0,""));
											}

											Vector conjoints=getMariagesSansEnfant(genealogie,pu1.getId());
											for(int cpt2=0;cpt2<conjoints.size();cpt2++) {
												if( genealogie.isHomme(pu1.getId()) ) {
													Personne conjoint=(Personne)conjoints.elementAt(cpt2);
													elt2.addEnfant(new EltArbreDescendant(pu1.getId(),pu1.getNom()+" "+getPrenomCourt(pu1.getPrenom()),conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom())));
												} else {
													Personne conjoint=(Personne)conjoints.elementAt(cpt2);
													elt2.addEnfant(new EltArbreDescendant(conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom()),pu1.getId(),pu1.getNom()+" "+getPrenomCourt(pu1.getPrenom())));
												}
											}
										}
									} else {
										//Personnes n'ayant pas d'enfants
										Vector conjoints=getMariagesSansEnfant(genealogie,pu1.getId());
										if( conjoints.size()==0 ) {
											elt1.addEnfant(new EltArbreDescendant(pu1.getId(),pu1.getNom()+" "+getPrenomCourt(pu1.getPrenom()),0,""));
										} else {
											for(int cpt2=0;cpt2<conjoints.size();cpt2++) {
												if( genealogie.isHomme(pu1.getId()) ) {
													Personne conjoint=(Personne)conjoints.elementAt(cpt2);
													elt1.addEnfant(new EltArbreDescendant(pu1.getId(),pu1.getNom()+" "+getPrenomCourt(pu1.getPrenom()),conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom())));
												} else {
													Personne conjoint=(Personne)conjoints.elementAt(cpt2);
													elt1.addEnfant(new EltArbreDescendant(conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom()),pu1.getId(),pu1.getNom()+" "+getPrenomCourt(pu1.getPrenom())));
												}
											}
										}
									}
								}
							}
							Vector conjoints=getMariagesSansEnfant(genealogie,pu.getId());
							for(int cpt1=0;cpt1<conjoints.size();cpt1++) {
								if( genealogie.isHomme(pu.getId()) ) {
									Personne conjoint=(Personne)conjoints.elementAt(cpt1);
									elt.addEnfant(new EltArbreDescendant(pu.getId(),pu.getNom()+" "+getPrenomCourt(pu.getPrenom()),conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom())));
								} else {
									Personne conjoint=(Personne)conjoints.elementAt(cpt1);
									elt.addEnfant(new EltArbreDescendant(conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom()),pu.getId(),pu.getNom()+" "+getPrenomCourt(pu.getPrenom())));
								}
							}
						} else {
							//Personnes n'ayant pas d'enfants
							Vector conjoints=getMariagesSansEnfant(genealogie,pu.getId());
							if( conjoints.size()==0 ) {
								elt.addEnfant(new EltArbreDescendant(pu.getId(),pu.getNom()+" "+getPrenomCourt(pu.getPrenom()),0,""));
							} else {
								for(int cpt1=0;cpt1<conjoints.size();cpt1++) {
									if( genealogie.isHomme(pu.getId()) ) {
										Personne conjoint=(Personne)conjoints.elementAt(cpt1);
										elt.addEnfant(new EltArbreDescendant(pu.getId(),pu.getNom()+" "+getPrenomCourt(pu.getPrenom()),conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom())));
									} else {
										Personne conjoint=(Personne)conjoints.elementAt(cpt1);
										elt.addEnfant(new EltArbreDescendant(conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom()),pu.getId(),pu.getNom()+" "+getPrenomCourt(pu.getPrenom())));
									}
								}
							}
						}
					}
				}
				Vector conjoints=getMariagesSansEnfant(genealogie,ed.getIdPersonne());
				for(int cpt=0;cpt<conjoints.size();cpt++) {
					if( genealogie.isHomme(ed.getIdPersonne()) ) {
						Personne conjoint=(Personne)conjoints.elementAt(cpt);
						personnes.addElement(new EltArbreDescendant(ps.getId(),ps.getNom()+" "+getPrenomCourt(ps.getPrenom()),conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom())));
					} else {
						Personne conjoint=(Personne)conjoints.elementAt(cpt);
						personnes.addElement(new EltArbreDescendant(conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom()),ps.getId(),ps.getNom()+" "+getPrenomCourt(ps.getPrenom())));
					}
				}
			} else {
				//Personnes n'ayant pas d'enfants
				Vector conjoints=getMariagesSansEnfant(genealogie,ed.getIdPersonne());
				if( conjoints.size()==0 ) {
					personnes.addElement(new EltArbreDescendant(ps.getId(),ps.getNom()+" "+getPrenomCourt(ps.getPrenom()),0,""));
				} else {
					for(int cpt=0;cpt<conjoints.size();cpt++) {
						if( genealogie.isHomme(ed.getIdPersonne()) ) {
							Personne conjoint=(Personne)conjoints.elementAt(cpt);
							personnes.addElement(new EltArbreDescendant(ps.getId(),ps.getNom()+" "+getPrenomCourt(ps.getPrenom()),conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom())));
						} else {
							Personne conjoint=(Personne)conjoints.elementAt(cpt);
							personnes.addElement(new EltArbreDescendant(conjoint.getId(),conjoint.getNom()+" "+getPrenomCourt(conjoint.getPrenom()),ps.getId(),ps.getNom()+" "+getPrenomCourt(ps.getPrenom())));
						}
					}
				}
			}

			request.setAttribute("generation1",ps);
			if( !isAccesTotal(request) )
				personnes=filtrerArbre(familles,personnes,getAuth(request).getFamilles());
			request.setAttribute("base",personnes);

			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		}
	}
}