package org.genealogie.web;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.utils.URLEncodingScheme;

public final class RechercherDepartementsAction extends CheckAction {
	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {

		try {
			if( ((RechercherDepartementsForm)form).isNull() ) {
				setNoCache(response);
				return (mapping.findForward("failure"));
			}

			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			StringBuffer chaineRecherche=new StringBuffer();
			String separateur="";
			//Chaine de recherche
			if( ((RechercherDepartementsForm)form).getRechercher()!=null ) {
				chaineRecherche.append(separateur+"rechercher=");
				chaineRecherche.append(URLEncoder.encode(((RechercherDepartementsForm)form).getRechercher(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherDepartementsForm)form).getPays()!=null ) {
				chaineRecherche.append(separateur+"pays=");
				chaineRecherche.append(URLEncoder.encode(((RechercherDepartementsForm)form).getPays(),URLEncodingScheme.SCHEME));
				separateur="&";
			}

			//Page
			int page=0;
			if( ((RechercherDepartementsForm)form).getPage()!=null ) {
				try {
					page=Integer.parseInt(((RechercherDepartementsForm)form).getPage())-1;
					if( page<0 )
						page=0;
				} catch(Exception ex) {}
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			GenealogieDAO genealogie=new GenealogieDAO();
			String nom=((RechercherDepartementsForm)form).getRechercher();
			if( nom!=null ) {
				nom=nom.trim();
				if( nom.equals("") )
					nom=null;
			}
			String pays=((RechercherDepartementsForm)form).getPays();
			if( pays!=null ) {
				pays=pays.trim();
				if( pays.equals("") )
					pays=null;
			}
			Vector departements=null;
			if( nom!=null && pays==null )
				departements=genealogie.getListeDepartements(nom.toUpperCase());
			else if( nom!=null && pays!=null )
				departements=genealogie.getListeDepartements(nom.toUpperCase(),pays.toUpperCase());
			else if( nom==null && pays!=null )
				departements=genealogie.getListeDepartementsPays(pays.toUpperCase());
			Vector resultats=new Vector();
			for(int cpt=page*NB_PAR_PAGES;cpt<departements.size() && cpt<(page*NB_PAR_PAGES+NB_PAR_PAGES);cpt++) {
				resultats.addElement(departements.elementAt(cpt));
			}

			int debut=0;
			int fin=departements.size()/NB_PAR_PAGES;
			if( page-10>=0 )
				debut=page-10;
			if( page+10<=fin )
				fin=page+10;
			if( debut==0 )
				if( (departements.size()/NB_PAR_PAGES)>=20 )
					fin=20;
			if( fin==((departements.size()/NB_PAR_PAGES)) )
				if( (departements.size()/NB_PAR_PAGES)-20>=0 )
					debut=(departements.size()/NB_PAR_PAGES)-20;

			//Envoi des infos  la jsp
			request.setAttribute("result",resultats);
			request.setAttribute("page_debut",new Integer(debut+1));
			if( departements.size()%NB_PAR_PAGES==0 )
				request.setAttribute("page_fin",new Integer(fin));
			else
				request.setAttribute("page_fin",new Integer(fin+1));
			request.setAttribute("page",new Integer(page+1));
			request.setAttribute("nombre",new Integer(departements.size()));
			if( nom!=null && pays!=null )
				request.setAttribute("recherche",nom+" dans le pays "+pays);
			else if( nom==null && pays!=null )
				request.setAttribute("recherche","pays "+pays);
			else if( nom!=null && pays==null )
				request.setAttribute("recherche",nom);
			request.setAttribute("urlRecherche",chaineRecherche.toString());
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		}
	}
}