package org.genealogie.web;

import javax.servlet.http.HttpServletRequest;

import org.apache.regexp.RE;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public final class RechercherIdsPersonnesConsanguiniteForm extends ActionForm  {

	private String action = "Create";

	private String nom = null;

	private String prenom = null;

	private String dateDebut = null;

	private String dateFin = null;

	private String ville = null;

	private String page = null;

	private String naissance = null;

	private String bapteme = null;

	private String mariage = null;

	private String deces = null;

	private String inhumation = null;

	private String etape = null;

	private String id = null;

	public String getAction() {
		return this.action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getNom() {
		return this.nom;
	}

	public void setNom(String nom) {
		this.nom = nom;
	}

	public String getPrenom() {
		return this.prenom;
	}

	public void setPrenom(String prenom) {
		this.prenom = prenom;
	}

	public String getDateDebut() {
		return this.dateDebut;
	}

	public void setDateDebut(String dateDebut) {
		this.dateDebut = dateDebut;
	}

	public String getDateFin() {
		return this.dateFin;
	}

	public void setDateFin(String dateFin) {
		this.dateFin = dateFin;
	}

	public String getVille() {
		return this.ville;
	}

	public void setVille(String ville) {
		this.ville = ville;
	}

	public void setEtape(String etape) {
		this.etape = etape;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getPage() {
		return this.page;
	}

	public void setPage(String page) {
		this.page = page;
	}

	public String getNaissance() {
		return this.naissance;
	}

	public void setNaissance(String naissance) {
		this.naissance = naissance;
	}

	public String getBapteme() {
		return this.bapteme;
	}

	public void setBapteme(String bapteme) {
		this.bapteme = bapteme;
	}

	public String getMariage() {
		return this.mariage;
	}

	public void setMariage(String mariage) {
		this.mariage = mariage;
	}

	public String getDeces() {
		return this.deces;
	}

	public void setDeces(String deces) {
		this.deces = deces;
	}

	public String getInhumation() {
		return this.inhumation;
	}

	public void setInhumation(String inhumation) {
		this.inhumation = inhumation;
	}

	public String getEtape() {
		return etape;
	}

	public String getId() {
		return id;
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
		this.action = "Create";
		this.nom=null;
		this.prenom=null;
		this.dateDebut=null;
		this.dateFin=null;
		this.ville=null;
		this.page=null;
		this.naissance=null;
		this.bapteme=null;
		this.mariage=null;
		this.deces=null;
		this.inhumation=null;
		this.etape=null;
		this.id=null;
	}

	public boolean isNull() {
		if( nom==null && prenom==null && dateDebut==null && dateFin==null
				&& ville==null && page==null && naissance==null && bapteme==null
				&& mariage==null && deces==null && inhumation==null )
			return true;
		return false;
	}

	private boolean isDateValide(String chaineDate) {
		try {
			RE annee = new RE("^(\\d{4})$");
			RE moisAnnee = new RE("^(\\d{2}\\d{4})$");
			RE jourMoisAnnee = new RE("^(\\d{2}\\d{2}\\d{4})$");

			if( annee.match(chaineDate) )
				return true;
			if( moisAnnee.match(chaineDate) )
				return true;
			if( jourMoisAnnee.match(chaineDate) )
				return true;
		} catch(Exception ex) {
		}
		return false;
	}

	private boolean isTypeValide(String ctype) {
		if( ctype.equals(RechercherPersonnesChronologiqueAction.NAISSANCE) )
			return true;
		if( ctype.equals(RechercherPersonnesChronologiqueAction.BAPTEME) )
			return true;
		if( ctype.equals(RechercherPersonnesChronologiqueAction.MARIAGE) )
			return true;
		if( ctype.equals(RechercherPersonnesChronologiqueAction.DECES) )
			return true;
		if( ctype.equals(RechercherPersonnesChronologiqueAction.INHUMATION) )
			return true;
		return false;
	}

	public ActionErrors validate(ActionMapping mapping,HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();

		if( isNull() )
			return errors;

		if( dateDebut!=null && !dateDebut.equals("") && !isDateValide(dateDebut) )
	            errors.add("dateDebut",new ActionMessage("error.date.format"));

		if( dateFin!=null && !dateFin.equals("") && !isDateValide(dateFin) )
	            errors.add("dateFin",new ActionMessage("error.date.format"));

		return errors;
	}
}
