package org.genealogie.web;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.DocumentsDAO;
import org.genealogie.metier.dao.GenealogieDAO;

public final class AccueilAction extends CheckAction {
	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		
		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			// Save our logged-in user in the session
			HttpSession session = request.getSession();
	
			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}
			GenealogieDAO genealogie=new GenealogieDAO();
			DocumentsDAO documents=new DocumentsDAO();
			if( isAccesTotal(request) ) {
				int nb=genealogie.getNombrePersonnes();
				int nb_actes=genealogie.getNombreActes();
				int nb_documents=documents.getNombreDocuments();
				request.setAttribute("nb",new Integer(nb));
				request.setAttribute("nb-actes",new Integer(nb_actes));
				request.setAttribute("nb-documents",new Integer(nb_documents));
			} else {
				int nb=genealogie.getNombrePersonnesFamille(getAuth(request).getFamilles());
				int nb_actes=genealogie.getNombreActes(getAuth(request).getFamilles(),getAuth(request).getBorneSup());
				int nb_documents=documents.getNombreDocuments(getAuth(request).getFamilles(),
						getAuth(request).getTypesDocuments());
				request.setAttribute("nb",new Integer(nb));
				request.setAttribute("nb-actes",new Integer(nb_actes));
				request.setAttribute("nb-documents",new Integer(nb_documents));
			}
			request.setAttribute("auth",getAuth(request));
				
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("request".equals(mapping.getScope()))
					request.removeAttribute(mapping.getAttribute());
				else
					session.removeAttribute(mapping.getAttribute());
			}
	
			setNoCache(response);
			return (mapping.findForward("success"));
		}
		catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		}
	}
}