package org.genealogie.web;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.FamillesDAO;
import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.metier.dao.TablesRegistresDAO;
import org.genealogie.metier.modele.Acte;
import org.genealogie.metier.modele.Auth;
import org.genealogie.metier.modele.CommuneDetail;
import org.genealogie.metier.modele.RegistreActe;
import org.genealogie.metier.modele.TypesActe;

public final class FicheTableAction extends CheckAction {

	private Hashtable typeActs = new Hashtable();

	private RegistreActe filtrerRegistreActe(RegistreActe rau,FamillesDAO familles,Vector listeFamillesAutorisees) {
		//Personne
		Vector famillesIds=familles.getFamillesPersonne(rau.getPersonne());
		boolean contient=false;
		for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
			int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
			if( contient(familleId,listeFamillesAutorisees) ) {
				contient=true;
				break;
			}
		}
		if( !contient )
			rau.setPersonne(0);

		//Pere
		famillesIds=familles.getFamillesPersonne(rau.getIdPere());
		contient=false;
		for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
			int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
			if( contient(familleId,listeFamillesAutorisees) ) {
				contient=true;
				break;
			}
		}
		if( !contient )
			rau.setIdPere(0);

		//Mere
		famillesIds=familles.getFamillesPersonne(rau.getIdMere());
		contient=false;
		for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
			int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
			if( contient(familleId,listeFamillesAutorisees) ) {
				contient=true;
				break;
			}
		}
		if( !contient )
			rau.setIdMere(0);

		return rau;
	}

	public java.sql.Date getDate(String chaineDate) {
		java.sql.Date cDate=null;

		if( chaineDate==null || chaineDate.equals("") )
			return null;

		try {
			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			java.util.Date d=sdf.parse(chaineDate,pos);
			cDate=new java.sql.Date(d.getTime());

		} catch(Exception ex) {
		}
		return cDate;
	}

	private void loadTypeActe(GenealogieDAO genealogie) {
		Vector ta=genealogie.getTypesActe();
		for(int cpt=0;cpt<ta.size();cpt++) {
			TypesActe tau=(TypesActe)ta.elementAt(cpt);
			typeActs.put(new Integer(tau.getId()),tau.getNom());
		}
	}

	private boolean compareDate(java.sql.Date date1,java.sql.Date date2) {
		long time1=date1.getTime();
		long time2=date2.getTime();
		long diff=0;
		if( time1>time2 )
			diff=time1-time2;
		else
			diff=time2-time1;
		if( diff/(24*3600*1000)>=0 && diff/(24*3600*1000)<=3 )
			return true;
		return false;
	}

	private int getActeTableId(GenealogieDAO genealogie,int personneId,java.sql.Date dateActe,int lieuIdActe,String type) {
		try {
			Vector actes=genealogie.getListeActes(personneId);
			for(int cpt=0;cpt<actes.size();cpt++) {
				Acte au=(Acte)actes.elementAt(cpt);
				String typeActe=(String)typeActs.get(new Integer(au.getTypeId()));
				if( au.getLieuId()==lieuIdActe && compareDate(au.getDate(),dateActe)
									&& typeActe.equals(type) ) {
					return au.getId();
				}
			}
		} catch(Exception ex) {
			ex.printStackTrace();
			Log.log(ex);
		}
		return 0;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {

		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id
			int id=0;
			if( request.getParameterValues("id")!=null ) {
				try {
					id=Integer.parseInt(request.getParameterValues("id")[0]);
				} catch(Exception ex) {}
			}

			if( id==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			TablesRegistresDAO registres=new TablesRegistresDAO();
			GenealogieDAO genealogie=new GenealogieDAO();
			FamillesDAO familles=new FamillesDAO();
			loadTypeActe(genealogie);
			RegistreActe rau=registres.getTableElement(id);

			if( !isAccesTotal(request) ) {
				Auth auth=getAuth(request);
				Vector pays=auth.getPays();
				Vector departements=auth.getDepartements();
				Vector communes=auth.getCommunes();
				Vector communesFamilles=auth.getCommunesFamilles();
				CommuneDetail commune=genealogie.getDetailCommune(rau.getLieuId());
				boolean ok=false;

				if( pays.size()>0 ) {
					for(int cpt=0;cpt<pays.size();cpt++) {
						int idPays=((Integer)pays.elementAt(cpt)).intValue();
						if( commune.getPaysId()==idPays ) {
							ok=true;
							break;
						}
					}
				}

				if( !ok && departements.size()>0 ) {
					for(int cpt=0;cpt<departements.size();cpt++) {
						int idDepartement=((Integer)departements.elementAt(cpt)).intValue();
						if( commune.getDepartementId()==idDepartement ) {
							ok=true;
							break;
						}
					}
				}

				if( !ok && communes.size()>0 ) {
					for(int cpt=0;cpt<communes.size();cpt++) {
						int idCommune=((Integer)communes.elementAt(cpt)).intValue();
						if( commune.getId()==idCommune ) {
							ok=true;
							break;
						}
					}
				}

				if( !ok && communesFamilles.size()>0 ) {
					for(int cpt=0;cpt<communesFamilles.size();cpt++) {
						int idCommune=((Integer)communesFamilles.elementAt(cpt)).intValue();
						if( commune.getId()==idCommune ) {
							ok=true;
							break;
						}
					}
				}

				if( !ok ) {
					setNoCache(response);
					return (mapping.findForward("accueil"));
				}
			}

			if( rau.getType().equals("Mariage civil") || rau.getType().equals("Mariage religieux") ) {
				int idC=rau.getCorrespondance();
				RegistreActe rau1=registres.getTableElement(idC);
				//Envoi des infos  la jsp
				request.setAttribute("fiche",new Integer(2));
				if( !isAccesTotal(request) ) {
					request.setAttribute("personne1",filtrerRegistreActe(rau,familles,getAuth(request).getFamilles()));
					request.setAttribute("personne2",filtrerRegistreActe(rau1,familles,getAuth(request).getFamilles()));
					int idPersonne=0;
					if( rau.getPersonne()!=0 )
						idPersonne=rau.getPersonne();
					else if( rau1.getPersonne()!=0 )
						idPersonne=rau1.getPersonne();
					int idActe=getActeTableId(genealogie,idPersonne,rau.getDate(),rau.getLieuId(),rau.getType());
					request.setAttribute("acte",new Integer(idActe));
				} else {
					request.setAttribute("personne1",rau);
					request.setAttribute("personne2",rau1);
					int idActe=getActeTableId(genealogie,rau.getPersonne(),rau.getDate(),rau.getLieuId(),rau.getType());
					request.setAttribute("acte",new Integer(idActe));
				}
			} else {
				request.setAttribute("fiche",new Integer(1));
				if( !isAccesTotal(request) )
					request.setAttribute("personne1",filtrerRegistreActe(rau,familles,getAuth(request).getFamilles()));
				else
					request.setAttribute("personne1",rau);
				int idActe=getActeTableId(genealogie,rau.getPersonne(),rau.getDate(),rau.getLieuId(),rau.getType());
				request.setAttribute("acte",new Integer(idActe));
			}
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		}
	}
}