package org.genealogie.web;

import java.io.IOException;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.FamillesDAO;
import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.metier.modele.Personne;

public final class RechercherPersonnesParenteAction extends CheckAction {

	private Vector filtrerPersonnes(FamillesDAO famille,Vector personnes,Vector familles) {
		for(int cpt=0;cpt<personnes.size();cpt++) {
			Personne pu=(Personne)personnes.elementAt(cpt);
			Vector famillesIds=famille.getFamillesPersonne(pu.getId());
			boolean contient=false;
			for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
				int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient )
				pu.setId(0);
		}
		return personnes;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		try {
			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id
			int id=0;
			if( request.getParameterValues("id")!=null ) {
				try {
					id=Integer.parseInt(request.getParameterValues("id")[0]);
				} catch(Exception ex) {}
			}

			if( id==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			try {
				GenealogieDAO genealogie=new GenealogieDAO();
				FamillesDAO familles=new FamillesDAO();

				//Vrifier les droits d'accs
				if( !isAccesTotal(request) ) {
					Vector famillesIds=familles.getFamillesPersonne(id);
					boolean contient=false;
					for(int cpt=0;cpt<famillesIds.size();cpt++) {
						int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
						if( contient(familleId,getAuth(request).getFamilles()) ) {
							contient=true;
							break;
						}
					}
					if( !contient ) {
						setNoCache(response);
						return (mapping.findForward("accueil"));
					}
				}

				Personne base=genealogie.getPersonne(id);

				if( base!=null ) {
					//Freres
					Vector resultatsFreres=genealogie.getFreresSoeurs(id);
					resultatsFreres=filtrerPersonnes(familles,resultatsFreres,getAuth(request).getFamilles());

					//Oncles & tantes
					Personne pere=genealogie.getPere(id);
					Personne mere=genealogie.getMere(id);
					int pereId=0;
					if( pere!=null )
						pereId=pere.getId();
					int mereId=0;
					if( mere!=null )
						mereId=mere.getId();
					Vector freresSoeurs1=genealogie.getFreresSoeurs(pereId);
					Vector freresSoeurs2=genealogie.getFreresSoeurs(mereId);
					Vector resultatsOnclesTantes=new Vector();
					for(int cpt=0;cpt<freresSoeurs1.size();cpt++) {
						resultatsOnclesTantes.addElement(freresSoeurs1.elementAt(cpt));
					}
					for(int cpt=0;cpt<freresSoeurs2.size();cpt++) {
						resultatsOnclesTantes.addElement(freresSoeurs2.elementAt(cpt));
					}
					resultatsOnclesTantes=filtrerPersonnes(familles,resultatsOnclesTantes,getAuth(request).getFamilles());

					//Neveux
					Vector freresSoeurs=genealogie.getFreresSoeurs(id);
					Vector resultatsNeveux=new Vector();
					for(int cpt=0;cpt<freresSoeurs.size();cpt++) {
						Personne pu=(Personne)freresSoeurs.elementAt(cpt);
						Vector enfants=genealogie.getEnfants(pu.getId());
						for(int cpt1=0;cpt1<enfants.size();cpt1++) {
							resultatsNeveux.addElement(enfants.elementAt(cpt1));
						}
					}
					resultatsNeveux=filtrerPersonnes(familles,resultatsNeveux,getAuth(request).getFamilles());

					//Cousins & cousines
					/*pereId=(genealogie.getPere(id)).getId();
					mereId=(genealogie.getMere(id)).getId();
					freresSoeurs1=genealogie.getFreresSoeurs(pereId);
					freresSoeurs2=genealogie.getFreresSoeurs(mereId);*/
					Vector resultatsCousins=new Vector();
					for(int cpt=0;cpt<freresSoeurs1.size();cpt++) {
						Personne pu=(Personne)freresSoeurs1.elementAt(cpt);
						Vector enfants=genealogie.getEnfants(pu.getId());
						for(int cpt1=0;cpt1<enfants.size();cpt1++) {
							resultatsCousins.addElement(enfants.elementAt(cpt1));
						}
					}
					for(int cpt=0;cpt<freresSoeurs2.size();cpt++) {
						Personne pu=(Personne)freresSoeurs2.elementAt(cpt);
						Vector enfants=genealogie.getEnfants(pu.getId());
						for(int cpt1=0;cpt1<enfants.size();cpt1++) {
							resultatsCousins.addElement(enfants.elementAt(cpt1));
						}
					}
					resultatsCousins=filtrerPersonnes(familles,resultatsCousins,getAuth(request).getFamilles());

					request.setAttribute("recherche",base.getNom()+" "+base.getPrenom());
					request.setAttribute("nb",new Integer(resultatsFreres.size()+resultatsOnclesTantes.size()+resultatsNeveux.size()+resultatsCousins.size()));
					request.setAttribute("freres",resultatsFreres);
					request.setAttribute("oncles",resultatsOnclesTantes);
					request.setAttribute("neveux",resultatsNeveux);
					request.setAttribute("cousins",resultatsCousins);
				} else {
				}

			} catch (Exception ex) {
				ex.printStackTrace();
				Log.log(ex);
			}
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}