/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class Jpeg {
    public static void StandardUsage() {
        System.out.println("JpegEncoder for Java(tm) Version 0.9");
        System.out.println("");
        System.out.println("Program usage: java Jpeg \"InputImage\".\"ext\" Quality [\"OutputFile\"[.jpg]]");
        System.out.println("");
        System.out.println("Where \"InputImage\" is the name of an existing image in the current directory.");
        System.out.println("  (\"InputImage may specify a directory, too.) \"ext\" must be .tif, .gif,");
        System.out.println("  or .jpg.");
        System.out.println("Quality is an integer (0 to 100) that specifies how similar the compressed");
        System.out.println("  image is to \"InputImage.\"  100 is almost exactly like \"InputImage\" and 0 is");
        System.out.println("  most dissimilar.  In most cases, 70 - 80 gives very good results.");
        System.out.println("\"OutputFile\" is an optional argument.  If \"OutputFile\" isn't specified, then");
        System.out.println("  the input file name is adopted.  This program will NOT write over an existing");
        System.out.println("  file.  If a directory is specified for the input image, then \"OutputFile\"");
        System.out.println("  will be written in that directory.  The extension \".jpg\" may automatically be");
        System.out.println("  added.");
        System.out.println("");
        System.out.println("Copyright 1998 BioElectroMech and James R. Weeks.  Portions copyright IJG and");
        System.out.println("  Florian Raemy, LCAV.  See license.txt for details.");
        System.out.println("Visit BioElectroMech at www.obrador.com.  Email James@obrador.com.");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Image image = null;
        FileOutputStream fileOutputStream = null;
        String string = new String();
        int n = 80;
        if (stringArray.length < 2) {
            Jpeg.StandardUsage();
        }
        if (!(stringArray[0].endsWith(".jpg") || stringArray[0].endsWith(".tif") || stringArray[0].endsWith(".gif"))) {
            Jpeg.StandardUsage();
        }
        if (stringArray.length < 3) {
            string = stringArray[0].substring(0, stringArray[0].lastIndexOf(".")) + ".jpg";
        } else {
            string = stringArray[2];
            if (string.endsWith(".tif") || string.endsWith(".gif")) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            if (!string.endsWith(".jpg")) {
                string = string.concat(".jpg");
            }
        }
        File file = new File(string);
        int n2 = 1;
        while (file.exists()) {
            file = new File(string.substring(0, string.lastIndexOf(".")) + n2++ + ".jpg");
            if (n2 <= 100) continue;
            System.exit(0);
        }
        File file2 = new File(stringArray[0]);
        if (file2.exists()) {
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                Jpeg.StandardUsage();
            }
            image = Toolkit.getDefaultToolkit().getImage(stringArray[0]);
            JpegEncoder jpegEncoder = new JpegEncoder(image, n, fileOutputStream);
            jpegEncoder.Compress();
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        } else {
            System.out.println("I couldn't find " + stringArray[0] + ". Is it in another directory?");
        }
        System.exit(0);
    }
}

