/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Table;
import org.hsqldb.Trigger;

class TriggerDef
extends Thread {
    static final int NUM_TRIGGER_OPS = 3;
    static final int NUM_TRIGS = 12;
    static final int INSERT_AFTER = 0;
    static final int DELETE_AFTER = 1;
    static final int UPDATE_AFTER = 2;
    static final int INSERT_BEFORE = 3;
    static final int DELETE_BEFORE = 4;
    static final int UPDATE_BEFORE = 5;
    static final int INSERT_AFTER_ROW = 6;
    static final int DELETE_AFTER_ROW = 7;
    static final int UPDATE_AFTER_ROW = 8;
    static final int INSERT_BEFORE_ROW = 9;
    static final int DELETE_BEFORE_ROW = 10;
    static final int UPDATE_BEFORE_ROW = 11;
    String name;
    String when;
    String operation;
    boolean forEachRow;
    Table table;
    Trigger trig;
    String fire;
    int vectorIndx;
    Object[] rowForTrigger;
    protected boolean busy;
    protected boolean valid;

    public TriggerDef(String string, String string2, String string3, boolean bl, Table table, Trigger trigger, String string4) {
        this.name = string.toUpperCase();
        this.when = string2.toUpperCase();
        this.operation = string3.toUpperCase();
        this.forEachRow = bl;
        this.table = table;
        this.trig = trigger;
        this.fire = string4;
        this.vectorIndx = this.SqlToIndex();
        this.busy = false;
        this.valid = this.vectorIndx >= 0;
    }

    public StringBuffer toBuf() {
        StringBuffer stringBuffer = new StringBuffer("CREATE TRIGGER ");
        stringBuffer.append(this.name);
        stringBuffer.append(" ");
        stringBuffer.append(this.when);
        stringBuffer.append(" ");
        stringBuffer.append(this.operation);
        stringBuffer.append(" ON ");
        stringBuffer.append(this.table.getName());
        if (this.forEachRow) {
            stringBuffer.append(" FOR EACH ROW ");
        }
        stringBuffer.append(" CALL ");
        stringBuffer.append(this.fire);
        return stringBuffer;
    }

    public int SqlToIndex() {
        int n = this.operation.equals("INSERT") ? 0 : (this.operation.equals("DELETE") ? 1 : (this.operation.equals("UPDATE") ? 2 : -1));
        if (this.when.equals("BEFORE")) {
            n += 3;
        } else if (!this.when.equals("AFTER")) {
            n = -1;
        }
        if (this.forEachRow) {
            n += 6;
        }
        return n;
    }

    public void run() {
        boolean bl = true;
        while (bl) {
            this.pop();
        }
    }

    public synchronized void pop() {
        if (!this.busy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.trig.fire(this.name, this.table.getName(), this.rowForTrigger);
        this.busy = false;
        this.notify();
    }

    public synchronized void push(Object[] objectArray) {
        if (this.busy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.busy = true;
        this.rowForTrigger = objectArray;
        this.notify();
    }

    public static int numTrigs() {
        return 12;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public boolean isValid() {
        return this.valid;
    }
}

