/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

import Acme.Crypto.BlockCipher;
import Acme.Crypto.CbcBlockCipher;
import Acme.Crypto.Cipher;
import Acme.Crypto.StreamCipher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedOutputStream
extends FilterOutputStream {
    private BlockCipher blockCipher;
    private StreamCipher streamCipher;
    private Cipher cipher;
    private CbcBlockCipher cbcBlockCipher;
    private int blockSize;
    private int cryptoSize;
    private byte[] clearText;
    private byte[] cipherText;
    private int byteCount;
    private boolean encrypting = true;

    public EncryptedOutputStream(BlockCipher blockCipher, OutputStream out) throws IOException {
        super(out);
        this.blockCipher = blockCipher;
        this.blockSize = blockCipher.blockSize();
        this.cbcBlockCipher = new CbcBlockCipher(blockCipher);
        this.cryptoSize = this.blockSize;
        this.clearText = new byte[this.blockSize];
        this.cipherText = new byte[this.blockSize];
        this.byteCount = 0;
        this.cipher = blockCipher;
        out.write(this.cbcBlockCipher.setRandomIv(), 0, this.blockSize);
    }

    public EncryptedOutputStream(StreamCipher streamCipher, OutputStream out) {
        super(out);
        this.streamCipher = streamCipher;
        this.blockSize = 1;
        this.cipher = streamCipher;
    }

    public void setKey(String keyStr) {
        this.cipher.setKey(keyStr);
    }

    public void setEncrypting(boolean encrypting) throws IOException {
        if (this.encrypting && !encrypting) {
            this.flush();
        }
        this.encrypting = encrypting;
    }

    private void sendBlock() throws IOException {
        int i = this.byteCount;
        while (i < this.cryptoSize) {
            this.clearText[i] = (byte)(Math.random() * 256.0);
            ++i;
        }
        this.cbcBlockCipher.encrypt(this.clearText, 0, this.cipherText, 0);
        this.out.write(this.cipherText, 0, this.blockSize);
        this.out.write((byte)this.byteCount);
        this.byteCount = 0;
    }

    public void write(int b) throws IOException {
        if (this.encrypting) {
            if (this.blockCipher != null) {
                this.clearText[this.byteCount++] = (byte)b;
                if (this.byteCount >= this.cryptoSize) {
                    this.sendBlock();
                    return;
                }
            } else {
                this.out.write(this.streamCipher.encrypt((byte)b));
            }
            return;
        }
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.encrypting) {
            if (this.blockCipher != null) {
                int i = off;
                while (i < off + len) {
                    this.clearText[this.byteCount++] = b[i];
                    if (this.byteCount >= this.cryptoSize) {
                        this.sendBlock();
                    }
                    ++i;
                }
                return;
            }
            byte[] cipherText = new byte[len];
            this.streamCipher.encrypt(b, off, cipherText, 0, len);
            this.out.write(cipherText, 0, len);
            return;
        }
        this.out.write(b, off, len);
    }

    public void flush() throws IOException {
        if (this.encrypting && this.blockCipher != null && this.byteCount != 0) {
            this.sendBlock();
        }
        this.out.flush();
    }
}

