/*
 * Decompiled with CFR 0.152.
 */
package Acme.Nnrpd;

import Acme.LruHashtable;
import Acme.Nnrpd.NewsDbArticle;
import Acme.Nnrpd.NewsDbGroup;
import java.util.Hashtable;

public class ArticleCache {
    private int aCacheSize;
    private int maxArtSize;
    private Hashtable articles = new Hashtable();
    private LruHashtable groupArtNumTable;
    private LruHashtable messageIdTable;
    private int usage;
    private int firstNumber;
    private int lastNumber;

    public ArticleCache(int aCacheSize, int maxArtSize) {
        this.aCacheSize = aCacheSize;
        this.maxArtSize = maxArtSize;
        int numArtsEstimate = aCacheSize / 2000;
        this.groupArtNumTable = new LruHashtable(numArtsEstimate);
        this.messageIdTable = new LruHashtable(numArtsEstimate);
    }

    public NewsDbArticle getArticle(NewsDbGroup group, int artNum) {
        Integer n = (Integer)this.groupArtNumTable.get(this.groupArtNumKey(group, artNum));
        if (n == null) {
            return null;
        }
        return (NewsDbArticle)this.articles.get(n);
    }

    public NewsDbArticle getArticle(String messageId) {
        Integer n = (Integer)this.messageIdTable.get(messageId);
        if (n == null) {
            return null;
        }
        return (NewsDbArticle)this.articles.get(n);
    }

    public void addArticle(NewsDbArticle article, NewsDbGroup group, int artNum) {
        Integer n = this.addArticle(article);
        if (n == null) {
            return;
        }
        this.groupArtNumTable.put(this.groupArtNumKey(group, artNum), n);
    }

    public void addArticle(NewsDbArticle article, String messageId) {
        Integer n = this.addArticle(article);
        if (n == null) {
            return;
        }
        this.messageIdTable.put(messageId, n);
    }

    private Integer addArticle(NewsDbArticle article) {
        int len = article.getText().length();
        if (len > this.maxArtSize) {
            return null;
        }
        Integer l = new Integer(this.lastNumber++);
        this.articles.put(l, article);
        this.usage += len;
        while (this.usage > this.aCacheSize) {
            Integer f = new Integer(this.firstNumber++);
            if (article == null) continue;
            article = (NewsDbArticle)this.articles.get(f);
            len = article.getText().length();
            this.usage -= len;
            this.articles.remove(f);
        }
        return l;
    }

    private Integer groupArtNumKey(NewsDbGroup group, int artNum) {
        return new Integer(group.getName().hashCode() ^ artNum);
    }
}

