/*
 * Decompiled with CFR 0.152.
 */
package Acme.Nnrpd;

import Acme.Nnrpd.ArticleCache;
import Acme.Nnrpd.LocalNewsDb;
import Acme.Nnrpd.NewsDb;
import Acme.Nnrpd.NewsDbException;
import Acme.Nnrpd.NnrpdException;
import Acme.Nnrpd.NnrpdSession;
import Acme.Nnrpd.ProxyNewsDb;
import Acme.Syslog;
import Acme.SyslogException;
import Acme.Utils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Nnrpd {
    private static final String progName = "Nnrpd";
    private int port;
    private int aCacheSize;
    private int maxArtSize;
    private int oCacheSize;
    private String proxyHost;
    private boolean debug;
    private Syslog syslog;
    private NewsDb newsDb;
    private ArticleCache articleCache;
    private boolean newsDbPostingOk;

    public static void main(String[] args) {
        int port = 119;
        int aCacheSize = 10000000;
        int maxArtSize = 100000;
        int oCacheSize = 50000;
        String proxyHost = null;
        boolean debug = false;
        int argc = args.length;
        int argn = 0;
        while (argn < argc && args[argn].charAt(0) == '-') {
            if (args[argn].equals("-p") && argn + 1 < argc) {
                if ((port = Utils.parseInt(args[++argn], -1)) == -1) {
                    Nnrpd.usage();
                }
            } else if (args[argn].equals("-a") && argn + 1 < argc) {
                if ((aCacheSize = Utils.parseInt(args[++argn], -1)) == -1) {
                    Nnrpd.usage();
                }
            } else if (args[argn].equals("-o") && argn + 1 < argc) {
                if ((oCacheSize = Utils.parseInt(args[++argn], -1)) == -1) {
                    Nnrpd.usage();
                }
            } else if (args[argn].equals("-h") && argn + 1 < argc) {
                proxyHost = args[++argn];
            } else if (args[argn].equals("-d")) {
                debug = true;
            } else {
                Nnrpd.usage();
            }
            ++argn;
        }
        if (argn != argc) {
            Nnrpd.usage();
        }
        try {
            Nnrpd nnrpd = new Nnrpd(port, aCacheSize, maxArtSize, oCacheSize, proxyHost, debug);
            nnrpd.serve();
        }
        catch (NnrpdException e) {
            System.err.println(e);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void usage() {
        System.err.println("usage:  Nnrpd [-p port] [-a art-cachesize] [-o ov-cachesize] [-h proxyhost]");
        System.err.println("");
        System.err.println("  port:");
        System.err.println("    Normally netnews servers run on port " + 119 + ", which is where the");
        System.err.println("    readers look for them.  You can run this on a different port if");
        System.err.println("    you like, perhaps for debugging.");
        System.err.println("  art-cachesize:");
        System.err.println("    How many bytes of articles to cache.  Default is " + 10000000 + ".");
        System.err.println("  ov-cachesize:");
        System.err.println("    How many overview entries to cache.  Default is " + 50000 + ".");
        System.err.println("  proxyhost:");
        System.err.println("    The remote news server to connect to, for proxy mode.  Syntax");
        System.err.println("    is a hostname, or hostname:port for ports other than " + 119 + ".");
        System.err.println("");
        System.err.println("For more information see the web page,");
        System.err.println("http://www.acme.com/java/software/Package-Acme.Nnrpd.html");
        System.exit(1);
    }

    public Nnrpd(int port, int aCacheSize, int maxArtSize, int oCacheSize, String proxyHost, boolean debug) throws NnrpdException {
        this.port = port;
        this.aCacheSize = aCacheSize;
        this.maxArtSize = maxArtSize;
        this.oCacheSize = oCacheSize;
        this.proxyHost = proxyHost;
        this.debug = debug;
        try {
            this.syslog = new Syslog(progName, 0, 56);
        }
        catch (SyslogException e) {
            throw new NnrpdException("can't initialize syslog: " + e);
        }
        this.articleCache = new ArticleCache(aCacheSize, maxArtSize);
        try {
            this.newsDb = proxyHost != null ? new ProxyNewsDb(proxyHost, oCacheSize) : new LocalNewsDb(oCacheSize);
            this.newsDbPostingOk = this.newsDb.getPostingOk();
            return;
        }
        catch (NewsDbException e) {
            throw new NnrpdException("problem initializing news db: " + e);
        }
    }

    public void serve() throws NnrpdException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(this.port, 1000);
        }
        catch (IOException e) {
            this.error("problem getting server socket: " + e);
            return;
        }
        try {
            try {
                while (true) {
                    try {
                        while (true) {
                            Socket socket = serverSocket.accept();
                            new NnrpdSession(this, this.newsDb, this.newsDbPostingOk, this.articleCache, socket);
                        }
                    }
                    catch (IOException e) {
                        if (e.getMessage().endsWith("Interrupted system call")) continue;
                        throw e;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.error("problem doing accept: " + e);
                Object var3_7 = null;
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
    }

    void debug(String message) throws NnrpdException {
        if (this.debug) {
            this.log(7, message);
        }
    }

    void info(String message) throws NnrpdException {
        this.log(6, message);
    }

    void notice(String message) throws NnrpdException {
        this.log(5, message);
    }

    void warning(String message) throws NnrpdException {
        this.log(4, message);
    }

    void error(String message) throws NnrpdException {
        this.log(3, message);
    }

    void crit(String message) throws NnrpdException {
        this.log(2, message);
    }

    void alert(String message) throws NnrpdException {
        this.log(1, message);
    }

    void emerg(String message) throws NnrpdException {
        this.log(0, message);
    }

    private void log(int priority, String message) throws NnrpdException {
        try {
            this.syslog.syslog(priority, message);
            return;
        }
        catch (SyslogException e) {
            throw new NnrpdException("syslog problem: " + e);
        }
    }
}

