/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownServiceException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Vector;

public class PostURLConnection {
    private URL url;
    private boolean doInput = false;
    private boolean doOutput = true;
    private boolean useCaches = false;
    private Vector reqHeaderNames = new Vector();
    private Vector reqHeaderValues = new Vector();
    private Vector resHeaderNames;
    private Vector resHeaderValues;
    private Socket socket;
    private OutputStream out;
    private InputStream in;
    private boolean connected = false;
    private boolean inputStarted = false;

    public PostURLConnection(URL url) {
        this.url = url;
    }

    public void connect() throws IOException {
        String protocol;
        if (this.connected) {
            return;
        }
        if (!this.useCaches) {
            this.setRequestProperty("Pragma", "no-cache");
        }
        if (!(protocol = this.url.getProtocol()).equals("http")) {
            throw new UnknownServiceException("unknown protocol");
        }
        String host = this.url.getHost();
        int port = this.url.getPort();
        if (port == -1) {
            port = 80;
        }
        String file = this.url.getFile();
        this.socket = new Socket(host, port);
        this.out = this.socket.getOutputStream();
        PrintStream pout = new PrintStream(this.out);
        String method = this.doOutput ? "POST" : "GET";
        pout.println(String.valueOf(method) + " " + file + " HTTP/1.0");
        int i = 0;
        while (i < this.reqHeaderNames.size()) {
            String name = (String)this.reqHeaderNames.elementAt(i);
            String value = (String)this.reqHeaderValues.elementAt(i);
            pout.println(String.valueOf(name) + ": " + value);
            ++i;
        }
        pout.println("");
        pout.flush();
        this.connected = true;
    }

    private void startInput() throws IOException {
        this.connect();
        if (this.inputStarted) {
            return;
        }
        this.in = this.socket.getInputStream();
        this.resHeaderNames = new Vector();
        this.resHeaderValues = new Vector();
        DataInputStream din = new DataInputStream(this.in);
        String line = din.readLine();
        while ((line = din.readLine()) != null && line.length() != 0) {
            int colonBlank = line.indexOf(": ");
            if (colonBlank == -1) continue;
            String name = line.substring(0, colonBlank);
            String value = line.substring(colonBlank + 2);
            this.resHeaderNames.addElement(name.toLowerCase());
            this.resHeaderValues.addElement(value);
        }
        this.inputStarted = true;
    }

    public void close() throws IOException {
        if (!this.connected) {
            return;
        }
        this.out.close();
        if (this.inputStarted) {
            this.in.close();
        }
        this.socket.close();
    }

    public URL getURL() {
        return this.url;
    }

    public int getContentLength() throws IOException {
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getContentType() throws IOException {
        return this.getHeaderField("content-type");
    }

    public String getHeaderField(String name) throws IOException {
        int i;
        if (this.resHeaderNames == null) {
            this.startInput();
        }
        if ((i = this.resHeaderNames.indexOf(name.toLowerCase())) == -1) {
            return null;
        }
        return (String)this.resHeaderValues.elementAt(i);
    }

    public int getHeaderFieldInt(String name, int def) throws IOException {
        try {
            return Integer.parseInt(this.getHeaderField(name));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public long getHeaderFieldDate(String name, long def) throws IOException {
        try {
            return DateFormat.getDateInstance().parse(this.getHeaderField(name)).getTime();
        }
        catch (ParseException e) {
            throw new IOException(e.toString());
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new UnknownServiceException("connection doesn't support input");
        }
        this.startInput();
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new UnknownServiceException("connection doesn't support output");
        }
        this.connect();
        return this.out;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.url;
    }

    public void setDoInput(boolean doInput) {
        if (this.connected) {
            throw new IllegalAccessError("already connected");
        }
        this.doInput = doInput;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public void setDoOutput(boolean doOutput) {
        if (this.connected) {
            throw new IllegalAccessError("already connected");
        }
        this.doOutput = doOutput;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public void setUseCaches(boolean useCaches) {
        if (this.connected) {
            throw new IllegalAccessError("already connected");
        }
        this.useCaches = useCaches;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public void setRequestProperty(String name, String value) {
        if (this.connected) {
            throw new IllegalAccessError("already connected");
        }
        this.reqHeaderNames.addElement(name);
        this.reqHeaderValues.addElement(value);
    }

    public String getRequestProperty(String name) {
        if (this.connected) {
            throw new IllegalAccessError("already connected");
        }
        int i = this.reqHeaderNames.indexOf(name);
        if (i == -1) {
            return null;
        }
        return (String)this.reqHeaderValues.elementAt(i);
    }
}

