/*
 * Decompiled with CFR 0.152.
 */
package Acme.Widgets;

import Acme.GuiUtils;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class ImageLabel
extends Canvas {
    private Image image;
    private int width = -1;
    private int height = -1;

    public ImageLabel(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.invalidate();
        this.image = image;
        this.height = -1;
        this.width = -1;
        this.changeSize(image.getWidth(this), image.getHeight(this));
        this.repaint();
    }

    private void changeSize(int w, int h) {
        if (w == -1 || h == -1) {
            return;
        }
        this.width = w;
        this.height = h;
        this.resize(this.width, this.height);
        GuiUtils.packWindow(this);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        return new Dimension(this.width, this.height);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        boolean allbitsFlag;
        boolean errorFlag = (infoflags & 0x40) != 0;
        boolean abortFlag = (infoflags & 0x80) != 0;
        boolean widthFlag = (infoflags & 1) != 0;
        boolean heightFlag = (infoflags & 2) != 0;
        boolean somebitsFlag = (infoflags & 8) != 0;
        boolean framebitsFlag = (infoflags & 0x10) != 0;
        boolean bl = allbitsFlag = (infoflags & 0x20) != 0;
        if (errorFlag || abortFlag) {
            this.setImage(GuiUtils.brokenIcon(this));
            return false;
        }
        if (widthFlag || heightFlag || framebitsFlag || allbitsFlag) {
            this.changeSize(w, h);
        }
        if (framebitsFlag || allbitsFlag) {
            this.repaint();
            return false;
        }
        if (somebitsFlag) {
            this.repaint(100L);
        }
        return true;
    }
}

