/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

import Acme.Crypto.BlockCipher;
import Acme.Crypto.CryptoUtils;

public class IdeaCipher
extends BlockCipher {
    private int[] encryptKeys = new int[52];
    private int[] decryptKeys = new int[52];
    private int[] tempShorts = new int[4];

    public IdeaCipher(String keyStr) {
        super(16, 8);
        this.setKey(keyStr);
    }

    public IdeaCipher(byte[] key) {
        super(16, 8);
        this.setKey(key);
    }

    public void setKey(byte[] key) {
        int k1 = 0;
        while (k1 < 8) {
            this.encryptKeys[k1] = (key[2 * k1] & 0xFF) << 8 | key[2 * k1 + 1] & 0xFF;
            ++k1;
        }
        while (k1 < 52) {
            this.encryptKeys[k1] = (this.encryptKeys[k1 - 8] << 9 | this.encryptKeys[k1 - 7] >>> 7) & 0xFFFF;
            ++k1;
        }
        k1 = 0;
        int k2 = 51;
        int t1 = IdeaCipher.mulinv(this.encryptKeys[k1++]);
        int t2 = -this.encryptKeys[k1++];
        int t3 = -this.encryptKeys[k1++];
        this.decryptKeys[k2--] = IdeaCipher.mulinv(this.encryptKeys[k1++]);
        this.decryptKeys[k2--] = t3;
        this.decryptKeys[k2--] = t2;
        this.decryptKeys[k2--] = t1;
        int j = 1;
        while (j < 8) {
            t1 = this.encryptKeys[k1++];
            this.decryptKeys[k2--] = this.encryptKeys[k1++];
            this.decryptKeys[k2--] = t1;
            t1 = IdeaCipher.mulinv(this.encryptKeys[k1++]);
            t2 = -this.encryptKeys[k1++];
            t3 = -this.encryptKeys[k1++];
            this.decryptKeys[k2--] = IdeaCipher.mulinv(this.encryptKeys[k1++]);
            this.decryptKeys[k2--] = t2;
            this.decryptKeys[k2--] = t3;
            this.decryptKeys[k2--] = t1;
            ++j;
        }
        t1 = this.encryptKeys[k1++];
        this.decryptKeys[k2--] = this.encryptKeys[k1++];
        this.decryptKeys[k2--] = t1;
        t1 = IdeaCipher.mulinv(this.encryptKeys[k1++]);
        t2 = -this.encryptKeys[k1++];
        t3 = -this.encryptKeys[k1++];
        this.decryptKeys[k2--] = IdeaCipher.mulinv(this.encryptKeys[k1++]);
        this.decryptKeys[k2--] = t3;
        this.decryptKeys[k2--] = t2;
        this.decryptKeys[k2--] = t1;
    }

    public void encrypt(byte[] clearText, int clearOff, byte[] cipherText, int cipherOff) {
        CryptoUtils.squashBytesToShorts(clearText, clearOff, this.tempShorts, 0, 4);
        this.idea(this.tempShorts, this.tempShorts, this.encryptKeys);
        CryptoUtils.spreadShortsToBytes(this.tempShorts, 0, cipherText, cipherOff, 4);
    }

    public void decrypt(byte[] cipherText, int cipherOff, byte[] clearText, int clearOff) {
        CryptoUtils.squashBytesToShorts(cipherText, cipherOff, this.tempShorts, 0, 4);
        this.idea(this.tempShorts, this.tempShorts, this.decryptKeys);
        CryptoUtils.spreadShortsToBytes(this.tempShorts, 0, clearText, clearOff, 4);
    }

    private void idea(int[] inShorts, int[] outShorts, int[] keys) {
        int x1 = inShorts[0];
        int x2 = inShorts[1];
        int x3 = inShorts[2];
        int x4 = inShorts[3];
        int k = 0;
        int round = 0;
        while (round < 8) {
            x1 = IdeaCipher.mul(x1 & 0xFFFF, keys[k++]);
            x2 += keys[k++];
            int n = k++;
            x4 = IdeaCipher.mul(x4 & 0xFFFF, keys[k++]);
            int t2 = x1 ^ (x3 += keys[n]);
            t2 = IdeaCipher.mul(t2 & 0xFFFF, keys[k++]);
            int t1 = t2 + (x2 ^ x4);
            t1 = IdeaCipher.mul(t1 & 0xFFFF, keys[k++]);
            t2 = t1 + t2;
            x1 ^= t1;
            x4 ^= t2;
            t2 ^= x2;
            x2 = x3 ^ t1;
            x3 = t2;
            ++round;
        }
        outShorts[0] = IdeaCipher.mul(x1 & 0xFFFF, keys[k++]) & 0xFFFF;
        outShorts[1] = x3 + keys[k++] & 0xFFFF;
        outShorts[2] = x2 + keys[k++] & 0xFFFF;
        outShorts[3] = IdeaCipher.mul(x4 & 0xFFFF, keys[k++]) & 0xFFFF;
    }

    private static int mul(int a, int b) {
        int ab = a * b;
        if (ab != 0) {
            int hi;
            int lo;
            return lo - hi + ((lo = ab & 0xFFFF) < (hi = ab >>> 16) ? 1 : 0) & 0xFFFF;
        }
        if (a != 0) {
            return 1 - a & 0xFFFF;
        }
        return 1 - b & 0xFFFF;
    }

    private static int mulinv(int x) {
        if (x <= 1) {
            return x;
        }
        int t0 = 1;
        int t1 = 65537 / x;
        int y = 65537 % x & 0xFFFF;
        while (y != 1) {
            int q = x / y;
            t0 = t0 + q * t1 & 0xFFFF;
            if ((x %= y) == 1) {
                return t0;
            }
            q = y / x;
            y %= x;
            t1 = t1 + q * t0 & 0xFFFF;
        }
        return 1 - t1 & 0xFFFF;
    }

    public static void main(String[] args) {
        int a = 0;
        while (a < 65536) {
            int b = IdeaCipher.mulinv(a);
            int c = IdeaCipher.mul(a, b);
            if (c != 1) {
                System.err.println("mul/mulinv flaw: " + a + " * " + b + " = " + c);
            }
            ++a;
        }
    }
}

