/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

import Acme.Crypto.CryptoUtils;
import Acme.Crypto.Hash;

public class ShaHash
extends Hash {
    private static final boolean USE_MODIFIED_SHA = true;
    private static final int SHA_BLOCKSIZE = 64;
    private static final int SHA_DIGESTSIZE = 20;
    private int[] digest = new int[5];
    private long bitCount;
    private byte[] dataB = new byte[64];
    private int[] dataI = new int[16];
    private static final int K1 = 1518500249;
    private static final int K2 = 1859775393;
    private static final int K3 = -1894007588;
    private static final int K4 = -899497514;
    private static final int h0init = 1732584193;
    private static final int h1init = -271733879;
    private static final int h2init = -1732584194;
    private static final int h3init = 271733878;
    private static final int h4init = -1009589776;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int A;
    private int B;
    private int C;
    private int D;
    private int E;
    private int[] W = new int[80];
    private static int TEST_BLOCK_SIZE = 2000;
    private static int TEST_BYTES = 10000000;
    private static int TEST_BLOCKS = TEST_BYTES / TEST_BLOCK_SIZE;

    public ShaHash() {
        super(20);
        this.reset();
    }

    public void reset() {
        this.shaInit();
    }

    public void add(byte b) {
        byte[] data = new byte[]{b};
        this.add(data, 0, 1);
    }

    public void add(byte[] data, int off, int len) {
        this.shaUpdate(data, off, len);
    }

    protected void prepare() {
        this.shaFinal();
        CryptoUtils.spreadIntsToBytes(this.digest, 0, this.hashBytes, 0, 5);
    }

    private static int f1(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private static int f2(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int f3(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private static int f4(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int rotateL(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    private void subRound1(int count) {
        int temp = ShaHash.rotateL(this.A, 5) + ShaHash.f1(this.B, this.C, this.D) + this.E + this.W[count] + 1518500249;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = temp;
    }

    private void subRound2(int count) {
        int temp = ShaHash.rotateL(this.A, 5) + ShaHash.f2(this.B, this.C, this.D) + this.E + this.W[count] + 1859775393;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = temp;
    }

    private void subRound3(int count) {
        int temp = ShaHash.rotateL(this.A, 5) + ShaHash.f3(this.B, this.C, this.D) + this.E + this.W[count] + -1894007588;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = temp;
    }

    private void subRound4(int count) {
        int temp = ShaHash.rotateL(this.A, 5) + ShaHash.f4(this.B, this.C, this.D) + this.E + this.W[count] + -899497514;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = temp;
    }

    private void shaInit() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
        this.digest[4] = -1009589776;
        this.bitCount = 0L;
    }

    private void shaTransform() {
        int i = 0;
        while (i < 16) {
            this.W[i] = this.dataI[i];
            ++i;
        }
        while (i < 80) {
            this.W[i] = this.W[i - 3] ^ this.W[i - 8] ^ this.W[i - 14] ^ this.W[i - 16];
            this.W[i] = ShaHash.rotateL(this.W[i], 1);
            ++i;
        }
        this.A = this.digest[0];
        this.B = this.digest[1];
        this.C = this.digest[2];
        this.D = this.digest[3];
        this.E = this.digest[4];
        i = 0;
        while (i < 20) {
            this.subRound1(i);
            ++i;
        }
        while (i < 40) {
            this.subRound2(i);
            ++i;
        }
        while (i < 60) {
            this.subRound3(i);
            ++i;
        }
        while (i < 80) {
            this.subRound4(i);
            ++i;
        }
        this.digest[0] = this.digest[0] + this.A;
        this.digest[1] = this.digest[1] + this.B;
        this.digest[2] = this.digest[2] + this.C;
        this.digest[3] = this.digest[3] + this.D;
        this.digest[4] = this.digest[4] + this.E;
    }

    private void shaUpdate(byte[] buffer, int offset, int count) {
        this.bitCount += (long)(count << 3);
        while (count >= 64) {
            CryptoUtils.copyBlock(buffer, offset, this.dataB, 0, 64);
            CryptoUtils.squashBytesToInts(this.dataB, 0, this.dataI, 0, 16);
            this.shaTransform();
            offset += 64;
            count -= 64;
        }
        CryptoUtils.copyBlock(buffer, offset, this.dataB, 0, count);
    }

    private void shaFinal() {
        int count = (int)(this.bitCount >>> 3) & 0x3F;
        this.dataB[count++] = -128;
        if (count > 56) {
            CryptoUtils.fillBlock(this.dataB, count, (byte)0, 64 - count);
            CryptoUtils.squashBytesToInts(this.dataB, 0, this.dataI, 0, 16);
            this.shaTransform();
            CryptoUtils.fillBlock(this.dataB, 0, (byte)0, 56);
        } else {
            CryptoUtils.fillBlock(this.dataB, count, (byte)0, 56 - count);
        }
        CryptoUtils.squashBytesToInts(this.dataB, 0, this.dataI, 0, 16);
        this.dataI[14] = (int)(this.bitCount >>> 32);
        this.dataI[15] = (int)(this.bitCount & 0xFFFFFFFFFFFFFFFFL);
        this.shaTransform();
    }

    public static void main(String[] args) {
        byte[] newCorrect;
        ShaHash h = new ShaHash();
        h.addASCII("abc");
        byte[] hb = h.get();
        byte[] oldCorrect = new byte[]{1, 100, -72, -87, 20, -51, 42, 94, 116, -60, -9, -1, 8, 44, 77, -105, -15, -19, -8, -128};
        byte[] correct = newCorrect = new byte[]{-87, -103, 62, 54, 71, 6, -127, 106, -70, 62, 37, 113, 120, 80, -62, 108, -100, -48, -40, -99};
        System.out.println("Got:  " + CryptoUtils.toStringBlock(hb));
        System.out.println("Want: " + CryptoUtils.toStringBlock(correct));
        if (!CryptoUtils.equalsBlock(hb, correct)) {
            System.err.println("Error in SHA implementation.");
            System.exit(1);
        }
        byte[] data = new byte[TEST_BLOCK_SIZE];
        CryptoUtils.fillBlock(data, (byte)0);
        System.out.println("SHA time trial.  Processing " + TEST_BYTES + " characters...");
        h.reset();
        int i = TEST_BLOCKS;
        while (i > 0) {
            h.add(data, 0, TEST_BLOCK_SIZE);
            --i;
        }
        h.get();
        System.out.println("Done.");
    }
}

